/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.hex;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteOrder;
import nl.lxtreme.binutils.hex.AbstractReader;
import nl.lxtreme.binutils.hex.util.HexUtils;

public class SRecordReader
extends AbstractReader {
    private static final char PREAMBLE = 'S';
    private Integer address;
    private Integer dataLength;
    private int dataSum;
    private boolean inDataRecord;
    private Integer oldAddress;
    private int oldDataSum;
    private Integer oldDataLength;
    private boolean oldInDataRecord;

    public SRecordReader(Reader reader) {
        super(reader);
    }

    @Override
    public long getAddress() throws IOException {
        if (this.address == null) {
            throw new IOException("Unexpected call to getAddress!");
        }
        return this.address.intValue();
    }

    @Override
    public void mark() throws IOException {
        super.mark();
        this.oldAddress = this.address;
        this.oldDataSum = this.dataSum;
        this.oldDataLength = this.dataLength;
        this.oldInDataRecord = this.inDataRecord;
    }

    @Override
    public int readByte() throws IOException {
        int n;
        do {
            if ((n = this.readSingleByte()) == -1) {
                return -1;
            }
            if (83 == n) {
                this.inDataRecord = this.isDataRecord(this.startNewRecord());
                continue;
            }
            if (this.dataLength == null) continue;
            int n2 = this.reader.read();
            if (n2 == -1) {
                throw new IOException("Unexpected end-of-stream!");
            }
            char[] cArray = new char[]{(char)n, (char)n2};
            int n3 = HexUtils.parseHexByte(cArray);
            if (this.dataLength == 0) {
                int n4 = ~this.dataSum & 0xFF;
                if (n3 == n4) continue;
                throw new IOException("CRC Error! Expected: " + n3 + "; got: " + n4);
            }
            this.dataSum += (byte)n3;
            SRecordReader sRecordReader = this;
            Integer n5 = sRecordReader.dataLength;
            Integer n6 = sRecordReader.dataLength = Integer.valueOf(sRecordReader.dataLength - 1);
            sRecordReader = this;
            n5 = sRecordReader.address;
            n6 = sRecordReader.address = Integer.valueOf(sRecordReader.address + 1);
            if (!this.inDataRecord) continue;
            return n3;
        } while (n != -1);
        throw new IOException("Invalid Intel HEX-file!");
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.address = this.oldAddress;
        this.dataSum = this.oldDataSum;
        this.dataLength = this.oldDataLength;
        this.inDataRecord = this.oldInDataRecord;
    }

    @Override
    protected ByteOrder getByteOrder() {
        return ByteOrder.BIG_ENDIAN;
    }

    private int getAddressLength(int n) {
        int n2 = 2;
        if (n == 2 || n == 8) {
            n2 = 3;
        } else if (n == 3 || n == 7) {
            n2 = 4;
        }
        return n2;
    }

    private boolean isDataRecord(int n) {
        return n == 1 || n == 2 || n == 3;
    }

    private boolean isHeaderRecord(int n) {
        return n == 0;
    }

    private boolean isValidType(int n) {
        return n == 0 || n == 1 || n == 2 || n == 3 || n == 5 || n == 7 || n == 8 || n == 9;
    }

    private int startNewRecord() throws IOException {
        int n = this.reader.read() - 48;
        if (!this.isValidType(n)) {
            throw new IOException("Unknown type: " + n);
        }
        int n2 = HexUtils.parseHexByte(this.reader);
        int n3 = this.getAddressLength(n);
        this.address = HexUtils.parseHexNumber(this.reader, n3);
        this.dataSum = (byte)n2;
        this.dataSum += (byte)((this.address & 0xFF000000) >> 24) + (byte)((this.address & 0xFF0000) >> 16) + (byte)((this.address & 0xFF00) >> 8) + (byte)(this.address & 0xFF);
        this.dataLength = n2 - n3 - 1;
        if (this.dataLength > 0) {
            if (!this.isDataRecord(n) && !this.isHeaderRecord(n)) {
                throw new IOException("Data found while record-type should not have data!");
            }
            SRecordReader sRecordReader = this;
            Integer n4 = sRecordReader.address;
            Integer n5 = sRecordReader.address = Integer.valueOf(sRecordReader.address - 1);
        } else if (this.dataLength == 0 && (this.isDataRecord(n) || this.isHeaderRecord(n))) {
            throw new IOException("No data found while record-type should have data!");
        }
        return n;
    }
}

