/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.hex;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteOrder;
import nl.lxtreme.binutils.hex.AbstractReader;
import nl.lxtreme.binutils.hex.util.HexUtils;

public class IntelHexReader
extends AbstractReader {
    private static final char PREAMBLE = ':';
    private static final int DATA_TYPE = 0;
    private static final int TERMINATION_TYPE = 1;
    private static final int EXTENDED_SEGMENT_ADDRESS_TYPE = 2;
    private static final int START_SEGMENT_ADDRESS_TYPE = 3;
    private static final int EXTENDED_LINEAR_ADDRESS_TYPE = 4;
    private static final int START_LINEAR_ADDRESS_TYPE = 5;
    private Integer segmentBaseAddress;
    private Integer linearAddress;
    private Integer address;
    private Integer dataLength;
    private int dataSum;
    private Integer oldAddress;
    private int oldDataSum;
    private Integer oldDataLength;

    public IntelHexReader(Reader reader) {
        super(reader);
    }

    @Override
    public long getAddress() throws IOException {
        if (this.address == null) {
            throw new IOException("Unexpected call to getAddress!");
        }
        return this.address.longValue();
    }

    @Override
    public void mark() throws IOException {
        super.mark();
        this.oldAddress = this.address;
        this.oldDataSum = this.dataSum;
        this.oldDataLength = this.dataLength;
    }

    @Override
    public int readByte() throws IOException {
        int n;
        do {
            if ((n = this.readSingleByte()) == -1) {
                return -1;
            }
            if (58 == n) {
                this.startNewDataRecord();
                continue;
            }
            if (this.dataLength == null) continue;
            char[] cArray = new char[]{(char)n, (char)this.reader.read()};
            if (cArray[1] == '\uffffffff') {
                return -1;
            }
            int n2 = HexUtils.parseHexByte(cArray);
            if (this.dataLength == 0) {
                int n3 = ~this.dataSum + 1 & 0xFF;
                if (n2 == n3) continue;
                throw new IOException("CRC Error! Expected: 0x" + Integer.toHexString(n2) + "; got: 0x" + Integer.toHexString(n3));
            }
            this.dataSum += (byte)n2;
            IntelHexReader intelHexReader = this;
            Integer n4 = intelHexReader.dataLength;
            Integer n5 = intelHexReader.dataLength = Integer.valueOf(intelHexReader.dataLength - 1);
            intelHexReader = this;
            n4 = intelHexReader.address;
            n5 = intelHexReader.address = Integer.valueOf(intelHexReader.address + 1);
            return n2;
        } while (n != -1);
        throw new IOException("Invalid Intel HEX-file!");
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.address = this.oldAddress;
        this.dataSum = this.oldDataSum;
        this.dataLength = this.oldDataLength;
    }

    @Override
    protected ByteOrder getByteOrder() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    private void startNewDataRecord() throws IOException {
        this.dataLength = HexUtils.parseHexByte(this.reader);
        this.address = HexUtils.parseHexWord(this.reader);
        if (this.segmentBaseAddress != null && this.segmentBaseAddress > 0) {
            this.address = this.segmentBaseAddress | this.address;
        } else if (this.linearAddress != null && this.linearAddress > 0) {
            this.address = this.linearAddress << 16 | this.address;
        }
        int n = HexUtils.parseHexByte(this.reader);
        this.dataSum = this.dataLength.byteValue();
        this.dataSum += (byte)((this.address & 0xFF00) >> 8);
        this.dataSum += (byte)(this.address & 0xFF);
        this.dataSum += (byte)n;
        if (0 == n) {
            IntelHexReader intelHexReader = this;
            Integer n2 = intelHexReader.address;
            Integer n3 = intelHexReader.address = Integer.valueOf(intelHexReader.address - 1);
        } else if (2 == n) {
            this.segmentBaseAddress = HexUtils.parseHexWord(this.reader);
            this.dataLength = 0;
        } else if (4 == n) {
            this.linearAddress = HexUtils.parseHexWord(this.reader);
            this.dataLength = 0;
        } else if (1 == n) {
            this.dataLength = 0;
        } else if (5 != n && 3 != n) {
            throw new IOException("Unknown Intel record type: " + n);
        }
    }
}

