/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.elf;

import java.io.IOException;
import java.nio.ByteBuffer;
import nl.lxtreme.binutils.elf.ElfClass;
import nl.lxtreme.binutils.elf.SectionType;

public class SectionHeader {
    private final int nameOffset;
    private String name;
    public final SectionType type;
    public final long flags;
    public final long virtualAddress;
    public final long fileOffset;
    public final long size;
    public final int link;
    public final int info;
    public final long sectionAlignment;
    public final long entrySize;

    public SectionHeader(ElfClass elfClass, ByteBuffer byteBuffer) throws IOException {
        this.nameOffset = byteBuffer.getInt();
        this.type = SectionType.valueOf(byteBuffer.getInt());
        if (elfClass == ElfClass.CLASS_32) {
            this.flags = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            this.virtualAddress = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            this.fileOffset = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            this.size = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
        } else if (elfClass == ElfClass.CLASS_64) {
            this.flags = byteBuffer.getLong();
            this.virtualAddress = byteBuffer.getLong();
            this.fileOffset = byteBuffer.getLong();
            this.size = byteBuffer.getLong();
        } else {
            throw new IOException("Unhandled ELF-class!");
        }
        this.link = byteBuffer.getInt();
        this.info = byteBuffer.getInt();
        if (elfClass == ElfClass.CLASS_32) {
            this.sectionAlignment = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            this.entrySize = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
        } else if (elfClass == ElfClass.CLASS_64) {
            this.sectionAlignment = byteBuffer.getLong();
            this.entrySize = byteBuffer.getLong();
        } else {
            throw new IOException("Unhandled ELF-class!");
        }
    }

    public String getName() {
        return this.name;
    }

    void setName(ByteBuffer byteBuffer) {
        if (this.nameOffset > 0) {
            int n;
            byte[] byArray = byteBuffer.array();
            for (n = this.nameOffset; n < byArray.length && byArray[n] != 0; ++n) {
            }
            this.name = new String(byArray, this.nameOffset, n - this.nameOffset);
        }
    }
}

