/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.elf;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import nl.lxtreme.binutils.elf.DynamicEntry;
import nl.lxtreme.binutils.elf.Header;
import nl.lxtreme.binutils.elf.ProgramHeader;
import nl.lxtreme.binutils.elf.SectionHeader;
import nl.lxtreme.binutils.elf.SectionType;
import nl.lxtreme.binutils.elf.SegmentType;

public class Elf
implements Closeable {
    public final Header header;
    public final ProgramHeader[] programHeaders;
    public final SectionHeader[] sectionHeaders;
    public final DynamicEntry[] dynamicTable;
    private FileChannel channel;

    static int expectByteInRange(int n, int n2, int n3, String string) throws IOException {
        if (n < n2 || n > n3) {
            throw new IOException(string);
        }
        return n;
    }

    static String getZString(byte[] byArray, long l) {
        return Elf.getZString(byArray, (int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    static String getZString(byte[] byArray, int n) {
        int n2;
        for (n2 = n; n2 < byArray.length && byArray[n2] != 0; ++n2) {
        }
        return new String(byArray, n, n2 - n);
    }

    static boolean isBitSet(int n, int n2) {
        return (n & n2) == n2;
    }

    static boolean isBitSet(long l, long l2) {
        return (l & l2) == l2;
    }

    static void readFully(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, String string) throws IOException {
        byteBuffer.rewind();
        int n = readableByteChannel.read(byteBuffer);
        if (n != byteBuffer.limit()) {
            throw new IOException(string + " Read only " + n + " of " + byteBuffer.limit() + " bytes!");
        }
        byteBuffer.flip();
    }

    public Elf(File file) throws IOException {
        this(FileChannel.open(file.toPath(), StandardOpenOption.READ));
    }

    public Elf(FileChannel fileChannel) throws IOException {
        ProgramHeader programHeader;
        Object object;
        int n;
        this.channel = fileChannel;
        this.header = new Header(fileChannel);
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        byteBuffer.order(this.header.elfByteOrder);
        byteBuffer.limit(10);
        Elf.readFully(fileChannel, byteBuffer, "Unable to read entry information!");
        short s = byteBuffer.getShort();
        int n2 = byteBuffer.getShort();
        short s2 = byteBuffer.getShort();
        int n3 = byteBuffer.getShort();
        short s3 = byteBuffer.getShort();
        fileChannel.position(this.header.programHeaderOffset);
        byteBuffer.limit(s);
        this.programHeaders = new ProgramHeader[n2];
        for (n = 0; n < n2; ++n) {
            Elf.readFully(fileChannel, byteBuffer, "Unable to read program header entry #" + n);
            this.programHeaders[n] = new ProgramHeader(this.header.elfClass, byteBuffer);
        }
        fileChannel.position(this.header.sectionHeaderOffset);
        byteBuffer.limit(s2);
        this.sectionHeaders = new SectionHeader[n3 - 1];
        for (n = 0; n < n3; ++n) {
            Elf.readFully(fileChannel, byteBuffer, "Unable to read section header entry #" + n);
            object = new SectionHeader(this.header.elfClass, byteBuffer);
            if (n == 0) {
                if (((SectionHeader)object).type == SectionType.NULL) continue;
                throw new IOException("Invalid section found! First section should always be of type SHT_NULL!");
            }
            this.sectionHeaders[n - 1] = object;
        }
        if (s3 != 0) {
            SectionHeader sectionHeader = this.sectionHeaders[s3 - 1];
            byteBuffer = this.getSection(sectionHeader);
            if (byteBuffer == null) {
                throw new IOException("Unable to get section name table!");
            }
            for (SectionHeader sectionHeader2 : this.sectionHeaders) {
                sectionHeader2.setName(byteBuffer);
            }
        }
        if ((programHeader = this.getProgramHeaderByType(SegmentType.DYNAMIC)) != null) {
            object = new ArrayList();
            byteBuffer = this.getSegment(programHeader);
            if (byteBuffer == null) {
                throw new IOException("Unable to get dynamic segment!");
            }
            int n4 = this.header.is32bit() ? 1 : 0;
            while (byteBuffer.remaining() > 0) {
                long l;
                long l2 = n4 != 0 ? (long)byteBuffer.getInt() : byteBuffer.getLong();
                long l3 = l = n4 != 0 ? (long)byteBuffer.getInt() : byteBuffer.getLong();
                if (l2 == 0L) break;
                DynamicEntry.Tag tag = DynamicEntry.Tag.valueOf((int)l2);
                object.add(new DynamicEntry(tag, l));
            }
            this.dynamicTable = object.toArray(new DynamicEntry[object.size()]);
        } else {
            this.dynamicTable = null;
        }
    }

    public Elf(String string) throws IOException {
        this(new File(string));
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
    }

    protected StringBuilder dumpDynamicEntry(StringBuilder stringBuilder, DynamicEntry dynamicEntry, byte[] byArray) {
        stringBuilder.append(dynamicEntry.getTag());
        stringBuilder.append(" => ");
        if (dynamicEntry.isStringOffset()) {
            stringBuilder.append(Elf.getZString(byArray, dynamicEntry.getValue()));
        } else {
            stringBuilder.append("0x").append(Long.toHexString(dynamicEntry.getValue()));
        }
        return stringBuilder;
    }

    protected StringBuilder dumpProgramHeader(StringBuilder stringBuilder, ProgramHeader programHeader) {
        stringBuilder.append(programHeader.type);
        stringBuilder.append(", offset: 0x").append(Long.toHexString(programHeader.offset));
        stringBuilder.append(", vaddr: 0x").append(Long.toHexString(programHeader.virtualAddress));
        stringBuilder.append(", paddr: 0x").append(Long.toHexString(programHeader.physicalAddress));
        stringBuilder.append(", align: 0x").append(Long.toHexString(programHeader.segmentAlignment));
        stringBuilder.append(", file size: 0x").append(Long.toHexString(programHeader.segmentFileSize));
        stringBuilder.append(", memory size: 0x").append(Long.toHexString(programHeader.segmentMemorySize));
        stringBuilder.append(", flags: ");
        if (Elf.isBitSet(programHeader.flags, 4L)) {
            stringBuilder.append("r");
        } else {
            stringBuilder.append("-");
        }
        if (Elf.isBitSet(programHeader.flags, 2L)) {
            stringBuilder.append("w");
        } else {
            stringBuilder.append("-");
        }
        if (Elf.isBitSet(programHeader.flags, 1L)) {
            stringBuilder.append("x");
        } else {
            stringBuilder.append("-");
        }
        return stringBuilder;
    }

    protected StringBuilder dumpSectionHeader(StringBuilder stringBuilder, SectionHeader sectionHeader) {
        String string = sectionHeader.getName();
        if (string != null) {
            stringBuilder.append(string);
        } else {
            stringBuilder.append(sectionHeader.type);
        }
        stringBuilder.append(", size: 0x").append(Long.toHexString(sectionHeader.size));
        stringBuilder.append(", vaddr: 0x").append(Long.toHexString(sectionHeader.virtualAddress));
        stringBuilder.append(", foffs: 0x").append(Long.toHexString(sectionHeader.fileOffset));
        stringBuilder.append(", align: 0x").append(Long.toHexString(sectionHeader.sectionAlignment));
        if (sectionHeader.link != 0) {
            stringBuilder.append(", link: 0x").append(Long.toHexString(sectionHeader.link));
        }
        if (sectionHeader.info != 0) {
            stringBuilder.append(", info: 0x").append(Long.toHexString(sectionHeader.info));
        }
        if (sectionHeader.entrySize != 0L) {
            stringBuilder.append(", entrySize: 0x").append(Long.toHexString(sectionHeader.entrySize));
        }
        return stringBuilder;
    }

    protected byte[] getDynamicStringTable() throws IOException {
        SectionHeader sectionHeader = this.getSectionHeaderByType(SectionType.STRTAB);
        if (sectionHeader == null) {
            throw new IOException("Unable to get string table for dynamic section!");
        }
        ByteBuffer byteBuffer = this.getSection(sectionHeader);
        if (byteBuffer == null) {
            throw new IOException("Unable to get string table for dynamic section!");
        }
        return byteBuffer.array();
    }

    public ProgramHeader getProgramHeaderByType(SegmentType segmentType) {
        if (segmentType == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        for (ProgramHeader programHeader : this.programHeaders) {
            if (!segmentType.equals(programHeader.type)) continue;
            return programHeader;
        }
        return null;
    }

    public String getProgramInterpreter() throws IOException {
        ProgramHeader programHeader = this.getProgramHeaderByType(SegmentType.INTERP);
        if (programHeader == null) {
            return null;
        }
        ByteBuffer byteBuffer = this.getSegment(programHeader);
        if (byteBuffer == null) {
            throw new IOException("Unable to get program interpreter segment?!");
        }
        return new String(byteBuffer.array(), 0, byteBuffer.remaining());
    }

    public ByteBuffer getSection(SectionHeader sectionHeader) throws IOException {
        if (sectionHeader == null) {
            throw new IllegalArgumentException("Header cannot be null!");
        }
        if (this.channel == null) {
            throw new IOException("ELF file is already closed!");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)sectionHeader.size);
        byteBuffer.order(this.header.elfByteOrder);
        this.channel.position(sectionHeader.fileOffset);
        Elf.readFully(this.channel, byteBuffer, "Unable to read section completely!");
        return byteBuffer;
    }

    public SectionHeader getSectionHeaderByType(SectionType sectionType) {
        if (sectionType == null) {
            throw new IllegalArgumentException("Type cannot be null!");
        }
        for (SectionHeader sectionHeader : this.sectionHeaders) {
            if (!sectionType.equals(sectionHeader.type)) continue;
            return sectionHeader;
        }
        return null;
    }

    public ByteBuffer getSegment(ProgramHeader programHeader) throws IOException {
        if (programHeader == null) {
            throw new IllegalArgumentException("Header cannot be null!");
        }
        if (this.channel == null) {
            throw new IOException("ELF file is already closed!");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)programHeader.segmentFileSize);
        byteBuffer.order(this.header.elfByteOrder);
        this.channel.position(programHeader.offset);
        Elf.readFully(this.channel, byteBuffer, "Unable to read segment completely!");
        return byteBuffer;
    }

    public List<String> getSharedDependencies() throws IOException {
        byte[] byArray = this.getDynamicStringTable();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DynamicEntry dynamicEntry : this.dynamicTable) {
            if (!DynamicEntry.Tag.NEEDED.equals(dynamicEntry.getTag())) continue;
            arrayList.add(Elf.getZString(byArray, (int)dynamicEntry.getValue()));
        }
        return arrayList;
    }

    public boolean isSoname() throws IOException {
        ArrayList arrayList = new ArrayList();
        for (DynamicEntry dynamicEntry : this.dynamicTable) {
            if (!DynamicEntry.Tag.SONAME.equals(dynamicEntry.getTag())) continue;
            return true;
        }
        return false;
    }

    public boolean isTextRel() throws IOException {
        for (DynamicEntry dynamicEntry : this.dynamicTable) {
            if (!DynamicEntry.Tag.TEXTREL.equals(dynamicEntry.getTag())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.header).append('\n');
            stringBuilder.append("Program header:\n");
            for (int i = 0; i < this.programHeaders.length; ++i) {
                stringBuilder.append('\t');
                this.dumpProgramHeader(stringBuilder, this.programHeaders[i]);
                stringBuilder.append('\n');
            }
            byte[] byArray = this.getDynamicStringTable();
            stringBuilder.append("Dynamic table:\n");
            for (DynamicEntry dynamicEntry : this.dynamicTable) {
                stringBuilder.append('\t');
                this.dumpDynamicEntry(stringBuilder, dynamicEntry, byArray);
                stringBuilder.append('\n');
            }
            stringBuilder.append("Sections:\n");
            for (int i = 0; i < this.sectionHeaders.length; ++i) {
                SectionHeader sectionHeader = this.sectionHeaders[i];
                if (SectionType.STRTAB.equals(sectionHeader.type)) continue;
                stringBuilder.append('\t');
                this.dumpSectionHeader(stringBuilder, this.sectionHeaders[i]);
                stringBuilder.append('\n');
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to get dynamic string table!");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = System.getProperty("user.home") + "/Desktop/Scenarios/5 Sos/libaviary_native.so";
        Elf elf = new Elf(new File(string));
        System.out.println(elf.getSharedDependencies());
        System.out.println(elf);
        System.out.println(elf.isSoname());
        System.out.println(elf.isTextRel());
    }
}

