/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.binutils.coff;

import java.io.IOException;
import java.nio.ByteBuffer;
import nl.lxtreme.binutils.coff.Coff;

public class Symbol {
    public static final int DEBUG = 2;
    public static final int ABSOLUTE = 1;
    public static final int NONE = 0;
    public final String name;
    public final int value;
    public final int sectionNumber;
    public final int type;
    public final int storageClass;
    public final int auxCount;

    public Symbol(ByteBuffer byteBuffer, byte[] byArray) throws IOException {
        int n;
        byte[] byArray2 = new byte[8];
        byteBuffer.get(byArray2);
        this.name = byArray2[0] == 0 && byArray2[1] == 0 && byArray2[2] == 0 && byArray2[3] == 0 ? ((n = ((byArray2[7] & 0xFF) << 24 | (byArray2[6] & 0xFF) << 16 | (byArray2[5] & 0xFF) << 8 | byArray2[4] & 0xFF) - 4) > 0 && n < byArray.length ? Coff.getZString(byArray, n) : "") : new String(byArray2);
        this.value = byteBuffer.getInt();
        this.sectionNumber = byteBuffer.getShort();
        this.type = byteBuffer.getShort();
        this.storageClass = byteBuffer.get();
        this.auxCount = byteBuffer.getInt();
    }

    public boolean isAbsoluteSymbol() {
        return this.sectionNumber == 1;
    }

    public boolean isDebugSymbol() {
        return this.sectionNumber == 2;
    }

    public boolean isExternal() {
        return this.sectionNumber == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append(", value = 0x").append(Integer.toHexString(this.value));
        return stringBuilder.toString();
    }
}

