/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.updater.networking;

import com.google.classyshark.updater.models.Release;
import com.google.classyshark.updater.networking.AbstractReleaseCallback;
import com.google.classyshark.updater.networking.NetworkManager;
import com.google.classyshark.updater.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import retrofit2.Call;

public abstract class AbstractDownloader
extends AbstractReleaseCallback {
    private final Release current = new Release();

    public void checkNewVersion() {
        Call<Release> call = NetworkManager.getGitHubApi().getLatestRelease();
        call.enqueue(this);
    }

    @Override
    public void onReleaseReceived(final Release release) {
        if (release.isNewerThan(this.current)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (AbstractDownloader.this.warnAboutNew(release)) {
                        AbstractDownloader.this.obtainNew(release);
                    }
                }
            }).start();
        }
    }

    abstract boolean warnAboutNew(Release var1);

    private void obtainNew(Release release) {
        try {
            this.onReleaseDownloaded(FileUtils.downloadFileFrom(release), release);
        }
        catch (IOException iOException) {
            System.err.println("ERROR: " + iOException.getMessage());
        }
    }

    abstract void onReleaseDownloaded(File var1, Release var2);
}

