/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator.xml;

import com.google.classyshark.silverghost.translator.Translator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlHighlighter {
    private static final Pattern TAG_PATTERN = Pattern.compile("(</?[A-Za-z-\\d\\._]+)\\s?>?", 8);
    private static final Pattern TAG_PATTERN_2 = Pattern.compile("(<\\?)[a-z-]+\\s?>?", 8);
    private static final Pattern TAG_END_PATTERN = Pattern.compile("[^\\]](\\??>)", 8);
    private static final Pattern TAG_ATTRIBUTE_PATTERN = Pattern.compile("\\s(\\w*)\\=", 8);
    private static final Pattern TAG_ATTRIBUTE_VALUE = Pattern.compile("[a-z-]*\\=(\"[^\"]*\")", 8);
    private static final Pattern TAG_ATTRIBUTE_VALUE_2 = Pattern.compile("[a-z-]*\\=('[^']*')", 8);
    private static final Pattern TAG_COMMENT = Pattern.compile("(<!--.*-->)", 8);
    private static final Pattern TAG_CDATA_START = Pattern.compile("(\\<!\\[CDATA\\[).*", 8);
    private static final Pattern TAG_CDATA_END = Pattern.compile(".*(]]>)", 8);
    private static final Map<Pattern, TagType> PATTERN_TAG_TYPE_MAP = new HashMap<Pattern, TagType>();

    public List<Translator.ELEMENT> getElements(String string) {
        Object object;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Map.Entry<Pattern, TagType> object2 : PATTERN_TAG_TYPE_MAP.entrySet()) {
            object = object2.getKey().matcher(string);
            while (((Matcher)object).find()) {
                arrayList.add(new Element(((Matcher)object).start(1), ((Matcher)object).end(1), object2.getValue()));
            }
        }
        Collections.sort(arrayList);
        int n = 0;
        object = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            Translator.TAG tAG;
            Element element = (Element)arrayList.get(i);
            if (n < element.start) {
                object.add(new Translator.ELEMENT(string.substring(n, element.start), Translator.TAG.XML_COMMENT));
            }
            switch (element.tag) {
                case TAG: {
                    tAG = Translator.TAG.XML_TAG;
                    break;
                }
                case ATTR_NAME: {
                    tAG = Translator.TAG.XML_ATTR_NAME;
                    break;
                }
                case ATTR_VALUE: {
                    tAG = Translator.TAG.XML_ATTR_VALUE;
                    break;
                }
                case CDATA: {
                    tAG = Translator.TAG.XML_CDATA;
                    break;
                }
                case COMMENT: {
                    tAG = Translator.TAG.XML_COMMENT;
                    break;
                }
                default: {
                    tAG = Translator.TAG.XML_DEFAULT;
                }
            }
            object.add(new Translator.ELEMENT(string.substring(element.start, element.end), tAG));
            n = element.end;
            if (i != arrayList.size() - 1 || n >= string.length() - 1) continue;
            object.add(new Translator.ELEMENT(string.substring(element.end, string.length()), Translator.TAG.XML_DEFAULT));
        }
        return object;
    }

    public static void main(String[] stringArray) {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<manifest\n    versionCode='@res/0x00000001'\n    versionName='1.0'\n    package='com.google.example.minproject'\n    platformBuildVersionCode='23'\n    platformBuildVersionName='6.0-2166767'>\n  <uses-sdk\n      minSdkVersion='@res/0x00000010'\n      targetSdkVersion='@res/0x00000017'>\n  </uses-sdk>\n  <application\n      theme='@res/0x7F08007E'\n      label='@res/0x7F060012'\n      icon='@res/0x7F030000'\n      debuggable='@res/0xFFFFFFFF'\n      allowBackup='@res/0xFFFFFFFF'\n      supportsRtl='@res/0xFFFFFFFF'>\n        <![CDATA[Testing 123]]>\n    <meta-data\n        name='test'>\n    </meta-data>\n  </application>\n</manifest>";
        System.out.println(string);
        List<Translator.ELEMENT> list = new XmlHighlighter().getElements(string);
        for (Translator.ELEMENT eLEMENT : list) {
            System.out.println(eLEMENT.text);
        }
        System.out.println(list.size());
    }

    static {
        PATTERN_TAG_TYPE_MAP.put(TAG_PATTERN, TagType.TAG);
        PATTERN_TAG_TYPE_MAP.put(TAG_PATTERN_2, TagType.TAG);
        PATTERN_TAG_TYPE_MAP.put(TAG_END_PATTERN, TagType.TAG);
        PATTERN_TAG_TYPE_MAP.put(TAG_ATTRIBUTE_PATTERN, TagType.ATTR_NAME);
        PATTERN_TAG_TYPE_MAP.put(TAG_ATTRIBUTE_VALUE, TagType.ATTR_VALUE);
        PATTERN_TAG_TYPE_MAP.put(TAG_ATTRIBUTE_VALUE_2, TagType.ATTR_VALUE);
        PATTERN_TAG_TYPE_MAP.put(TAG_COMMENT, TagType.COMMENT);
        PATTERN_TAG_TYPE_MAP.put(TAG_CDATA_START, TagType.CDATA);
        PATTERN_TAG_TYPE_MAP.put(TAG_CDATA_END, TagType.CDATA);
    }

    public static class Element
    implements Comparable<Element> {
        private int start;
        private int end;
        private TagType tag;

        public Element(int n, int n2, TagType tagType) {
            this.start = n;
            this.end = n2;
            this.tag = tagType;
        }

        public String toString() {
            return "Element{start=" + this.start + ", end=" + this.end + ", tag='" + (Object)((Object)this.tag) + '\'' + '}';
        }

        @Override
        public int compareTo(Element element) {
            return Integer.compare(this.start, element.start);
        }
    }

    public static enum TagType {
        TAG,
        ATTR_NAME,
        ATTR_VALUE,
        COMMENT,
        CDATA;

    }
}

