/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator.java.dex;

import com.google.classyshark.silverghost.translator.Translator;
import com.google.classyshark.silverghost.translator.TranslatorFactory;
import com.google.classyshark.silverghost.translator.java.MetaObject;
import com.google.classyshark.silverghost.translator.java.dex.DexlibAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodParameter;

public class MetaObjectDex
extends MetaObject {
    private final ClassDef classDef;

    public MetaObjectDex(ClassDef classDef) {
        this.classDef = classDef;
    }

    @Override
    public String getName() {
        return DexlibAdapter.getClassStringFromDex(this.classDef.getType());
    }

    @Override
    public MetaObject.InterfaceInfo[] getInterfaces() {
        ArrayList<MetaObject.InterfaceInfo> arrayList = new ArrayList<MetaObject.InterfaceInfo>();
        for (String string : this.classDef.getInterfaces()) {
            MetaObject.InterfaceInfo interfaceInfo = new MetaObject.InterfaceInfo();
            interfaceInfo.interfaceStr = DexlibAdapter.getClassStringFromDex(string);
            arrayList.add(interfaceInfo);
        }
        MetaObject.InterfaceInfo[] interfaceInfoArray = new MetaObject.InterfaceInfo[arrayList.size()];
        return arrayList.toArray(interfaceInfoArray);
    }

    @Override
    public MetaObject.FieldInfo[] getDeclaredFields() {
        ArrayList<MetaObject.FieldInfo> arrayList = new ArrayList<MetaObject.FieldInfo>();
        Iterable<? extends Field> iterable = this.classDef.getFields();
        for (Field field : iterable) {
            MetaObject.FieldInfo fieldInfo = new MetaObject.FieldInfo();
            fieldInfo.typeName = DexlibAdapter.getTypeName(field.getType());
            fieldInfo.modifiers = field.getAccessFlags();
            fieldInfo.annotations = this.convertAnnotations(field.getAnnotations());
            fieldInfo.name = field.getName();
            arrayList.add(fieldInfo);
        }
        MetaObject.FieldInfo[] fieldInfoArray = new MetaObject.FieldInfo[arrayList.size()];
        return arrayList.toArray(fieldInfoArray);
    }

    @Override
    public MetaObject.ConstructorInfo[] getDeclaredConstructors() {
        Iterable<? extends Method> iterable = this.classDef.getMethods();
        ArrayList<MetaObject.ConstructorInfo> arrayList = new ArrayList<MetaObject.ConstructorInfo>();
        for (Method method : iterable) {
            if (!MetaObjectDex.isConstructor(method)) continue;
            MetaObject.ConstructorInfo constructorInfo = new MetaObject.ConstructorInfo();
            constructorInfo.parameterTypes = this.convertParameters(method.getParameters());
            constructorInfo.annotations = this.convertAnnotations(method.getAnnotations());
            constructorInfo.modifiers = method.getAccessFlags();
            arrayList.add(constructorInfo);
        }
        MetaObject.ConstructorInfo[] constructorInfoArray = new MetaObject.ConstructorInfo[arrayList.size()];
        return arrayList.toArray(constructorInfoArray);
    }

    @Override
    public MetaObject.MethodInfo[] getDeclaredMethods() {
        Iterable<? extends Method> iterable = this.classDef.getMethods();
        ArrayList<MetaObject.MethodInfo> arrayList = new ArrayList<MetaObject.MethodInfo>();
        for (Method method : iterable) {
            if (MetaObjectDex.isConstructor(method)) continue;
            MetaObject.MethodInfo methodInfo = new MetaObject.MethodInfo();
            methodInfo.parameterTypes = this.convertParameters(method.getParameters());
            methodInfo.annotations = this.convertAnnotations(method.getAnnotations());
            methodInfo.modifiers = method.getAccessFlags();
            methodInfo.name = method.getName();
            methodInfo.exceptionTypes = new MetaObject.ExceptionInfo[0];
            methodInfo.returnType = DexlibAdapter.getTypeName(method.getReturnType());
            arrayList.add(methodInfo);
        }
        MetaObject.MethodInfo[] methodInfoArray = new MetaObject.MethodInfo[arrayList.size()];
        return arrayList.toArray(methodInfoArray);
    }

    @Override
    public MetaObject.AnnotationInfo[] getAnnotations() {
        return this.convertAnnotations(this.classDef.getAnnotations());
    }

    private MetaObject.AnnotationInfo[] convertAnnotations(Set<? extends Annotation> set) {
        ArrayList<MetaObject.AnnotationInfo> arrayList = new ArrayList<MetaObject.AnnotationInfo>();
        for (Annotation annotation : set) {
            MetaObject.AnnotationInfo annotationInfo = new MetaObject.AnnotationInfo();
            annotationInfo.annotationStr = DexlibAdapter.getTypeName(annotation.getType());
            arrayList.add(annotationInfo);
        }
        MetaObject.AnnotationInfo[] annotationInfoArray = new MetaObject.AnnotationInfo[arrayList.size()];
        return arrayList.toArray(annotationInfoArray);
    }

    private MetaObject.ParameterInfo[] convertParameters(List<? extends MethodParameter> list) {
        ArrayList<MetaObject.ParameterInfo> arrayList = new ArrayList<MetaObject.ParameterInfo>();
        for (MethodParameter methodParameter : list) {
            MetaObject.ParameterInfo parameterInfo = new MetaObject.ParameterInfo();
            parameterInfo.parameterStr = DexlibAdapter.getTypeName(methodParameter.getType());
            arrayList.add(parameterInfo);
        }
        MetaObject.ParameterInfo[] parameterInfoArray = new MetaObject.ParameterInfo[arrayList.size()];
        return arrayList.toArray(parameterInfoArray);
    }

    @Override
    public String getClassGenerics(String string) {
        return "";
    }

    @Override
    public int getModifiers() {
        return this.classDef.getAccessFlags();
    }

    @Override
    public String getSuperclass() {
        return DexlibAdapter.getClassStringFromDex(this.classDef.getSuperclass());
    }

    @Override
    public String getSuperclassGenerics() {
        return "";
    }

    private static boolean isConstructor(Method method) {
        return method.getName().equals("<init>");
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File(System.getProperty("user.home") + "/Desktop/classes.dex");
        String string = "com.google.common.collect.ImmutableSortedMap";
        Translator translator = TranslatorFactory.createTranslator(string, file);
        translator.apply();
        System.out.println(translator.toString());
    }
}

