/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator.java.clazz.reflect;

import com.google.classyshark.gui.panel.reducer.Reducer;
import com.google.classyshark.silverghost.translator.java.MetaObject;
import com.google.classyshark.silverghost.translator.java.clazz.QualifiedTypesMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;

public class MetaObjectClass
extends MetaObject {
    private Class clazz;

    public MetaObjectClass(Class clazz) {
        this.clazz = clazz;
    }

    @Override
    public MetaObject.AnnotationInfo[] getAnnotations() {
        return this.convertAnnotations(this.clazz.getAnnotations());
    }

    @Override
    public int getModifiers() {
        return this.clazz.getModifiers();
    }

    @Override
    public String getSuperclass() {
        if (this.clazz.getSuperclass() == null) {
            return null;
        }
        return this.clazz.getSuperclass().getName();
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    @Override
    public String getClassGenerics(String string) {
        TypeVariable[] typeVariableArray = this.clazz.getTypeParameters();
        if (typeVariableArray.length != 0) {
            String string2 = this.getClassGenericsString(typeVariableArray);
            return string2;
        }
        return "";
    }

    @Override
    public String getSuperclassGenerics() {
        if (this.clazz.getSuperclass() != null) {
            TypeVariable[] typeVariableArray = this.clazz.getSuperclass().getTypeParameters();
            if (typeVariableArray.length != 0) {
                String string = this.getClassGenericsString(typeVariableArray);
                return string;
            }
            return "";
        }
        return "";
    }

    @Override
    public MetaObject.InterfaceInfo[] getInterfaces() {
        ArrayList<MetaObject.InterfaceInfo> arrayList = new ArrayList<MetaObject.InterfaceInfo>();
        for (Class<?> clazz : this.clazz.getInterfaces()) {
            MetaObject.InterfaceInfo interfaceInfo = new MetaObject.InterfaceInfo();
            interfaceInfo.interfaceStr = clazz.getName();
            TypeVariable[] typeVariableArray = clazz.getTypeParameters();
            if (typeVariableArray.length != 0) {
                interfaceInfo.genericsStr = this.getClassGenericsString(typeVariableArray);
            }
            arrayList.add(interfaceInfo);
        }
        Object[] objectArray = new MetaObject.InterfaceInfo[arrayList.size()];
        return (MetaObject.InterfaceInfo[])arrayList.toArray(objectArray);
    }

    @Override
    public MetaObject.FieldInfo[] getDeclaredFields() {
        Field[] fieldArray = this.clazz.getDeclaredFields();
        ArrayList<MetaObject.FieldInfo> arrayList = new ArrayList<MetaObject.FieldInfo>();
        for (Field field : fieldArray) {
            MetaObject.FieldInfo fieldInfo = new MetaObject.FieldInfo();
            fieldInfo.typeName = field.getType().getName();
            fieldInfo.modifiers = field.getModifiers();
            fieldInfo.annotations = this.convertAnnotations(field.getAnnotations());
            fieldInfo.name = field.getName();
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                fieldInfo.genericStr = this.getFieldGenericsString(parameterizedType.getActualTypeArguments());
            }
            arrayList.add(fieldInfo);
        }
        Object[] objectArray = new MetaObject.FieldInfo[arrayList.size()];
        return (MetaObject.FieldInfo[])arrayList.toArray(objectArray);
    }

    @Override
    public MetaObject.ConstructorInfo[] getDeclaredConstructors() {
        Constructor<?>[] constructorArray = this.clazz.getDeclaredConstructors();
        ArrayList<MetaObject.ConstructorInfo> arrayList = new ArrayList<MetaObject.ConstructorInfo>();
        for (Constructor<?> constructor : constructorArray) {
            MetaObject.ConstructorInfo constructorInfo = new MetaObject.ConstructorInfo();
            constructorInfo.parameterTypes = this.convertParameters(constructor.getParameterTypes(), constructor.getGenericParameterTypes());
            constructorInfo.annotations = this.convertAnnotations(constructor.getAnnotations());
            constructorInfo.modifiers = constructor.getModifiers();
            arrayList.add(constructorInfo);
        }
        Object[] objectArray = new MetaObject.ConstructorInfo[arrayList.size()];
        return (MetaObject.ConstructorInfo[])arrayList.toArray(objectArray);
    }

    @Override
    public MetaObject.MethodInfo[] getDeclaredMethods() {
        Method[] methodArray = this.clazz.getDeclaredMethods();
        ArrayList<MetaObject.MethodInfo> arrayList = new ArrayList<MetaObject.MethodInfo>();
        for (Method method : methodArray) {
            MetaObject.MethodInfo methodInfo = new MetaObject.MethodInfo();
            methodInfo.parameterTypes = this.convertParameters(method.getParameterTypes(), method.getGenericParameterTypes());
            methodInfo.annotations = this.convertAnnotations(method.getAnnotations());
            methodInfo.modifiers = method.getModifiers();
            methodInfo.name = method.getName();
            methodInfo.exceptionTypes = this.convertExceptions(method.getExceptionTypes());
            methodInfo.returnType = method.getReturnType().getName();
            Type type = method.getGenericReturnType();
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type[] typeArray = parameterizedType.getActualTypeArguments();
                methodInfo.genericReturnType = this.getFieldGenericsString(typeArray) + " ";
            }
            arrayList.add(methodInfo);
        }
        Object[] objectArray = new MetaObject.MethodInfo[arrayList.size()];
        return (MetaObject.MethodInfo[])arrayList.toArray(objectArray);
    }

    private String getClassGenericsString(TypeVariable[] typeVariableArray) {
        String string = "<";
        for (TypeVariable typeVariable : typeVariableArray) {
            string = string + typeVariable.getName() + ", ";
        }
        string = string.substring(0, string.length() - 2) + ">";
        return string;
    }

    private MetaObject.AnnotationInfo[] convertAnnotations(Annotation[] annotationArray) {
        ArrayList<MetaObject.AnnotationInfo> arrayList = new ArrayList<MetaObject.AnnotationInfo>();
        for (Annotation annotation : annotationArray) {
            MetaObject.AnnotationInfo annotationInfo = new MetaObject.AnnotationInfo();
            annotationInfo.annotationStr = annotation.annotationType().getSimpleName();
            arrayList.add(annotationInfo);
        }
        Object[] objectArray = new MetaObject.AnnotationInfo[arrayList.size()];
        return (MetaObject.AnnotationInfo[])arrayList.toArray(objectArray);
    }

    private MetaObject.ParameterInfo[] convertParameters(Class<?>[] classArray, Type[] typeArray) {
        ArrayList<MetaObject.ParameterInfo> arrayList = new ArrayList<MetaObject.ParameterInfo>();
        for (int i = 0; i < classArray.length; ++i) {
            Type type;
            Class<?> clazz = classArray[i];
            MetaObject.ParameterInfo parameterInfo = new MetaObject.ParameterInfo();
            parameterInfo.parameterStr = clazz.getName();
            if (typeArray != null && i < typeArray.length && (type = typeArray[i]) instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type[] typeArray2 = parameterizedType.getActualTypeArguments();
                parameterInfo.genericStr = this.getFieldGenericsString(typeArray2);
            }
            arrayList.add(parameterInfo);
        }
        MetaObject.ParameterInfo[] parameterInfoArray = new MetaObject.ParameterInfo[arrayList.size()];
        return arrayList.toArray(parameterInfoArray);
    }

    private String getFieldGenericsString(Type[] typeArray) {
        if (typeArray == null || typeArray.length == 0) {
            return "";
        }
        String string = " <";
        for (Type type : typeArray) {
            string = string + QualifiedTypesMap.decodeAndStore(type.toString(), null) + ", ";
        }
        string = string.substring(0, string.length() - 2) + ">";
        return string;
    }

    private MetaObject.ExceptionInfo[] convertExceptions(Class<?>[] classArray) {
        ArrayList<MetaObject.ExceptionInfo> arrayList = new ArrayList<MetaObject.ExceptionInfo>();
        for (Class<?> clazz : classArray) {
            MetaObject.ExceptionInfo exceptionInfo = new MetaObject.ExceptionInfo(this);
            exceptionInfo.exceptionStr = clazz.getName();
            arrayList.add(exceptionInfo);
        }
        Object[] objectArray = new MetaObject.ExceptionInfo[arrayList.size()];
        return (MetaObject.ExceptionInfo[])arrayList.toArray(objectArray);
    }

    public static void main(String[] stringArray) throws Exception {
        MetaObjectClass metaObjectClass = new MetaObjectClass(Reducer.class);
        System.out.println(metaObjectClass.getAnnotations());
    }
}

