/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator.java;

import com.google.classyshark.silverghost.contentreader.ContentReader;
import com.google.classyshark.silverghost.contentreader.dex.DexlibLoader;
import com.google.classyshark.silverghost.contentreader.jar.JarReader;
import com.google.classyshark.silverghost.translator.Translator;
import com.google.classyshark.silverghost.translator.TranslatorFactory;
import com.google.classyshark.silverghost.translator.java.dex.DexlibAdapter;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;

public class StressTest {
    public static void runAllClassesInJar(String string) throws Exception {
        List<String> list = JarReader.readClassNamesFromJar(new File(string), new LinkedList<ContentReader.Component>());
        for (String string2 : list) {
            Translator translator = TranslatorFactory.createTranslator(string2, new File(string));
            translator.apply();
            System.out.println(translator.toString());
        }
    }

    public static void runAllClassesInDex(String string) throws Exception {
        DexFile dexFile = DexlibLoader.loadDexFile(new File(string));
        Set<? extends ClassDef> set = dexFile.getClasses();
        for (ClassDef classDef : set) {
            String string2 = DexlibAdapter.getClassStringFromDex(classDef.getType());
            Translator translator = TranslatorFactory.createTranslator(string2, new File(string));
            translator.apply();
            System.out.println(translator.toString());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = System.getProperty("user.home") + "/Desktop/Scenarios/2 Samples/android.jar";
        StressTest.runAllClassesInJar(string);
    }
}

