/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator.java;

import com.google.classyshark.silverghost.TokensMapper;
import com.google.classyshark.silverghost.translator.Translator;
import com.google.classyshark.silverghost.translator.TranslatorFactory;
import com.google.classyshark.silverghost.translator.java.MetaObject;
import com.google.classyshark.silverghost.translator.java.MetaObjectFactory;
import com.google.classyshark.silverghost.translator.java.MetaObjectWithMapper;
import com.google.classyshark.silverghost.translator.java.clazz.QualifiedTypesMap;
import com.google.classyshark.silverghost.translator.java.clazz.reflect.MetaObjectClass;
import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JavaTranslator
implements Translator {
    private MetaObject metaObject;
    private List<Translator.ELEMENT> sourceCode;
    private QualifiedTypesMap namesMapper;

    public JavaTranslator(Class clazz) {
        this.metaObject = new MetaObjectClass(clazz);
        this.sourceCode = new ArrayList<Translator.ELEMENT>();
        this.namesMapper = new QualifiedTypesMap();
    }

    public JavaTranslator(String string, File file) {
        this.metaObject = MetaObjectFactory.buildMetaObject(string, file);
        this.sourceCode = new ArrayList<Translator.ELEMENT>();
        this.namesMapper = new QualifiedTypesMap();
    }

    @Override
    public String getClassName() {
        return this.metaObject.getName();
    }

    @Override
    public void addMapper(TokensMapper tokensMapper) {
        this.metaObject = new MetaObjectWithMapper(this.metaObject, tokensMapper);
    }

    @Override
    public void apply() {
        String string = this.metaObject.getName();
        if (string.lastIndexOf(".") != -1) {
            String string2 = string.substring(0, string.lastIndexOf("."));
            this.sourceCode.add(new Translator.ELEMENT("\npackage ", Translator.TAG.MODIFIER));
            this.sourceCode.add(new Translator.ELEMENT(string2, Translator.TAG.IDENTIFIER));
            this.sourceCode.add(new Translator.ELEMENT(";\n", Translator.TAG.MODIFIER));
        }
        MetaObject.InterfaceInfo[] interfaceInfoArray = this.metaObject.getInterfaces();
        MetaObject.FieldInfo[] fieldInfoArray = this.metaObject.getDeclaredFields();
        MetaObject.ConstructorInfo[] constructorInfoArray = this.metaObject.getDeclaredConstructors();
        MetaObject.MethodInfo[] methodInfoArray = this.metaObject.getDeclaredMethods();
        this.fillTypes(interfaceInfoArray, constructorInfoArray, methodInfoArray, fieldInfoArray);
        this.namesMapper.removeType(string);
        this.fillSource(interfaceInfoArray, constructorInfoArray, methodInfoArray, fieldInfoArray, this.metaObject);
    }

    public String toString() {
        if (this.sourceCode == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Translator.ELEMENT eLEMENT : this.sourceCode) {
            stringBuilder.append(eLEMENT.text);
        }
        return stringBuilder.toString();
    }

    @Override
    public List<Translator.ELEMENT> getElementsList() {
        return Collections.unmodifiableList(this.sourceCode);
    }

    @Override
    public List<String> getDependencies() {
        return new ArrayList<String>(this.namesMapper.getFullTypes());
    }

    private void fillTypes(MetaObject.InterfaceInfo[] interfaceInfoArray, MetaObject.ConstructorInfo[] constructorInfoArray, MetaObject.MethodInfo[] methodInfoArray, MetaObject.FieldInfo[] fieldInfoArray) {
        int n;
        Object[] objectArray;
        MetaObject.ParameterInfo[] parameterInfoArray;
        for (MetaObject.InterfaceInfo object : interfaceInfoArray) {
            this.namesMapper.addType(object.interfaceStr);
        }
        for (MetaObject.FieldInfo fieldInfo : fieldInfoArray) {
            this.namesMapper.addType(fieldInfo.typeName);
        }
        for (MetaObject.ConstructorInfo constructorInfo : constructorInfoArray) {
            parameterInfoArray = constructorInfo.parameterTypes;
            if (parameterInfoArray.length <= 0) continue;
            objectArray = parameterInfoArray;
            int n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                MetaObject.ParameterInfo parameterInfo = objectArray[n];
                this.namesMapper.addType(parameterInfo.parameterStr);
            }
        }
        for (MetaObject.MethodInfo methodInfo : methodInfoArray) {
            this.namesMapper.addType(methodInfo.returnType);
            parameterInfoArray = methodInfo.parameterTypes;
            if (parameterInfoArray.length > 0) {
                objectArray = parameterInfoArray;
                int n3 = objectArray.length;
                for (n = 0; n < n3; ++n) {
                    Object object = objectArray[n];
                    this.namesMapper.addType(((MetaObject.ParameterInfo)object).parameterStr);
                }
            }
            Object[] objectArray2 = objectArray = methodInfo.exceptionTypes;
            n = objectArray2.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray2[i];
                this.namesMapper.addType(((MetaObject.ExceptionInfo)object).exceptionStr);
            }
        }
    }

    private void fillSource(MetaObject.InterfaceInfo[] interfaceInfoArray, MetaObject.ConstructorInfo[] constructorInfoArray, MetaObject.MethodInfo[] methodInfoArray, MetaObject.FieldInfo[] fieldInfoArray, MetaObject metaObject) {
        JavaTranslator.fillImports(this.namesMapper, this.sourceCode);
        JavaTranslator.fillClassDecl(interfaceInfoArray, metaObject, this.sourceCode, this.namesMapper);
        JavaTranslator.fillFields(fieldInfoArray, this.sourceCode, this.namesMapper);
        JavaTranslator.fillCtors(constructorInfoArray, metaObject, this.sourceCode, this.namesMapper);
        JavaTranslator.fillMethods(methodInfoArray, this.sourceCode, this.namesMapper);
    }

    private static void fillImports(QualifiedTypesMap qualifiedTypesMap, List<Translator.ELEMENT> list) {
        List<String> list2 = qualifiedTypesMap.getFullTypes();
        for (String string : list2) {
            list.add(new Translator.ELEMENT("\nimport ", Translator.TAG.MODIFIER));
            list.add(new Translator.ELEMENT(string + ";", Translator.TAG.DOCUMENT));
        }
        list.add(new Translator.ELEMENT("\n\n", Translator.TAG.IDENTIFIER));
    }

    private static void fillClassDecl(MetaObject.InterfaceInfo[] interfaceInfoArray, MetaObject metaObject, List<Translator.ELEMENT> list, QualifiedTypesMap qualifiedTypesMap) {
        MetaObject.AnnotationInfo[] annotationInfoArray;
        for (MetaObject.AnnotationInfo annotationInfo : annotationInfoArray = metaObject.getAnnotations()) {
            list.add(new Translator.ELEMENT("@" + annotationInfo.annotationStr + " \n", Translator.TAG.ANNOTATION));
        }
        int n = metaObject.getModifiers();
        list.add(new Translator.ELEMENT(Modifier.toString(n), Translator.TAG.MODIFIER));
        if (!Modifier.isInterface(n)) {
            list.add(new Translator.ELEMENT(" class", Translator.TAG.MODIFIER));
        }
        list.add(new Translator.ELEMENT(" " + qualifiedTypesMap.getTypeNull(metaObject.getName()), Translator.TAG.IDENTIFIER));
        list.add(new Translator.ELEMENT(metaObject.getClassGenerics(metaObject.getName()), Translator.TAG.IDENTIFIER));
        if (metaObject.getSuperclass() != null) {
            list.add(new Translator.ELEMENT(" extends ", Translator.TAG.MODIFIER));
            list.add(new Translator.ELEMENT(qualifiedTypesMap.getType(metaObject.getSuperclass()), Translator.TAG.IDENTIFIER));
            list.add(new Translator.ELEMENT(metaObject.getSuperclassGenerics(), Translator.TAG.IDENTIFIER));
        }
        if (interfaceInfoArray.length != 0) {
            list.add(new Translator.ELEMENT(" implements ", Translator.TAG.MODIFIER));
            for (MetaObject.InterfaceInfo interfaceInfo : interfaceInfoArray) {
                list.add(new Translator.ELEMENT(qualifiedTypesMap.getType(interfaceInfo.interfaceStr), Translator.TAG.IDENTIFIER));
                list.add(new Translator.ELEMENT(interfaceInfo.genericsStr, Translator.TAG.IDENTIFIER));
                list.add(new Translator.ELEMENT(", ", Translator.TAG.IDENTIFIER));
            }
            list.remove(list.size() - 1);
        }
        list.add(new Translator.ELEMENT("\n{", Translator.TAG.IDENTIFIER));
    }

    private static void fillFields(MetaObject.FieldInfo[] fieldInfoArray, List<Translator.ELEMENT> list, QualifiedTypesMap qualifiedTypesMap) {
        list.add(new Translator.ELEMENT("\n    //======================== F I E L D S ==================\n\n", Translator.TAG.DOCUMENT));
        for (MetaObject.FieldInfo fieldInfo : fieldInfoArray) {
            MetaObject.AnnotationInfo[] annotationInfoArray;
            int n = fieldInfo.modifiers;
            for (MetaObject.AnnotationInfo annotationInfo : annotationInfoArray = fieldInfo.annotations) {
                list.add(new Translator.ELEMENT("\n      @" + annotationInfo.annotationStr + " ", Translator.TAG.ANNOTATION));
            }
            list.add(new Translator.ELEMENT("\n      " + Modifier.toString(n) + " ", Translator.TAG.MODIFIER));
            list.add(new Translator.ELEMENT(qualifiedTypesMap.getTypeNull(fieldInfo.typeName) + " ", Translator.TAG.MODIFIER));
            list.add(new Translator.ELEMENT(fieldInfo.name, Translator.TAG.IDENTIFIER));
            list.add(new Translator.ELEMENT(fieldInfo.genericStr, Translator.TAG.DOCUMENT));
            list.add(new Translator.ELEMENT(";", Translator.TAG.DOCUMENT));
        }
    }

    private static void fillCtors(MetaObject.ConstructorInfo[] constructorInfoArray, MetaObject metaObject, List<Translator.ELEMENT> list, QualifiedTypesMap qualifiedTypesMap) {
        list.add(new Translator.ELEMENT("\n\n    //======================== C O N S T R U C T O R S ======\n\n", Translator.TAG.DOCUMENT));
        String string = qualifiedTypesMap.getTypeNull(metaObject.getName());
        for (MetaObject.ConstructorInfo constructorInfo : constructorInfoArray) {
            int n = constructorInfo.modifiers;
            list.add(new Translator.ELEMENT("    " + Modifier.toString(n) + " ", Translator.TAG.MODIFIER));
            list.add(new Translator.ELEMENT(string, Translator.TAG.IDENTIFIER));
            MetaObject.ParameterInfo[] parameterInfoArray = constructorInfo.parameterTypes;
            list.add(new Translator.ELEMENT("(", Translator.TAG.DOCUMENT));
            if (parameterInfoArray.length > 0) {
                for (int i = 0; i < parameterInfoArray.length; ++i) {
                    list.add(new Translator.ELEMENT(qualifiedTypesMap.getTypeNull(parameterInfoArray[i].parameterStr), Translator.TAG.DOCUMENT));
                    list.add(new Translator.ELEMENT(parameterInfoArray[i].genericStr, Translator.TAG.DOCUMENT));
                    if (i >= parameterInfoArray.length - 1) continue;
                    list.add(new Translator.ELEMENT(", ", Translator.TAG.DOCUMENT));
                    list.add(new Translator.ELEMENT("\n        ", Translator.TAG.DOCUMENT));
                }
            }
            list.add(new Translator.ELEMENT(") { ... }\n", Translator.TAG.DOCUMENT));
        }
    }

    private static void fillMethods(MetaObject.MethodInfo[] methodInfoArray, List<Translator.ELEMENT> list, QualifiedTypesMap qualifiedTypesMap) {
        list.add(new Translator.ELEMENT("\n    //======================== M E T H O D S ================\n\n", Translator.TAG.DOCUMENT));
        for (MetaObject.MethodInfo methodInfo : methodInfoArray) {
            int n = methodInfo.modifiers;
            MetaObject.AnnotationInfo[] annotationInfoArray = methodInfo.annotations;
            for (MetaObject.AnnotationInfo annotationInfo : annotationInfoArray) {
                list.add(new Translator.ELEMENT("    @" + annotationInfo.annotationStr + " \n", Translator.TAG.ANNOTATION));
            }
            list.add(new Translator.ELEMENT("    " + Modifier.toString(n) + " ", Translator.TAG.MODIFIER));
            list.add(new Translator.ELEMENT(qualifiedTypesMap.getTypeNull(methodInfo.returnType) + " ", Translator.TAG.DOCUMENT));
            list.add(new Translator.ELEMENT(methodInfo.genericReturnType, Translator.TAG.DOCUMENT));
            list.add(new Translator.ELEMENT(methodInfo.name, Translator.TAG.IDENTIFIER));
            Object[] objectArray = methodInfo.parameterTypes;
            list.add(new Translator.ELEMENT("(", Translator.TAG.DOCUMENT));
            if (objectArray.length > 0) {
                for (int i = 0; i < objectArray.length; ++i) {
                    list.add(new Translator.ELEMENT(qualifiedTypesMap.getType(((MetaObject.ParameterInfo)objectArray[i]).parameterStr), Translator.TAG.DOCUMENT));
                    list.add(new Translator.ELEMENT(((MetaObject.ParameterInfo)objectArray[i]).genericStr, Translator.TAG.DOCUMENT));
                    if (i >= objectArray.length - 1) continue;
                    list.add(new Translator.ELEMENT(", ", Translator.TAG.DOCUMENT));
                    list.add(new Translator.ELEMENT("\n        ", Translator.TAG.DOCUMENT));
                }
            }
            list.add(new Translator.ELEMENT(") ", Translator.TAG.DOCUMENT));
            MetaObject.ExceptionInfo[] exceptionInfoArray = methodInfo.exceptionTypes;
            if (exceptionInfoArray.length > 0) {
                list.add(new Translator.ELEMENT(" throws ", Translator.TAG.MODIFIER));
                for (MetaObject.ExceptionInfo exceptionInfo : exceptionInfoArray) {
                    list.add(new Translator.ELEMENT(qualifiedTypesMap.getType(exceptionInfo.exceptionStr), Translator.TAG.IDENTIFIER));
                    list.add(new Translator.ELEMENT(", ", Translator.TAG.IDENTIFIER));
                }
                list.remove(list.size() - 1);
            }
            list.add(new Translator.ELEMENT("{ ... }\n", Translator.TAG.DOCUMENT));
        }
        list.add(new Translator.ELEMENT("\n} ", Translator.TAG.DOCUMENT));
    }

    public static void testJar() {
        File file = new File(System.getProperty("user.home") + "/Desktop/" + "ClassyShark.jar");
        String string = "com.google.classyshark.gui.panel.reducer.Reducer.class";
        Translator translator = TranslatorFactory.createTranslator(string, file);
        translator.apply();
        System.out.println(translator.toString());
    }

    public static void testSystemClass() {
        JavaTranslator javaTranslator = new JavaTranslator(Enum.class);
        javaTranslator.apply();
        System.out.print(javaTranslator);
    }

    public static void testCustomClass() {
        File file = new File(System.getProperty("user.home") + "/Desktop/Scenarios/2 Class/Reducer.class");
        String string = "com.google.classyshark.gui.panel.reducer.Reducer.class";
        Translator translator = TranslatorFactory.createTranslator(string, file);
        translator.apply();
        System.out.println(translator.toString());
    }

    public static void testInnerClass() {
        File file = new File(System.getProperty("user.home") + "/Desktop/Scenarios/2 Class/Reducer$1.class");
        String string = "com.google.classyshark.gui.panel.reducer.Reducer$1.class";
        Translator translator = TranslatorFactory.createTranslator(string, file);
        translator.apply();
        System.out.println(translator.toString());
    }

    public static void main(String[] stringArray) throws Exception {
        JavaTranslator.testJar();
        JavaTranslator.testSystemClass();
        JavaTranslator.testCustomClass();
        JavaTranslator.testInnerClass();
    }
}

