/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator.elf;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ElfReader {
    private static final byte[] ELF_IDENT = new byte[]{127, 69, 76, 70};
    private static final int EI_NIDENT = 16;
    private static final int OFFSET_TYPE = 0;
    private static final int OFFSET_MACHINE = 1;
    private static final int OFFSET_VERSION = 2;
    private static final int OFFSET_ENTRY = 4;
    private static final int OFFSET_PHOFF = 6;
    private static final int OFFSET_SHOFF = 8;
    private static final int OFFSET_FLAGS = 10;
    private static final int OFFSET_EHSIZE = 12;
    private static final int OFFSET_PHENTSIZE = 13;
    private static final int OFFSET_PHNUM = 14;
    private static final int OFFSET_SHENTSIZE = 15;
    private static final int OFFSET_SHNUM = 16;
    private static final int OFFSET_SHSTRNDX = 17;
    private static final int PHOFF_TYPE = 0;
    private static final int PHOFF_OFFSET = 2;
    private static final int PHOFF_VADDR = 4;
    private static final int PHOFF_PADDR = 6;
    private static final int PHOFF_FILESZ = 8;
    private static final int PHOFF_MEMSZ = 10;
    private static final int PHOFF_FLAGS = 12;
    private static final int PHOFF_ALIGN = 14;
    private static final long SHOFF_NAME = 0L;
    private static final long SHOFF_TYPE = 2L;
    private static final long SHOFF_OFFSET = 8L;
    private static final long SHOFF_SIZE = 10L;
    private static final int ELFDATA2LSB = 1;
    private static final int ELFDATA2MSB = 2;
    private static final int ELFCLASS32 = 1;
    private static final int ELFCLASS64 = 2;
    private static final long PT_LOAD = 1L;
    private static final int SHT_SYMTAB = 2;
    private static final int SHT_STRTAB = 3;
    private static final int SHT_DYNAMIC = 6;
    private static final int SHT_DYNSYM = 11;
    private static final int SYMTAB_NAME = 0;
    private static final int SYMTAB_ST_INFO = 6;
    private static final int SYMTAB_ENTRY_HALFWORD_SIZE = 7;
    private static final int SYMTAB_ENTRY_BYTE_EXTRA_SIZE = 2;
    private final RandomAccessFile mFile;
    private final byte[] mBuffer = new byte[512];
    private int mClass;
    private int mEndian;
    private boolean mIsDynamic;
    private boolean mIsPIE;
    private int mType;
    private int mWordSize;
    private int mHalfWordSize;
    private long mSymTabOffset;
    private long mSymTabSize;
    private long mDynSymOffset;
    private long mDynSymSize;
    private long mShStrTabOffset;
    private long mShStrTabSize;
    private long mStrTabOffset;
    private long mStrTabSize;
    private long mDynStrOffset;
    private long mDynStrSize;
    public Map<String, Symbol> mSymbols;
    private Map<String, Symbol> mDynamicSymbols;

    static ElfReader read(File file) throws IOException {
        return new ElfReader(file);
    }

    boolean isDynamic() {
        return this.mIsDynamic;
    }

    int getType() {
        return this.mType;
    }

    boolean isPIE() {
        return this.mIsPIE;
    }

    private ElfReader(File file) throws IOException {
        this.mFile = new RandomAccessFile(file, "r");
        this.readIdent();
        this.readHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.mFile.close();
        }
        catch (IOException iOException) {
        }
        finally {
            super.finalize();
        }
    }

    private void readHeader() throws IOException {
        this.mType = this.readHalf(this.getHeaderOffset(0));
        long l = this.readWord(this.getHeaderOffset(8));
        int n = this.readHalf(this.getHeaderOffset(16));
        int n2 = this.readHalf(this.getHeaderOffset(15));
        int n3 = this.readHalf(this.getHeaderOffset(17));
        this.readSectionHeaders(l, n, n2, n3);
        long l2 = this.readWord(this.getHeaderOffset(6));
        int n4 = this.readHalf(this.getHeaderOffset(14));
        int n5 = this.readHalf(this.getHeaderOffset(13));
        this.readProgramHeaders(l2, n4, n5);
    }

    private void readSectionHeaders(long l, int n, int n2, int n3) throws IOException {
        long l2 = l + (long)(n3 * n2);
        long l3 = this.readWord(l2 + (long)this.mHalfWordSize * 2L);
        if (l3 == 3L) {
            this.mShStrTabOffset = this.readWord(l2 + (long)this.mHalfWordSize * 8L);
            this.mShStrTabSize = this.readWord(l2 + (long)this.mHalfWordSize * 10L);
        }
        for (int i = 0; i < n; ++i) {
            String string;
            long l4;
            long l5;
            long l6;
            if (i == n3) continue;
            long l7 = l + (long)(i * n2);
            long l8 = this.readWord(l7 + (long)this.mHalfWordSize * 2L);
            if (l8 == 2L || l8 == 11L) {
                l6 = this.readWord(l7 + (long)this.mHalfWordSize * 0L);
                l5 = this.readWord(l7 + (long)this.mHalfWordSize * 8L);
                l4 = this.readWord(l7 + (long)this.mHalfWordSize * 10L);
                string = this.readShStrTabEntry(l6);
                if (".symtab".equals(string)) {
                    this.mSymTabOffset = l5;
                    this.mSymTabSize = l4;
                    continue;
                }
                if (!".dynsym".equals(string)) continue;
                this.mDynSymOffset = l5;
                this.mDynSymSize = l4;
                continue;
            }
            if (l8 == 3L) {
                l6 = this.readWord(l7 + (long)this.mHalfWordSize * 0L);
                l5 = this.readWord(l7 + (long)this.mHalfWordSize * 8L);
                l4 = this.readWord(l7 + (long)this.mHalfWordSize * 10L);
                string = this.readShStrTabEntry(l6);
                if (".strtab".equals(string)) {
                    this.mStrTabOffset = l5;
                    this.mStrTabSize = l4;
                    continue;
                }
                if (!".dynstr".equals(string)) continue;
                this.mDynStrOffset = l5;
                this.mDynStrSize = l4;
                continue;
            }
            if (l8 != 6L) continue;
            this.mIsDynamic = true;
        }
    }

    private void readProgramHeaders(long l, int n, int n2) throws IOException {
        for (int i = 0; i < n; ++i) {
            long l2;
            long l3 = l + (long)(i * n2);
            long l4 = this.readWord(l3);
            if (l4 != 1L || (l2 = this.readWord(l3 + (long)(this.mHalfWordSize * 4))) != 0L) continue;
            this.mIsPIE = true;
        }
    }

    private void readSymbolTable(Map<String, Symbol> map, long l, long l2, long l3, long l4) throws IOException {
        long l5 = l3 + l4;
        for (long i = l3; i < l5; i += (long)(7 * this.mHalfWordSize + 2)) {
            String string;
            long l6 = this.readWord(i + 0L);
            if (l6 == 0L || (string = this.readStrTabEntry(l, l2, l6)) == null) continue;
            int n = this.readByte(i + 6L);
            map.put(string, new Symbol(string, n));
        }
    }

    private String readShStrTabEntry(long l) throws IOException {
        if (this.mShStrTabOffset == 0L || l < 0L || l >= this.mShStrTabSize) {
            return null;
        }
        return this.readString(this.mShStrTabOffset + l);
    }

    private String readStrTabEntry(long l, long l2, long l3) throws IOException {
        if (l == 0L || l3 < 0L || l3 >= l2) {
            return null;
        }
        return this.readString(l + l3);
    }

    private int getHeaderOffset(int n) {
        return 16 + n * this.mHalfWordSize;
    }

    private int readByte(long l) throws IOException {
        this.mFile.seek(l);
        this.mFile.readFully(this.mBuffer, 0, 1);
        return this.mBuffer[0];
    }

    private int readHalf(long l) throws IOException {
        this.mFile.seek(l);
        this.mFile.readFully(this.mBuffer, 0, this.mWordSize);
        int n = this.mEndian == 1 ? this.mBuffer[1] << 8 | this.mBuffer[0] : this.mBuffer[0] << 8 | this.mBuffer[1];
        return n;
    }

    private long readWord(long l) throws IOException {
        this.mFile.seek(l);
        this.mFile.readFully(this.mBuffer, 0, this.mWordSize);
        int n = 0;
        if (this.mEndian == 1) {
            for (int i = this.mWordSize - 1; i >= 0; --i) {
                n = n << 8 | this.mBuffer[i] & 0xFF;
            }
        } else {
            int n2 = this.mWordSize - 1;
            for (int i = 0; i <= n2; ++i) {
                n = n << 8 | this.mBuffer[i];
            }
        }
        return n;
    }

    private String readString(long l) throws IOException {
        this.mFile.seek(l);
        this.mFile.readFully(this.mBuffer, 0, (int)Math.min((long)this.mBuffer.length, this.mFile.length() - l));
        for (int i = 0; i < this.mBuffer.length; ++i) {
            if (this.mBuffer[i] != 0) continue;
            return new String(this.mBuffer, 0, i);
        }
        return null;
    }

    private void readIdent() throws IOException {
        this.mFile.seek(0L);
        this.mFile.readFully(this.mBuffer, 0, 16);
        if (this.mBuffer[0] != ELF_IDENT[0] || this.mBuffer[1] != ELF_IDENT[1] || this.mBuffer[2] != ELF_IDENT[2] || this.mBuffer[3] != ELF_IDENT[3]) {
            throw new IllegalArgumentException("Invalid ELF file");
        }
        this.mClass = this.mBuffer[4];
        if (this.mClass != 1) {
            throw new IOException("Invalid executable type " + this.mClass + ": not ELFCLASS32!");
        }
        this.mWordSize = 4;
        this.mHalfWordSize = 2;
        this.mEndian = this.mBuffer[5];
    }

    public Symbol getSymbol(String string) {
        if (this.mSymTabOffset == 0L && this.mSymTabSize == 0L) {
            return null;
        }
        if (this.mSymbols == null) {
            this.mSymbols = new HashMap<String, Symbol>();
            try {
                this.readSymbolTable(this.mSymbols, this.mStrTabOffset, this.mStrTabSize, this.mSymTabOffset, this.mSymTabSize);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return this.mSymbols.get(string);
    }

    public Symbol getDynamicSymbol(String string) {
        if (this.mDynSymOffset == 0L && this.mDynSymSize == 0L) {
            return null;
        }
        if (this.mDynamicSymbols == null) {
            this.mDynamicSymbols = new HashMap<String, Symbol>();
            try {
                this.readSymbolTable(this.mDynamicSymbols, this.mDynStrOffset, this.mDynStrSize, this.mDynSymOffset, this.mDynSymSize);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return this.mDynamicSymbols.get(string);
    }

    public List<String> getDynamicSymbols() {
        this.getDynamicSymbol("");
        Set<String> set = this.mDynamicSymbols.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set);
        Collections.sort(arrayList);
        return arrayList;
    }

    public static void main(String[] stringArray) throws Exception {
        String string = System.getProperty("user.home") + "/Desktop/Scenarios/5 Sos/libsqlcipher_android.so";
        File file = new File(string);
        ElfReader elfReader = ElfReader.read(file);
        for (String string2 : elfReader.getDynamicSymbols()) {
            System.out.println(string2);
        }
    }

    public static class Symbol {
        public static final int STB_LOCAL = 0;
        public static final int STB_GLOBAL = 1;
        public static final int STB_WEAK = 2;
        public static final int STB_LOPROC = 13;
        public static final int STB_HIPROC = 15;
        public final String name;
        public final int bind;
        public final int type;

        Symbol(String string, int n) {
            this.name = string;
            this.bind = n >> 4 & 0xF;
            this.type = n & 0xF;
        }
    }
}

