/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.translator;

import com.google.classyshark.silverghost.FullArchiveReader;
import com.google.classyshark.silverghost.plugins.EmptyFullArchiveReader;
import com.google.classyshark.silverghost.translator.Translator;
import com.google.classyshark.silverghost.translator.apk.ApkTranslator;
import com.google.classyshark.silverghost.translator.dex.DexInfoTranslator;
import com.google.classyshark.silverghost.translator.elf.ElfTranslator;
import com.google.classyshark.silverghost.translator.jar.JarInfoTranslator;
import com.google.classyshark.silverghost.translator.java.JavaTranslator;
import com.google.classyshark.silverghost.translator.xml.AndroidXmlTranslator;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class TranslatorFactory {
    public static Translator createTranslator(String string, File file) {
        return TranslatorFactory.createTranslator(string, file, new LinkedList<String>(), null);
    }

    public static Translator createTranslator(String string, File file, List<String> list) {
        return TranslatorFactory.createTranslator(string, file, list, null);
    }

    public static Translator createTranslator(String string, File file, List<String> list, FullArchiveReader fullArchiveReader) {
        if (string.endsWith(".xml")) {
            return new AndroidXmlTranslator(string, file);
        }
        if (string.endsWith(".dex")) {
            return new DexInfoTranslator(string, file);
        }
        if (string.endsWith(".jar")) {
            return new JarInfoTranslator(file, list);
        }
        if (string.endsWith(".apk")) {
            return new ApkTranslator(file);
        }
        if (string.endsWith(".so")) {
            return new ElfTranslator(string, file);
        }
        if (fullArchiveReader != null && !(fullArchiveReader instanceof EmptyFullArchiveReader)) {
            return fullArchiveReader.buildTranslator(string, file);
        }
        return new JavaTranslator(string, file);
    }
}

