/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.exporter;

import com.google.classyshark.silverghost.exporter.MethodCountExporter;
import com.google.classyshark.silverghost.methodscounter.ClassNode;
import java.io.PrintWriter;
import java.util.Iterator;

public class TreeMethodCountExporter
implements MethodCountExporter {
    private PrintWriter pw;

    public TreeMethodCountExporter(PrintWriter printWriter) {
        this.pw = printWriter;
    }

    @Override
    public void exportMethodCounts(ClassNode classNode) {
        this.printNode(classNode, new boolean[]{true});
        this.pw.flush();
    }

    private void printNode(ClassNode classNode, boolean[] blArray) {
        this.renderTreeStructure(blArray);
        this.pw.println(classNode.getKey() + " - " + classNode.getMethodCount());
        Iterator<ClassNode> iterator = classNode.getChildNodes().values().iterator();
        boolean[] blArray2 = new boolean[blArray.length + 1];
        System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
        while (iterator.hasNext()) {
            ClassNode classNode2 = iterator.next();
            blArray2[blArray2.length - 1] = !iterator.hasNext();
            this.printNode(classNode2, blArray2);
        }
    }

    private void renderTreeStructure(boolean[] blArray) {
        if (blArray.length == 1) {
            return;
        }
        for (int i = 1; i < blArray.length; ++i) {
            if (i == blArray.length - 1) {
                if (blArray[i]) {
                    this.pw.print(" \u255a");
                    continue;
                }
                this.pw.print(" \u2560");
                continue;
            }
            if (blArray[i]) {
                this.pw.print("  ");
                if (i <= 0) continue;
                this.pw.print(" ");
                continue;
            }
            this.pw.print(" \u2551");
        }
        this.pw.print('\u2550');
    }
}

