/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.exporter;

import com.google.classyshark.silverghost.contentreader.ContentReader;
import com.google.classyshark.silverghost.exporter.TreeMethodCountExporter;
import com.google.classyshark.silverghost.methodscounter.ClassNode;
import com.google.classyshark.silverghost.methodscounter.RootBuilder;
import com.google.classyshark.silverghost.translator.Translator;
import com.google.classyshark.silverghost.translator.TranslatorFactory;
import com.google.classyshark.silverghost.translator.dex.DexMethodsDumper;
import com.google.classyshark.silverghost.translator.dex.DexStringsDumper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;

public class Exporter {
    private Exporter() {
    }

    public static void writeArchive(File file, List<String> list) throws Exception {
        Exporter.writeManifest(file);
        Exporter.writeClassNames(list);
        Exporter.writeMethods(file);
        Exporter.writeStringTables(file);
        Exporter.writeMethodCounts(file);
    }

    public static void writeCurrentClass(String string, String string2) throws IOException {
        Exporter.writeString(string + "_dump", string2);
    }

    public static void writeMethodCounts(File file) {
        File file2 = new File("method_counts.txt");
        System.out.println(file2.toString());
        try (PrintWriter printWriter = new PrintWriter(file2);){
            RootBuilder rootBuilder = new RootBuilder();
            ClassNode classNode = rootBuilder.fillClassesWithMethods(file);
            TreeMethodCountExporter treeMethodCountExporter = new TreeMethodCountExporter(printWriter);
            treeMethodCountExporter.exportMethodCounts(classNode);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    public static void writeManifest(File file) throws IOException {
        if (file.getName().endsWith(".apk")) {
            Translator translator = TranslatorFactory.createTranslator("AndroidManifest.xml", file);
            translator.apply();
            Exporter.writeString(translator.getClassName() + "_dump", translator.toString());
        }
    }

    public static void writeClassNames(List<String> list) throws IOException {
        Exporter.writeListStrings(new File("all_classes.txt"), list);
    }

    public static void writeMethods(File file) {
        if (!file.getName().endsWith(".apk")) {
            return;
        }
        List<String> list = DexMethodsDumper.dumpMethods(file);
        Exporter.writeListStrings(new File("all_methods.txt"), list);
    }

    public static void writeStringTables(File file) {
        if (!file.getName().endsWith(".apk")) {
            return;
        }
        List<String> list = DexStringsDumper.dumpStrings(file);
        Exporter.writeListStringsChannel(new File("all_strings.txt"), list);
    }

    private static void writeString(String string, String string2) throws IOException {
        FileWriter fileWriter = new FileWriter(string);
        fileWriter.write(string2);
        fileWriter.close();
    }

    private static void writeListStringsChannel(File file, List<String> list) {
        try {
            byte[] byArray = "                                                       \n".getBytes();
            FileChannel fileChannel = new RandomAccessFile(file, "rw").getChannel();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, list.size() * byArray.length);
            for (int i = 0; i < list.size(); ++i) {
                mappedByteBuffer.put(list.get(i).getBytes());
            }
            fileChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeListStrings(File file, List<String> list) {
        try {
            FileWriter fileWriter = new FileWriter(file);
            for (String string : list) {
                fileWriter.write("\n" + string);
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = System.getProperty("user.home") + "/Desktop/Scenarios/2 Samples/android.jar";
        ContentReader contentReader = new ContentReader(new File(string));
        contentReader.load();
        Exporter.writeClassNames(contentReader.getAllClassNames());
    }
}

