/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.contentreader.dex;

import com.google.classyshark.silverghost.contentreader.BinaryContentReader;
import com.google.classyshark.silverghost.contentreader.ContentReader;
import com.google.classyshark.silverghost.contentreader.dex.DexlibLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;

public class DexReader
implements BinaryContentReader {
    private File binaryArchive;
    private List<String> allClassNames = new ArrayList<String>();

    public DexReader(File file) {
        this.binaryArchive = file;
    }

    @Override
    public void read() {
        try {
            this.allClassNames = DexReader.readClassNamesFromDex(this.binaryArchive);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Collections.sort(this.allClassNames);
    }

    @Override
    public List<String> getClassNames() {
        return this.allClassNames;
    }

    @Override
    public List<ContentReader.Component> getComponents() {
        return new ArrayList<ContentReader.Component>();
    }

    public static List<String> readClassNamesFromDex(File file) throws Exception {
        DexFile dexFile = DexlibLoader.loadDexFile(file);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ClassDef classDef : dexFile.getClasses()) {
            arrayList.add(classDef.getType().replaceAll("/", ".").substring(1, classDef.getType().length() - 1));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public static void main(String[] stringArray) {
        DexReader dexReader = new DexReader(new File("//Users//bfarber//Desktop//classes.dex"));
        dexReader.read();
        System.out.println(dexReader.getClassNames());
    }
}

