/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.contentreader.clazz;

import com.google.classyshark.silverghost.contentreader.BinaryContentReader;
import com.google.classyshark.silverghost.contentreader.ContentReader;
import com.google.classyshark.silverghost.contentreader.clazz.ClassNameVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassReader;

public class ClazzReader
implements BinaryContentReader {
    private File binaryArchive;
    private List<String> allClassNames = new ArrayList<String>();

    public ClazzReader(File file) {
        this.binaryArchive = file;
    }

    @Override
    public void read() {
        try {
            Path path = Paths.get(this.binaryArchive.getAbsolutePath(), new String[0]);
            byte[] byArray = Files.readAllBytes(path);
            ClassNameVisitor classNameVisitor = new ClassNameVisitor();
            ClassReader classReader = new ClassReader(byArray);
            classReader.accept(classNameVisitor, 0);
            String string = classNameVisitor.getName();
            this.allClassNames.add(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public List<String> getClassNames() {
        return this.allClassNames;
    }

    @Override
    public List<ContentReader.Component> getComponents() {
        return new ArrayList<ContentReader.Component>();
    }
}

