/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.silverghost.contentreader.aar;

import com.google.classyshark.silverghost.contentreader.BinaryContentReader;
import com.google.classyshark.silverghost.contentreader.ContentReader;
import com.google.classyshark.silverghost.contentreader.jar.JarReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class AarReader
implements BinaryContentReader {
    private File binaryArchive;
    private List<String> allClassNames = new ArrayList<String>();
    private List<ContentReader.Component> components = new ArrayList<ContentReader.Component>();

    public AarReader(File file) {
        this.binaryArchive = file;
    }

    @Override
    public void read() {
        try {
            ZipEntry zipEntry;
            File file = File.createTempFile("classes", "jar");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileInputStream fileInputStream = new FileInputStream(this.binaryArchive);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.getName().endsWith(".jar")) {
                    int n;
                    byte[] byArray = new byte[8192];
                    while ((n = zipInputStream.read(byArray)) != -1) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n);
                    }
                    this.allClassNames.addAll(JarReader.readClassNamesFromJar(file, this.components));
                }
                if (!zipEntry.getName().equals("AndroidManifest.xml")) continue;
                this.allClassNames.add("AndroidManifest.xml");
            }
            ((OutputStream)fileOutputStream).close();
            zipInputStream.closeEntry();
            zipInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List<String> getClassNames() {
        return this.allClassNames;
    }

    @Override
    public List<ContentReader.Component> getComponents() {
        return this.components;
    }
}

