/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.gui.theme.dark;

import com.google.classyshark.gui.theme.Theme;
import com.google.classyshark.gui.theme.dark.DarkColorScheme;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;

public class DarkTheme
implements Theme {
    private final ImageIcon toggleIcon = new ImageIcon(this.getClass().getResource("/resources/ic_menu.png"));
    private final ImageIcon recentIcon = new ImageIcon(this.getClass().getResource("/resources/ic_history.png"));
    private final ImageIcon backIcon = new ImageIcon(this.getClass().getResource("/resources/ic_back.png"));
    private final ImageIcon forwardIcon = new ImageIcon(this.getClass().getResource("/resources/ic_next.png"));
    private final ImageIcon openIcon = new ImageIcon(this.getClass().getResource("/resources/ic_open.png"));
    private final ImageIcon exportIcon = new ImageIcon(this.getClass().getResource("/resources/ic_export.png"));
    private final ImageIcon mappingsIcon = new ImageIcon(this.getClass().getResource("/resources/ic_mappings.png"));
    private final ImageIcon settingsIcon = new ImageIcon(this.getClass().getResource("/resources/ic_settings.png"));

    public DarkTheme() {
        UIManager.put("MenuItem.foreground", DarkColorScheme.IDENTIFIERS);
    }

    @Override
    public ImageIcon getToggleIcon() {
        return this.toggleIcon;
    }

    @Override
    public ImageIcon getRecentIcon() {
        return this.recentIcon;
    }

    @Override
    public ImageIcon getBackIcon() {
        return this.backIcon;
    }

    @Override
    public ImageIcon getForwardIcon() {
        return this.forwardIcon;
    }

    @Override
    public ImageIcon getOpenIcon() {
        return this.openIcon;
    }

    @Override
    public ImageIcon getExportIcon() {
        return this.exportIcon;
    }

    @Override
    public ImageIcon getMappingIcon() {
        return this.mappingsIcon;
    }

    @Override
    public ImageIcon getSettingsIcon() {
        return this.settingsIcon;
    }

    @Override
    public Color getDefaultColor() {
        return DarkColorScheme.DEFAULT;
    }

    @Override
    public Color getKeyWordsColor() {
        return DarkColorScheme.KEYWORDS;
    }

    @Override
    public Color getIdentifiersColor() {
        return DarkColorScheme.IDENTIFIERS;
    }

    @Override
    public Color getAnnotationsColor() {
        return DarkColorScheme.ANNOTATIONS;
    }

    @Override
    public Color getSelectionBgColor() {
        return DarkColorScheme.SELECTION_BG;
    }

    @Override
    public Color getNamesColor() {
        return DarkColorScheme.NAMES;
    }

    @Override
    public Color getBackgroundColor() {
        return DarkColorScheme.BACKGROUND;
    }

    @Override
    public void applyTo(Component component) {
        if (this.shallBeLighter(component)) {
            component.setBackground(DarkColorScheme.BACKGROUND_LIGHT);
        } else if (component instanceof JLabel) {
            component.setForeground(DarkColorScheme.IDENTIFIERS);
        } else {
            component.setBackground(DarkColorScheme.BACKGROUND);
        }
        if (component instanceof JTextField) {
            component.setForeground(DarkColorScheme.IDENTIFIERS);
        }
    }

    private boolean shallBeLighter(Component component) {
        return component instanceof JTree || component instanceof JTextField || component instanceof JMenuItem || component instanceof JPopupMenu;
    }
}

