/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.gui.panel.tree;

import com.google.classyshark.gui.GuiMode;
import com.google.classyshark.gui.panel.FileTransferHandler;
import com.google.classyshark.gui.panel.ViewerController;
import com.google.classyshark.gui.panel.reducer.Reducer;
import com.google.classyshark.gui.panel.tree.CellRenderer;
import com.google.classyshark.gui.panel.tree.NodeInfo;
import com.google.classyshark.silverghost.contentreader.ContentReader;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class FilesTree {
    private final ViewerController viewerController;
    private DefaultTreeModel treeModel = null;
    private JTree jTree = null;

    public FilesTree(ViewerController viewerController) {
        this.viewerController = viewerController;
        this.treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.jTree = new JTree(this.treeModel);
        this.jTree.setDragEnabled(true);
        this.jTree.setTransferHandler(new FileTransferHandler(this.viewerController));
        this.jTree.setCellRenderer(new CellRenderer());
        this.configureJTree(this.jTree);
        GuiMode.getTheme().applyTo(this.jTree);
    }

    public void fillArchive(File file, List<String> list, List<ContentReader.Component> list2) {
        if (!file.getName().contains(".")) {
            TreeNode treeNode = this.createEmptyJTreeModelClass();
            this.treeModel.setRoot(treeNode);
            return;
        }
        TreeNode treeNode = this.createTreeModel(file, list, list2);
        this.treeModel.setRoot(treeNode);
    }

    private TreeNode createTreeModel(File file, List<String> list, List<ContentReader.Component> list2) {
        TreeNode treeNode = file.getName().endsWith("dex") || file.getName().endsWith("apk") || file.getName().endsWith("aar") ? this.createJTreeModelAndroid(file.getName(), list, list2) : this.createJTreeModelClass(file.getName(), list, list2);
        return treeNode;
    }

    private TreeNode createJTreeModelAndroid(String string, List<String> list, List<ContentReader.Component> list2) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("classes");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("res");
        DefaultMutableTreeNode defaultMutableTreeNode4 = defaultMutableTreeNode2;
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        String string2 = null;
        String string3 = null;
        DefaultMutableTreeNode defaultMutableTreeNode5 = null;
        DefaultMutableTreeNode defaultMutableTreeNode6 = null;
        for (int i = 0; i < list.size(); ++i) {
            String string4;
            String object = list.get(i);
            if (object.endsWith(".xml")) {
                if (object.lastIndexOf(File.separator) > 0) {
                    string4 = object.substring(0, object.lastIndexOf(File.separator));
                    if (string3 == null || !string4.equals(string3)) {
                        string3 = string4;
                        defaultMutableTreeNode6 = new DefaultMutableTreeNode(string4);
                        defaultMutableTreeNode3.add(defaultMutableTreeNode6);
                    }
                    defaultMutableTreeNode6.add(new DefaultMutableTreeNode(object));
                    continue;
                }
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(object));
                continue;
            }
            if (object.endsWith(".dex")) {
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(object);
                defaultMutableTreeNode2.add(defaultMutableTreeNode4);
                continue;
            }
            if (object.lastIndexOf(46) >= 0) {
                string4 = object.substring(0, object.lastIndexOf(46));
                if (!string4.equals(string2)) {
                    string2 = string4;
                    defaultMutableTreeNode5 = new DefaultMutableTreeNode(string4);
                    defaultMutableTreeNode4.add(defaultMutableTreeNode5);
                }
                defaultMutableTreeNode5.add(new DefaultMutableTreeNode(new NodeInfo(object)));
                continue;
            }
            arrayList.add(new DefaultMutableTreeNode(new NodeInfo(object)));
        }
        if (defaultMutableTreeNode5 != null && defaultMutableTreeNode4.isLeaf()) {
            defaultMutableTreeNode4.add(defaultMutableTreeNode5);
        }
        for (DefaultMutableTreeNode defaultMutableTreeNode7 : arrayList) {
            defaultMutableTreeNode4.add(defaultMutableTreeNode7);
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        this.fillComponents(defaultMutableTreeNode, list2);
        return defaultMutableTreeNode;
    }

    private void fillComponents(DefaultMutableTreeNode defaultMutableTreeNode, List<ContentReader.Component> list) {
        if (!list.isEmpty()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("libs");
            Collections.sort(list, new Comparator<ContentReader.Component>(){

                @Override
                public int compare(ContentReader.Component component, ContentReader.Component component2) {
                    return component.name.compareTo(component2.name);
                }
            });
            for (ContentReader.Component component : list) {
                if (!component.component.equals((Object)ContentReader.ARCHIVE_COMPONENT.NATIVE_LIBRARY)) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(component.name));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private TreeNode createJTreeModelClass(String string, List<String> list, List<ContentReader.Component> list2) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("classes");
        String string2 = null;
        DefaultMutableTreeNode defaultMutableTreeNode3 = null;
        for (int i = 0; i < list.size(); ++i) {
            String string3 = list.get(i);
            String string4 = string3;
            if (string4.lastIndexOf(46) > 0) {
                string4 = string4.substring(0, string4.lastIndexOf(46));
            }
            if (string2 == null || !string4.equals(string2)) {
                string2 = string4;
                defaultMutableTreeNode3 = new DefaultMutableTreeNode(string4);
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
            defaultMutableTreeNode3.add(new DefaultMutableTreeNode(new NodeInfo(string3)));
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.fillComponents(defaultMutableTreeNode, list2);
        return defaultMutableTreeNode;
    }

    private TreeNode createEmptyJTreeModelClass() {
        return new DefaultMutableTreeNode("error loading archive");
    }

    public Component getJTree() {
        return this.jTree;
    }

    private void configureJTree(final JTree jTree) {
        jTree.setRootVisible(false);
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)jTree.getCellRenderer();
        defaultTreeCellRenderer.setFont(new Font("Menlo", 0, 18));
        jTree.getSelectionModel().setSelectionMode(1);
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object = jTree.getLastSelectedPathComponent();
                if (object == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                if (object.toString().endsWith(".dex")) {
                    FilesTree.this.viewerController.onSelectedClassName((String)defaultMutableTreeNode.getUserObject());
                    return;
                }
                if (object.toString().endsWith(".jar")) {
                    FilesTree.this.viewerController.onSelectedClassName((String)defaultMutableTreeNode.getUserObject());
                    return;
                }
                if (object.toString().endsWith(".apk")) {
                    FilesTree.this.viewerController.onSelectedClassName((String)defaultMutableTreeNode.getUserObject());
                    return;
                }
                if (object.toString().endsWith(".so")) {
                    FilesTree.this.viewerController.onSelectedClassName((String)defaultMutableTreeNode.getUserObject());
                    return;
                }
                if (!defaultMutableTreeNode.isLeaf()) {
                    return;
                }
                if (FilesTree.this.viewerController != null) {
                    if (defaultMutableTreeNode.getUserObject() instanceof String) {
                        FilesTree.this.viewerController.onSelectedClassName((String)defaultMutableTreeNode.getUserObject());
                    } else {
                        FilesTree.this.viewerController.onSelectedClassName(((NodeInfo)defaultMutableTreeNode.getUserObject()).fullname);
                    }
                }
            }
        });
    }

    public void setVisibleRoot() {
        this.jTree.setRootVisible(true);
    }

    public static void main(String[] stringArray) {
        File file = new File(System.getProperty("user.home") + "/Desktop/Scenarios/2 Samples/android.jar");
        FilesTree filesTree = new FilesTree(null);
        ContentReader contentReader = new ContentReader(file);
        contentReader.load();
        Reducer reducer = new Reducer(contentReader.getAllClassNames());
        reducer.reduce("");
        filesTree.fillArchive(file, reducer.getAllClassNames(), contentReader.getAllComponents());
        for (String object2 : reducer.getAllClassNames()) {
            System.out.println(NodeInfo.extractClassName(object2));
        }
        JFrame jFrame = new JFrame("Test");
        JScrollPane jScrollPane = new JScrollPane(filesTree.getJTree());
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(jScrollPane);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

