/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.gui.panel.toolbar;

import com.google.classyshark.gui.GuiMode;
import com.google.classyshark.gui.panel.toolbar.RecentArchivesButton;
import com.google.classyshark.gui.panel.toolbar.ToolbarController;
import com.google.classyshark.gui.theme.Theme;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class Toolbar
extends JToolBar {
    private final JTextField typingArea;
    private final ToolbarController toolbarController;
    private final Theme theme = GuiMode.getTheme();
    private JButton openBtn;
    private JButton viewBtn;
    private JButton backBtn;
    private JButton exportButton;
    private JButton recentArchivesBtn;
    private JButton mappingBtn;
    private JToggleButton leftPanelToggleBtn;

    public Toolbar(ToolbarController toolbarController) {
        this.toolbarController = toolbarController;
        this.theme.applyTo(this);
        this.typingArea = this.buildTypingArea();
        this.openBtn = this.buildOpenButton();
        this.backBtn = this.buildBackButton();
        this.viewBtn = this.buildViewButton();
        this.mappingBtn = this.buildMappingsButton();
        this.exportButton = this.buildExportButton();
        this.recentArchivesBtn = this.buildRecentArchivesButton();
        this.leftPanelToggleBtn = this.buildLeftPanelToggleButton();
        this.add(this.leftPanelToggleBtn);
        this.add(this.openBtn);
        this.add(this.backBtn);
        this.add(this.viewBtn);
        this.add(this.typingArea);
        this.add(this.mappingBtn);
        this.add(this.exportButton);
        this.add(this.recentArchivesBtn);
        this.add(this.buildSettingsButton());
        this.setFloatable(false);
        this.setTypingAreaCaret();
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    public void addKeyListenerToTypingArea(KeyListener keyListener) {
        this.typingArea.addKeyListener(keyListener);
    }

    public void setTypingAreaCaret() {
        int n = this.typingArea.getDocument().getLength();
        this.typingArea.setCaretPosition(n);
        this.typingArea.setCaretColor(this.theme.getIdentifiersColor());
    }

    public String getText() {
        return this.typingArea.getText();
    }

    public void setText(String string) {
        this.typingArea.setText(string);
    }

    public void activateNavigationButtons() {
        this.viewBtn.setEnabled(true);
        this.backBtn.setEnabled(true);
        this.exportButton.setEnabled(true);
    }

    private JTextField buildTypingArea() {
        final JTextField jTextField = new JTextField(50);
        jTextField.setEnabled(true);
        this.theme.applyTo(jTextField);
        jTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (jTextField.getSelectedText() != null) {
                    String string = Toolbar.this.typingArea.getSelectedText();
                    String string2 = jTextField.getText().substring(0, jTextField.getText().lastIndexOf(string));
                    jTextField.setText(string2);
                    Toolbar.this.toolbarController.onChangedTextFromTypingArea(jTextField.getText());
                }
            }
        });
        return jTextField;
    }

    private JButton buildOpenButton() {
        JButton jButton = new JButton(this.theme.getOpenIcon());
        jButton.setToolTipText("Open file");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.toolbarController.openArchive();
            }
        });
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(true);
        return jButton;
    }

    private JButton buildBackButton() {
        JButton jButton = new JButton(this.theme.getBackIcon());
        jButton.setToolTipText("Back");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.toolbarController.onGoBackPressed();
            }
        });
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(true);
        jButton.setEnabled(false);
        return jButton;
    }

    private JButton buildViewButton() {
        JButton jButton = new JButton(this.theme.getForwardIcon());
        jButton.setToolTipText("Next");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.toolbarController.onViewTopClassPressed();
            }
        });
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(true);
        jButton.setEnabled(false);
        return jButton;
    }

    private JButton buildExportButton() {
        JButton jButton = new JButton(this.theme.getExportIcon());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.toolbarController.onExportButtonPressed();
            }
        });
        jButton.setToolTipText("Export");
        jButton.setBorderPainted(false);
        jButton.setEnabled(false);
        return jButton;
    }

    private JButton buildMappingsButton() {
        JButton jButton = new JButton(this.theme.getMappingIcon());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.toolbarController.onMappingsButtonPressed();
            }
        });
        jButton.setToolTipText("Import Proguard mapping file");
        jButton.setBorderPainted(false);
        jButton.setEnabled(true);
        return jButton;
    }

    private JButton buildRecentArchivesButton() {
        RecentArchivesButton recentArchivesButton = new RecentArchivesButton();
        recentArchivesButton.setPanel(this.toolbarController);
        return recentArchivesButton;
    }

    private JButton buildSettingsButton() {
        JButton jButton = new JButton(this.theme.getSettingsIcon());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.toolbarController.onSettingsButtonPressed();
            }
        });
        jButton.setToolTipText("Settings");
        jButton.setBorderPainted(false);
        return jButton;
    }

    private JToggleButton buildLeftPanelToggleButton() {
        ImageIcon imageIcon = this.theme.getToggleIcon();
        final JToggleButton jToggleButton = new JToggleButton(imageIcon, true);
        jToggleButton.setToolTipText("Show/hide navigation tree");
        jToggleButton.setBorderPainted(false);
        jToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Toolbar.this.toolbarController.onChangeLeftPaneVisibility(jToggleButton.isSelected());
            }
        });
        return jToggleButton;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("ClassyShark");
        Toolbar toolbar = new Toolbar(null);
        toolbar.addKeyListenerToTypingArea(null);
        jFrame.getContentPane().add(toolbar);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

