/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.gui.panel.toolbar;

import com.google.classyshark.gui.GuiMode;
import com.google.classyshark.gui.panel.io.RecentArchivesConfig;
import com.google.classyshark.gui.panel.toolbar.ToolbarController;
import com.google.classyshark.gui.theme.Theme;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class RecentArchivesButton
extends JButton {
    private JPopupMenu popup;
    private ToolbarController panel;
    private final Theme theme = GuiMode.getTheme();

    public RecentArchivesButton() {
        this.setIcon(GuiMode.getTheme().getRecentIcon());
        this.setToolTipText("History");
        this.popup = new JPopupMenu();
        this.theme.applyTo(this.popup);
        this.popup.setLayout(new BoxLayout(this.popup, 1));
        this.popup.addPopupMenuListener(new PopupPrintListener());
        this.buildPopup();
        this.setBorderPainted(false);
        this.setFocusPainted(true);
        this.addMouseListener(new MousePopupListener());
    }

    public void setPanel(ToolbarController toolbarController) {
        this.panel = toolbarController;
    }

    private void buildPopup() {
        this.popup.removeAll();
        for (String string : RecentArchivesConfig.INSTANCE.getRecentArchiveNames()) {
            JMenuItem jMenuItem = new JMenuItem(string);
            this.theme.applyTo(jMenuItem);
            this.popup.add(jMenuItem);
            jMenuItem.setHorizontalTextPosition(4);
            jMenuItem.addActionListener(new RecentFilesListener(string));
        }
        this.popup.addSeparator();
        final JMenuItem jMenuItem = new JMenuItem("Clear");
        this.theme.applyTo(jMenuItem);
        this.popup.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecentArchivesConfig.INSTANCE.clear();
                RecentArchivesButton.this.popup.removeAll();
                RecentArchivesButton.this.popup.updateUI();
                RecentArchivesButton.this.popup.add(jMenuItem);
            }
        });
    }

    private class PopupPrintListener
    implements PopupMenuListener {
        private PopupPrintListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            RecentArchivesButton.this.buildPopup();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    private class MousePopupListener
    extends MouseAdapter {
        private MousePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }

        private void checkPopup(MouseEvent mouseEvent) {
            RecentArchivesButton.this.popup.show(RecentArchivesButton.this, mouseEvent.getX() - (int)RecentArchivesButton.this.popup.getPreferredSize().getWidth(), mouseEvent.getY());
        }
    }

    private class RecentFilesListener
    implements ActionListener {
        private String archiveName;

        public RecentFilesListener(String string) {
            this.archiveName = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RecentArchivesButton.this.panel.displayArchive(new File(RecentArchivesConfig.INSTANCE.getFilePath(this.archiveName), this.archiveName));
            RecentArchivesButton.this.buildPopup();
        }
    }
}

