/*
 * Decompiled with CFR 0.152.
 */
package com.google.classyshark.gui.panel.reducer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Reducer {
    private List<String> allClassNames;
    private List<String> reducedClassNames;

    public Reducer(List<String> list) {
        this.allClassNames = list;
        this.reducedClassNames = new ArrayList<String>();
    }

    public List<String> reduce(String string) {
        if (string.isEmpty()) {
            List<String> list = this.allClassNames;
            this.reducedClassNames.clear();
            return list;
        }
        List<String> list = this.reducedClassNames = Reducer.fuzzyReduceClassNames(string, this.allClassNames);
        return list;
    }

    public String getAutocompleteClassName() {
        if (!this.reducedClassNames.isEmpty()) {
            return this.reducedClassNames.get(0);
        }
        return this.allClassNames.get(0);
    }

    public List<String> getAllClassNames() {
        return Collections.unmodifiableList(this.allClassNames);
    }

    private static List<String> fuzzyReduceClassNames(String string, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2;
            String string3 = string2 = iterator.next();
            string3 = string3.replaceAll("[^A-Z]", "");
            int n = string2.indexOf(string);
            if (!string3.equalsIgnoreCase(string) && n <= -1) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }
}

