/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.gui.jobs.BackgroundJob;
import jadx.gui.jobs.BackgroundWorker;
import jadx.gui.jobs.DecompileJob;
import jadx.gui.jobs.IndexJob;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.ProgressPanel;
import jadx.gui.ui.TabbedPane;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.JumpPosition;
import jadx.gui.utils.NLS;
import jadx.gui.utils.search.TextSearchIndex;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonSearchDialog
extends JDialog {
    private static final long serialVersionUID = 8939332306115370276L;
    private static final Logger LOG = LoggerFactory.getLogger(CommonSearchDialog.class);
    public static final int RESULTS_PER_PAGE = 100;
    protected final transient TabbedPane tabbedPane;
    protected final transient CacheObject cache;
    protected final transient MainWindow mainWindow;
    protected final transient Font codeFont;
    protected ResultsModel resultsModel;
    protected ResultsTable resultsTable;
    protected JLabel resultsInfoLabel;
    protected JLabel warnLabel;
    protected ProgressPanel progressPane;
    protected String highlightText;
    protected boolean highlightTextCaseInsensitive = false;

    public CommonSearchDialog(MainWindow mainWindow) {
        super(mainWindow);
        this.mainWindow = mainWindow;
        this.tabbedPane = mainWindow.getTabbedPane();
        this.cache = mainWindow.getCacheObject();
        this.codeFont = mainWindow.getSettings().getFont();
    }

    protected abstract void openInit();

    protected abstract void loadFinished();

    protected abstract void loadStart();

    public void loadWindowPos() {
        this.mainWindow.getSettings().loadWindowPos(this);
    }

    public void prepare() {
        if (this.cache.getIndexJob().isComplete()) {
            this.loadFinishedCommon();
            this.loadFinished();
            return;
        }
        LoadTask task = new LoadTask();
        task.addPropertyChangeListener(this.progressPane);
        task.execute();
    }

    protected void registerInitOnOpen() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                SwingUtilities.invokeLater(CommonSearchDialog.this::openInit);
            }
        });
    }

    protected synchronized void performSearch() {
        this.resultsTable.updateTable();
        this.updateProgressLabel();
    }

    protected void openSelectedItem() {
        int selectedId = this.resultsTable.getSelectedRow();
        if (selectedId == -1) {
            return;
        }
        JNode node = (JNode)this.resultsModel.getValueAt(selectedId, 0);
        this.tabbedPane.codeJump(new JumpPosition(node.getRootClass(), node.getLine()));
        this.dispose();
    }

    @Override
    public void dispose() {
        this.mainWindow.getSettings().saveWindowPos(this);
        super.dispose();
    }

    protected void initCommon() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().registerKeyboardAction(e -> this.dispose(), stroke, 2);
    }

    @NotNull
    protected JPanel initButtonsPanel() {
        this.progressPane = new ProgressPanel(this.mainWindow, false);
        JButton cancelButton = new JButton(NLS.str("search_dialog.cancel"));
        cancelButton.addActionListener(event -> this.dispose());
        JButton openBtn = new JButton(NLS.str("search_dialog.open"));
        openBtn.addActionListener(event -> this.openSelectedItem());
        this.getRootPane().setDefaultButton(openBtn);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(this.progressPane);
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(openBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        return buttonPane;
    }

    protected JPanel initResultsTable() {
        ResultsTableCellRenderer renderer = new ResultsTableCellRenderer();
        this.resultsModel = new ResultsModel(renderer);
        this.resultsModel.addTableModelListener(e -> this.updateProgressLabel());
        this.resultsTable = new ResultsTable(this.resultsModel, renderer);
        this.resultsTable.setShowHorizontalLines(false);
        this.resultsTable.setDragEnabled(false);
        this.resultsTable.setSelectionMode(0);
        this.resultsTable.setColumnSelectionAllowed(false);
        this.resultsTable.setAutoResizeMode(0);
        this.resultsTable.setAutoscrolls(false);
        this.resultsTable.setDefaultRenderer(Object.class, renderer);
        Enumeration<TableColumn> columns = this.resultsTable.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            column.setCellRenderer(renderer);
        }
        this.resultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    CommonSearchDialog.this.openSelectedItem();
                }
            }
        });
        this.resultsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CommonSearchDialog.this.openSelectedItem();
                }
            }
        });
        this.warnLabel = new JLabel();
        this.warnLabel.setForeground(Color.RED);
        this.warnLabel.setVisible(false);
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new BoxLayout(resultsPanel, 3));
        resultsPanel.add(this.warnLabel);
        resultsPanel.add(new JScrollPane(this.resultsTable, 20, 30));
        JPanel paginationPanel = new JPanel();
        paginationPanel.setAlignmentX(0.0f);
        paginationPanel.setLayout(new BoxLayout(paginationPanel, 0));
        this.resultsInfoLabel = new JLabel("");
        JButton nextPageButton = new JButton("->");
        nextPageButton.setToolTipText(NLS.str("search_dialog.next_page"));
        nextPageButton.addActionListener(e -> {
            if (this.resultsModel.nextPage()) {
                this.switchPage(renderer);
            }
        });
        JButton prevPageButton = new JButton("<-");
        prevPageButton.setToolTipText(NLS.str("search_dialog.prev_page"));
        prevPageButton.addActionListener(e -> {
            if (this.resultsModel.prevPage()) {
                this.switchPage(renderer);
            }
        });
        paginationPanel.add(prevPageButton);
        paginationPanel.add(nextPageButton);
        paginationPanel.add(this.resultsInfoLabel);
        resultsPanel.add(paginationPanel);
        resultsPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        return resultsPanel;
    }

    private void switchPage(ResultsTableCellRenderer renderer) {
        renderer.clear();
        this.resultsTable.updateTable();
        this.updateProgressLabel();
        this.resultsTable.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
    }

    protected void updateProgressLabel() {
        String statusText = String.format(NLS.str("search_dialog.info_label"), this.resultsModel.getDisplayedResultsStart(), this.resultsModel.getDisplayedResultsEnd(), this.resultsModel.getResultCount());
        this.resultsInfoLabel.setText(statusText);
    }

    protected void loadStartCommon() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.progressPane.setIndeterminate(true);
        this.progressPane.setVisible(true);
        this.resultsTable.setEnabled(false);
        this.warnLabel.setVisible(false);
    }

    private void loadFinishedCommon() {
        this.setCursor(null);
        this.resultsTable.setEnabled(true);
        this.progressPane.setVisible(false);
        TextSearchIndex textIndex = this.cache.getTextIndex();
        if (textIndex == null) {
            this.warnLabel.setText(NLS.str("msg.index_not_initialized"));
            this.warnLabel.setVisible(true);
        }
    }

    private class LoadTask
    extends SwingWorker<Void, Void> {
        public LoadTask() {
            CommonSearchDialog.this.loadStartCommon();
            CommonSearchDialog.this.loadStart();
        }

        @Override
        public Void doInBackground() {
            try {
                BackgroundWorker backgroundWorker = CommonSearchDialog.this.mainWindow.getBackgroundWorker();
                if (backgroundWorker == null) {
                    return null;
                }
                backgroundWorker.exec();
                DecompileJob decompileJob = CommonSearchDialog.this.cache.getDecompileJob();
                CommonSearchDialog.this.progressPane.changeLabel(this, decompileJob.getInfoString());
                decompileJob.processAndWait();
                IndexJob indexJob = CommonSearchDialog.this.cache.getIndexJob();
                CommonSearchDialog.this.progressPane.changeLabel(this, ((BackgroundJob)indexJob).getInfoString());
                indexJob.processAndWait();
            }
            catch (Exception e) {
                LOG.error("Waiting background tasks failed", (Throwable)e);
            }
            return null;
        }

        @Override
        public void done() {
            try {
                this.get();
            }
            catch (Exception e) {
                LOG.error("Load task failed", (Throwable)e);
            }
            CommonSearchDialog.this.loadFinishedCommon();
            CommonSearchDialog.this.loadFinished();
        }
    }

    protected class ResultsTableCellRenderer
    implements TableCellRenderer {
        private final JLabel emptyLabel = new JLabel();
        private final Font font;
        private final Color codeSelectedColor;
        private final Color codeBackground;
        private final Map<Integer, Component> componentCache = new HashMap<Integer, Component>();

        public ResultsTableCellRenderer() {
            RSyntaxTextArea area = CodeArea.getDefaultArea(CommonSearchDialog.this.mainWindow);
            this.font = area.getFont();
            this.codeSelectedColor = area.getSelectionColor();
            this.codeBackground = area.getBackground();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            int id = row << 2 | column;
            Component comp = this.componentCache.get(id);
            if (comp == null) {
                if (obj instanceof JNode) {
                    comp = this.makeCell((JNode)obj, column);
                    this.componentCache.put(id, comp);
                } else {
                    comp = this.emptyLabel;
                }
            }
            this.updateSelection(table, comp, isSelected);
            return comp;
        }

        private void updateSelection(JTable table, Component comp, boolean isSelected) {
            if (comp instanceof RSyntaxTextArea) {
                if (isSelected) {
                    comp.setBackground(this.codeSelectedColor);
                } else {
                    comp.setBackground(this.codeBackground);
                }
            } else if (isSelected) {
                comp.setBackground(table.getSelectionBackground());
                comp.setForeground(table.getSelectionForeground());
            } else {
                comp.setBackground(table.getBackground());
                comp.setForeground(table.getForeground());
            }
        }

        private Component makeCell(JNode node, int column) {
            if (column == 0) {
                JLabel label = new JLabel(node.makeLongString() + "  ", node.getIcon(), 2);
                label.setFont(this.font);
                label.setOpaque(true);
                label.setToolTipText(label.getText());
                return label;
            }
            if (!node.hasDescString()) {
                return this.emptyLabel;
            }
            RSyntaxTextArea textArea = CodeArea.getDefaultArea(CommonSearchDialog.this.mainWindow);
            textArea.setLayout((LayoutManager)new GridLayout(1, 1));
            textArea.setEditable(false);
            textArea.setSyntaxEditingStyle("text/java");
            textArea.setText("  " + node.makeDescString());
            textArea.setRows(1);
            textArea.setColumns(textArea.getText().length() + 1);
            if (CommonSearchDialog.this.highlightText != null) {
                SearchContext searchContext = new SearchContext(CommonSearchDialog.this.highlightText);
                searchContext.setMatchCase(!CommonSearchDialog.this.highlightTextCaseInsensitive);
                searchContext.setMarkAll(true);
                SearchEngine.markAll((RTextArea)textArea, (SearchContext)searchContext);
            }
            return textArea;
        }

        public void clear() {
            this.componentCache.clear();
        }
    }

    protected static class ResultsModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -7821286846923903208L;
        private static final String[] COLUMN_NAMES = new String[]{NLS.str("search_dialog.col_node"), NLS.str("search_dialog.col_code")};
        private final transient ArrayList<JNode> rows = new ArrayList();
        private final transient ResultsTableCellRenderer renderer;
        private transient boolean addDescColumn;
        private transient int start = 0;

        public ResultsModel(ResultsTableCellRenderer renderer) {
            this.renderer = renderer;
        }

        protected void addAll(Collection<? extends JNode> nodes) {
            this.rows.ensureCapacity(this.rows.size() + nodes.size());
            this.rows.addAll(nodes);
            if (!this.addDescColumn) {
                for (JNode row : this.rows) {
                    if (!row.hasDescString()) continue;
                    this.addDescColumn = true;
                    break;
                }
            }
        }

        public void clear() {
            this.start = 0;
            this.addDescColumn = false;
            this.rows.clear();
            this.renderer.clear();
        }

        public boolean isAddDescColumn() {
            return this.addDescColumn;
        }

        public int getResultCount() {
            return this.rows.size();
        }

        public int getDisplayedResultsStart() {
            if (this.rows.isEmpty()) {
                return 0;
            }
            return this.start + 1;
        }

        public int getDisplayedResultsEnd() {
            return Math.min(this.rows.size(), this.start + 100);
        }

        public boolean nextPage() {
            if (this.start + 100 < this.rows.size()) {
                this.start += 100;
                return true;
            }
            return false;
        }

        public boolean prevPage() {
            if (this.start - 100 >= 0) {
                this.start -= 100;
                return true;
            }
            return false;
        }

        @Override
        public int getRowCount() {
            if (this.rows.isEmpty()) {
                return 0;
            }
            return this.getDisplayedResultsEnd() - this.start;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int index) {
            return COLUMN_NAMES[index];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rows.get(rowIndex + this.start);
        }
    }

    protected static class ResultsTable
    extends JTable {
        private static final long serialVersionUID = 3901184054736618969L;
        private final transient ResultsTableCellRenderer renderer;

        public ResultsTable(ResultsModel resultsModel, ResultsTableCellRenderer renderer) {
            super(resultsModel);
            this.renderer = renderer;
        }

        public void updateTable() {
            ResultsModel model = (ResultsModel)this.getModel();
            TableColumnModel columnModel = this.getColumnModel();
            int width = this.getParent().getWidth();
            int firstColMaxWidth = (int)((double)width * 0.5);
            int rowCount = this.getRowCount();
            int columnCount = this.getColumnCount();
            if (!model.isAddDescColumn()) {
                firstColMaxWidth = width;
            }
            Component nodeComp = null;
            Component codeComp = null;
            for (int col = 0; col < columnCount; ++col) {
                int colWidth = 50;
                for (int row = 0; row < rowCount; ++row) {
                    Component comp = this.prepareRenderer(this.renderer, row, col);
                    if (comp == null) continue;
                    colWidth = Math.max(comp.getPreferredSize().width, colWidth);
                    if (nodeComp == null && col == 0) {
                        nodeComp = comp;
                    }
                    if (codeComp != null || col != 1) continue;
                    codeComp = comp;
                }
                colWidth += 10;
                colWidth = col == 0 ? Math.min(colWidth, firstColMaxWidth) : Math.max(colWidth, width - columnModel.getColumn(0).getPreferredWidth());
                TableColumn column = columnModel.getColumn(col);
                column.setPreferredWidth(colWidth);
            }
            this.updateUI();
            this.setRowHeight(Math.max(this.getHeight(nodeComp), this.getHeight(codeComp) + 4));
        }

        private int getHeight(@Nullable Component nodeComp) {
            if (nodeComp != null) {
                return Math.max(nodeComp.getHeight(), nodeComp.getPreferredSize().height);
            }
            return 0;
        }
    }
}

