/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.propertyview;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.propertyview.DisplayInfoForm;
import com.paterva.maltego.propertyview.PropertyTypes;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.ui.dialog.DataEditController;
import java.util.Arrays;
import java.util.Optional;

public class DisplayInfoFormController
extends DataEditController<DisplayInfoForm, MaltegoEntity> {
    public static final String ENTITY = "entity";
    private final PropertyDescriptor dummyProperty = new PropertyDescriptor(DisplayInfoFormController.class, "<default>", "<Get from entity type>");

    public DisplayInfoFormController() {
        super(ENTITY);
    }

    protected String getFirstError(DisplayInfoForm component) {
        return null;
    }

    protected DisplayInfoForm createComponent() {
        DisplayInfoForm f = new DisplayInfoForm();
        f.addChangeListener(this.changeListener());
        return f;
    }

    protected void setData(DisplayInfoForm component, MaltegoEntity data) {
        PropertyDescriptor[] displayValueDescriptors = PropertyTypes.getDisplayValueProperties(data);
        PropertyDescriptor[] displayValueProperties = new PropertyDescriptor[displayValueDescriptors.length + 1];
        System.arraycopy(displayValueDescriptors, 0, displayValueProperties, 1, displayValueDescriptors.length);
        displayValueProperties[0] = this.dummyProperty;
        PropertyDescriptor[] imageDescriptors = PropertyTypes.getImageProperties(data);
        PropertyDescriptor[] imageProperties = new PropertyDescriptor[imageDescriptors.length + 1];
        System.arraycopy(imageDescriptors, 0, imageProperties, 1, imageDescriptors.length);
        imageProperties[0] = this.dummyProperty;
        component.setDisplayValueProperties(displayValueProperties);
        data.getDisplayValueExpression().ifPresent(dispExpr -> {
            Optional<PropertyDescriptor> propOpt = this.getProperty(displayValueProperties, (String)dispExpr);
            component.setDisplayValueObject(propOpt.isPresent() ? propOpt.get() : dispExpr);
        });
        component.setImageProperties(imageProperties);
        data.getNonBlankImageExpression().ifPresent(imgExpr -> {
            Optional<PropertyDescriptor> propOpt = this.getProperty(imageProperties, (String)imgExpr);
            component.setImageObject(propOpt.isPresent() ? propOpt.get() : imgExpr);
        });
    }

    protected void updateData(DisplayInfoForm component, MaltegoEntity data) {
        Object dispExprObj = component.getDisplayValueObject();
        String dispExpr = this.getExpression(dispExprObj);
        data.setDisplayValueExpression(dispExpr);
        Object imgExprObj = component.getImageObject();
        String imgExpr = this.getExpression(imgExprObj);
        data.setImageExpression(imgExpr);
    }

    private Optional<PropertyDescriptor> getProperty(PropertyDescriptor[] properties, String name) {
        return Arrays.stream(properties).filter(prop -> name.equals(prop.getName())).findFirst();
    }

    private String getExpression(Object exprObj) {
        String expr = exprObj.equals(this.dummyProperty) ? null : (exprObj instanceof DisplayDescriptor ? ((DisplayDescriptor)exprObj).getName() : exprObj.toString());
        return expr;
    }
}

