/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation;

import com.paterva.maltego.automation.Payload;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openide.util.Exceptions;

public abstract class Payloads {
    public static final Payload EMPTY = new Empty();

    public static Payload getEmpty() {
        return EMPTY;
    }

    public static Payload clone(Payload payload) {
        return Payloads.fromEntities(payload.getEntities());
    }

    public static Payload fromEntities(Collection<MaltegoEntity> entities) {
        return new EntityCollection(entities);
    }

    public static Payload fromEntities(MaltegoEntity ... entities) {
        return new EntityCollection(Arrays.asList(entities));
    }

    public static Payload fromPayloads(Collection<Payload> payloads) {
        if (payloads == null || payloads.isEmpty()) {
            return EMPTY;
        }
        if (payloads.size() == 1) {
            return payloads.iterator().next();
        }
        return new Compound(payloads.toArray(new Payload[payloads.size()]));
    }

    public static Payload fromPayloads(Payload[] payloads) {
        if (payloads == null || payloads.length == 0) {
            return EMPTY;
        }
        if (payloads.length == 1) {
            return payloads[0];
        }
        return new Compound(payloads);
    }

    public static Payload filtered(Payload payload, EntityFilter filter) {
        return new Filtered(payload, filter);
    }

    public static Payload max(Payload original, final int maxEntities) {
        return new Filtered(original, new EntityFilter(){
            private int _max;
            {
                this._max = maxEntities;
            }

            @Override
            public boolean include(MaltegoEntity entity) {
                if (this._max > 0) {
                    --this._max;
                    return true;
                }
                return false;
            }
        });
    }

    public static Payload all(GraphID graphID) {
        return new Graph(graphID);
    }

    public static abstract class Abstract
    implements Payload {
        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void sync() {
        }
    }

    private static class Empty
    extends Abstract {
        private Empty() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Collection<EntityID> getEntityIDs() {
            return Collections.emptySet();
        }

        @Override
        public Collection<MaltegoEntity> getEntities() {
            return Collections.emptySet();
        }
    }

    private static class Compound
    extends Abstract {
        private final Payload[] _payloads;

        public Compound(Payload[] payloads) {
            this._payloads = payloads;
        }

        @Override
        public int size() {
            int size = 0;
            for (Payload payload : this._payloads) {
                size += payload.size();
            }
            return size;
        }

        @Override
        public Collection<EntityID> getEntityIDs() {
            ArrayList<EntityID> entityIDs = new ArrayList<EntityID>(this.size());
            for (Payload payload : this._payloads) {
                entityIDs.addAll(payload.getEntityIDs());
            }
            return entityIDs;
        }

        @Override
        public Collection<MaltegoEntity> getEntities() {
            ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>(this.size());
            for (Payload payload : this._payloads) {
                entities.addAll(payload.getEntities());
            }
            return entities;
        }

        @Override
        public void sync() {
            for (Payload payload : this._payloads) {
                payload.sync();
            }
        }
    }

    private static class EntityCollection
    extends Abstract {
        private final Collection<MaltegoEntity> _entities;

        public EntityCollection(Collection<MaltegoEntity> entities) {
            this._entities = Collections.unmodifiableCollection(entities);
        }

        @Override
        public int size() {
            return this._entities.size();
        }

        @Override
        public Collection<EntityID> getEntityIDs() {
            return GraphStoreHelper.getIds(this._entities);
        }

        @Override
        public Collection<MaltegoEntity> getEntities() {
            return this._entities;
        }
    }

    public static class Filtered
    extends Abstract {
        private final Payload _payload;
        private final EntityFilter _filter;
        private List<MaltegoEntity> _entities;

        public Filtered(Payload payload, EntityFilter filter) {
            this._payload = payload;
            this._filter = filter;
        }

        @Override
        public int size() {
            return this.getEntities().size();
        }

        @Override
        public Collection<EntityID> getEntityIDs() {
            return GraphStoreHelper.getIds(this.getEntities());
        }

        @Override
        public Collection<MaltegoEntity> getEntities() {
            if (this._entities == null) {
                this._entities = new ArrayList<MaltegoEntity>();
                for (MaltegoEntity entity : this._payload.getEntities()) {
                    if (!this._filter.include(entity)) continue;
                    this._entities.add(entity);
                }
            }
            return this._entities;
        }

        @Override
        public void sync() {
            this._payload.sync();
            this._entities = null;
        }
    }

    public static interface EntityFilter {
        public boolean include(MaltegoEntity var1);
    }

    public static class Graph
    extends Abstract {
        private final GraphID _graphID;

        public Graph(GraphID graphID) {
            this._graphID = graphID;
        }

        @Override
        public int size() {
            int size = 0;
            try {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
                GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
                size = structureReader.getEntityCount();
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return size;
        }

        @Override
        public Collection<EntityID> getEntityIDs() {
            return GraphStoreHelper.getEntityIDs((GraphID)this._graphID);
        }

        @Override
        public Collection<MaltegoEntity> getEntities() {
            return GraphStoreHelper.getMaltegoEntities((GraphID)this._graphID);
        }
    }
}

