/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.graph;

import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.impl.DefaultTabularGraphLink;
import com.paterva.maltego.graph.table.ui.graph.ConnectivityNodeRealizer;
import com.paterva.maltego.graph.table.ui.graph.DeleteLinksAction;
import com.paterva.maltego.graph.table.ui.graph.SelectionBoxViewMode;
import com.paterva.maltego.ui.graph.view2d.MacOSXEditMode;
import com.paterva.maltego.ui.graph.view2d.MouseWheelZoomListener;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoLayouter;
import com.paterva.maltego.util.ui.components.MatteBorderLeft;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import yguard.A.A.A;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.A.Z;
import yguard.A.G.H.C;
import yguard.A.G.NA;
import yguard.A.G.O.F;
import yguard.A.G.RA;
import yguard.A.G.n;
import yguard.A.J.BA;
import yguard.A.J.CC;
import yguard.A.J.DA;
import yguard.A.J.E;
import yguard.A.J.GC;
import yguard.A.J.QA;
import yguard.A.J.SA;
import yguard.A.J.U;
import yguard.A.J.mB;
import yguard.A.J.q;
import yguard.A.J.s;
import yguard.A.J.wA;

public class ConnectivityPanel
extends JPanel {
    private U _graphView;
    private Map<TabularGraphEntity, Y> _entityMap;
    private Map<TabularGraphLink, H> _linkMap;
    private JButton _blockLayoutButton;
    private JButton _circularLayoutButton;
    private JPanel _graphViewPanel;
    private JButton _hierarchicalLayoutButton;
    private JButton _wrapLayoutButton;
    private JButton _zoomButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextArea jTextArea1;

    public ConnectivityPanel() {
        this.initComponents();
        this._graphView = new U();
        this.registerViewActions();
        this._graphView.setAntialiasedPainting(true);
        this._graphView.putClientProperty((Object)"selectionbox.linecolor", (Object)new Color(35, 106, 109));
        this._graphView.putClientProperty((Object)"selectionbox.fillcolor", (Object)new Color(217, 242, 241, 70));
        this._graphView.addViewMode((mB)this.createEditMode());
        this._graphViewPanel.add((Component)this._graphView);
        this._blockLayoutButton.setToolTipText("Block Layout");
        this._hierarchicalLayoutButton.setToolTipText("Hierarchical Layout");
        this._circularLayoutButton.setToolTipText("Circular Layout");
        this._wrapLayoutButton.setToolTipText("Wrap Layout");
        this._zoomButton.setToolTipText("Zoom to Fit");
        this._hierarchicalLayoutButton.setVisible(false);
    }

    private void registerViewActions() {
        GC actions = new GC(this._graphView);
        ActionMap amap = this._graphView.getCanvasComponent().getActionMap();
        if (amap != null) {
            amap.put("DELETE_SELECTION", (Action)SystemAction.get(DeleteLinksAction.class));
            InputMap imap = actions.A(amap);
            this._graphView.getCanvasComponent().setInputMap(0, imap);
        }
        this._graphView.getCanvasComponent().addMouseWheelListener((MouseWheelListener)new MouseWheelZoomListener());
    }

    private wA createEditMode() {
        MacOSXEditMode mode = new MacOSXEditMode();
        mode.allowBendCreation(false);
        mode.allowEdgeCreation(true);
        mode.allowLabelSelection(false);
        mode.allowMoveLabels(false);
        mode.allowMovePorts(false);
        mode.allowNodeCreation(false);
        mode.allowNodeEditing(false);
        mode.allowResizeNodes(false);
        mode.setSelectionBoxMode((mB)new SelectionBoxViewMode());
        mB createEdgeMode = mode.getCreateEdgeMode();
        if (createEdgeMode instanceof CC) {
            ((CC)createEdgeMode).allowSelfloopCreation(false);
        }
        return mode;
    }

    public void setTabularGraph(TabularGraph tabularGraph, JTabbedPane mcTabbedPane) {
        if (mcTabbedPane != null && mcTabbedPane.getTabCount() >= 4) {
            if (tabularGraph.getLinks().size() > 0) {
                mcTabbedPane.setEnabledAt(3, true);
            } else {
                mcTabbedPane.setEnabledAt(3, false);
            }
        }
        SA graph2D = new SA();
        this._graphView.setGraph2D(graph2D);
        this.addEntities(tabularGraph);
        this.addLinks(tabularGraph);
        graph2D.A(ge -> {
            if (ge.C() == 1) {
                H edge = (H)ge.A();
                graph2D.A(edge, this.getNextName(graph2D));
            }
            if ((ge.C() == 1 || ge.C() == 5) && mcTabbedPane != null) {
                if (graph2D.\u00d3().size() > 0) {
                    mcTabbedPane.setEnabledAt(3, true);
                } else {
                    mcTabbedPane.setEnabledAt(3, false);
                }
            }
        });
        this.layoutGraph(false, this.getDefaultLayouter());
        SwingUtilities.invokeLater(this::zoomToFit);
    }

    private String getNextName(SA graph2D) {
        String name = null;
        int i = 0;
        do {
            String n2;
            if (this.getEdge(graph2D, n2 = Integer.toString(++i)) != null) continue;
            name = n2;
        } while (name == null);
        return name;
    }

    private H getEdge(SA graph2D, String name) {
        Z edges = graph2D.u();
        while (edges.ok()) {
            H e = edges.D();
            if (name.equals(graph2D.Y(e))) {
                return e;
            }
            edges.next();
        }
        return null;
    }

    private void addEntities(TabularGraph tabularGraph) {
        SA g2D = this._graphView.getGraph2D();
        List entities = tabularGraph.getEntities();
        this._entityMap = new HashMap<TabularGraphEntity, Y>();
        g2D.B((BA)ConnectivityNodeRealizer.create());
        int index = 0;
        for (TabularGraphEntity entity : entities) {
            Y node = g2D.w();
            ConnectivityNodeRealizer nr = (ConnectivityNodeRealizer)g2D.f(node);
            nr.setUserData(entity);
            nr.setEntityIndex(++index);
            g2D.A(node, this.getEntityName(tabularGraph, entity));
            this._entityMap.put(entity, node);
        }
    }

    private void addLinks(TabularGraph tabularGraph) {
        SA g2D = this._graphView.getGraph2D();
        List links = tabularGraph.getLinks();
        this._linkMap = new HashMap<TabularGraphLink, H>();
        g2D.A((q)this.createEdgeRealizer());
        for (TabularGraphLink link : links) {
            Y sourceNode = this._entityMap.get(link.getSource());
            Y targetNode = this._entityMap.get(link.getTarget());
            H edge = g2D.A(sourceNode, targetNode);
            g2D.A(edge, Integer.toString(link.getIndex()));
            this._linkMap.put(link, edge);
        }
    }

    private s createEdgeRealizer() {
        NakedEdgeRealizer er = new NakedEdgeRealizer();
        er.setSourceArrow(E.X);
        er.setSmoothedBends(true);
        er.setTargetArrow(E.f);
        er.setLineColor(MaltegoLinkSpec.getDefaultManualLinkColor());
        er.getLabel().setTextColor(MaltegoLinkSpec.getDefaultManualLinkColor());
        return er;
    }

    private String getEntityName(TabularGraph tabularGraph, TabularGraphEntity entity) {
        int[] columns;
        StringBuilder sb = new StringBuilder();
        String[] columnNames = tabularGraph.getColumnNames();
        for (int i : columns = entity.getColumns()) {
            if (i != columns[0]) {
                sb.append(", ");
            }
            if (columnNames != null) {
                sb.append(columnNames[i]);
                continue;
            }
            sb.append("Column").append(i + 1);
        }
        String name = sb.toString();
        int limit = 20;
        if (name.length() > limit) {
            name = name.substring(0, limit) + "...";
        }
        return name;
    }

    public List<TabularGraphLink> getLinksRemoved() {
        ArrayList<TabularGraphLink> links = new ArrayList<TabularGraphLink>();
        A edgeList = this._graphView.getGraph2D().\u00d3();
        Iterator<Map.Entry<TabularGraphLink, H>> itr = this._linkMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<TabularGraphLink, H> entry = itr.next();
            H edge = entry.getValue();
            if (edgeList.contains((Object)edge)) continue;
            TabularGraphLink link = entry.getKey();
            links.add(link);
            itr.remove();
        }
        return links;
    }

    public List<TabularGraphLink> getLinksAdded() {
        ArrayList<TabularGraphLink> links = new ArrayList<TabularGraphLink>();
        SA graph2D = this._graphView.getGraph2D();
        Z edges = graph2D.u();
        while (edges.ok()) {
            H edge = edges.D();
            if (this.getLink(edge) == null) {
                TabularGraphEntity source = this.getEntity(edge.X());
                TabularGraphEntity target = this.getEntity(edge.V());
                DefaultTabularGraphLink link = new DefaultTabularGraphLink(source, target);
                link.setIndex(Integer.parseInt(graph2D.Y(edge)));
                links.add((TabularGraphLink)link);
                this._linkMap.put((TabularGraphLink)link, edge);
            }
            edges.next();
        }
        return links;
    }

    private TabularGraphLink getLink(H edge) {
        for (Map.Entry<TabularGraphLink, H> entry : this._linkMap.entrySet()) {
            if (!edge.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private TabularGraphEntity getEntity(Y node) {
        for (Map.Entry<TabularGraphEntity, Y> entry : this._entityMap.entrySet()) {
            if (!node.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private n getDefaultLayouter() {
        yguard.A.A.E nodes = this._graphView.getGraph2D().\u00a4();
        while (nodes.ok()) {
            Y node = nodes.B();
            if (node.C() > 1) {
                return new F();
            }
            nodes.next();
        }
        return this.getWrapLayouter();
    }

    private void layoutGraph(boolean morph, n layouter) {
        if (morph) {
            QA layoutMorpher = new QA();
            layoutMorpher.setSmoothViewTransform(true);
            layoutMorpher.setKeepZoomFactor(false);
            DA executor = new DA(3);
            executor.setLayoutMorpher(layoutMorpher);
            executor.doLayout(this._graphView, layouter);
        } else {
            new NA(layouter).doLayout((RA)this._graphView.getGraph2D());
        }
    }

    private void zoomToFit() {
        this._graphView.fitContent();
        this._graphView.updateView();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this._blockLayoutButton = new JButton();
        this._hierarchicalLayoutButton = new JButton();
        this._circularLayoutButton = new JButton();
        this._wrapLayoutButton = new JButton();
        this._zoomButton = new JButton();
        this._graphViewPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jTextArea1 = new JTextArea();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new FlowLayout(0));
        this._blockLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/graph/table/ui/resources/LayoutBlock.png")));
        this._blockLayoutButton.setText(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel._blockLayoutButton.text"));
        this._blockLayoutButton.setPreferredSize(new Dimension(30, 25));
        this._blockLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectivityPanel.this._blockLayoutButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this._blockLayoutButton);
        this._hierarchicalLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/graph/table/ui/resources/LayoutHierarchical.png")));
        this._hierarchicalLayoutButton.setText(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel._hierarchicalLayoutButton.text"));
        this._hierarchicalLayoutButton.setPreferredSize(new Dimension(30, 25));
        this._hierarchicalLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectivityPanel.this._hierarchicalLayoutButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this._hierarchicalLayoutButton);
        this._circularLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/graph/table/ui/resources/LayoutCircular.png")));
        this._circularLayoutButton.setText(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel._circularLayoutButton.text"));
        this._circularLayoutButton.setPreferredSize(new Dimension(30, 25));
        this._circularLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectivityPanel.this._circularLayoutButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this._circularLayoutButton);
        this._wrapLayoutButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/graph/table/ui/resources/LayoutWrap.png")));
        this._wrapLayoutButton.setText(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel._wrapLayoutButton.text"));
        this._wrapLayoutButton.setPreferredSize(new Dimension(30, 25));
        this._wrapLayoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectivityPanel.this._wrapLayoutButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this._wrapLayoutButton);
        this._zoomButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/graph/table/ui/resources/Zoom.png")));
        this._zoomButton.setText(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel._zoomButton.text"));
        this._zoomButton.setPreferredSize(new Dimension(30, 25));
        this._zoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConnectivityPanel.this._zoomButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this._zoomButton);
        this.add((Component)this.jPanel1, "North");
        this._graphViewPanel.setBorder(BorderFactory.createLineBorder(UIManager.getLookAndFeelDefaults().getColor("darculaMod.borderColor")));
        this._graphViewPanel.setPreferredSize(new Dimension(500, 200));
        this._graphViewPanel.setLayout(new BorderLayout());
        this.add((Component)this._graphViewPanel, "Center");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder((Border)new MatteBorderLeft(UIManager.getLookAndFeelDefaults().getInt("TitledBorder.darculaMod.matteBorderWidth"), UIManager.getLookAndFeelDefaults().getColor("TitledBorder.darculaMod.matteBorderColor")), NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel.jPanel2.border.title")));
        this.jPanel2.setLayout(new BorderLayout());
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(2);
        this.jTextArea1.setText(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel.jTextArea1.text"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jPanel2.add((Component)this.jTextArea1, "Center");
        this.add((Component)this.jPanel2, "South");
        this.jPanel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConnectivityPanel.class, (String)"ConnectivityPanel.jPanel2.AccessibleContext.accessibleName"));
    }

    private void _hierarchicalLayoutButtonActionPerformed(ActionEvent evt) {
        this.layoutGraph(true, (n)new C());
    }

    private void _zoomButtonActionPerformed(ActionEvent evt) {
        this.zoomToFit();
    }

    private void _circularLayoutButtonActionPerformed(ActionEvent evt) {
        this.layoutGraph(true, (n)new F());
    }

    private void _blockLayoutButtonActionPerformed(ActionEvent evt) {
        this.layoutGraph(true, (n)new MaltegoLayouter());
    }

    private void _wrapLayoutButtonActionPerformed(ActionEvent evt) {
        this.layoutGraph(true, (n)this.getWrapLayouter());
    }

    private yguard.A.G.U getWrapLayouter() {
        C hierarchicLayouter = new C();
        hierarchicLayouter.setLayoutOrientation((byte)1);
        yguard.A.G.U lineWrapper = new yguard.A.G.U();
        lineWrapper.setCoreLayouter((n)hierarchicLayouter);
        return lineWrapper;
    }

    private static class NakedEdgeRealizer
    extends s {
        public NakedEdgeRealizer() {
        }

        private NakedEdgeRealizer(q er) {
            super(er);
        }

        public q createCopy(q er) {
            return new NakedEdgeRealizer(er);
        }

        protected void paintBends(Graphics2D gd) {
        }

        protected void paintHighlightedBends(Graphics2D gd) {
        }

        protected void paintPorts(Graphics2D gd) {
        }
    }
}

