/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.find;

import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ui.ComponentFlasher;
import com.paterva.maltego.util.ui.components.LabelWithBackground;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.BasicButtonUI;
import org.openide.util.ImageUtilities;

class FindBar
extends JToolBar
implements ActionListener,
KeyListener,
AncestorListener {
    private static final String ENTITIES = "Entities";
    private static final String LINKS = "Links";
    private final JTextField _field = new JTextField(20);
    private final JCheckBox _includeNotes = new JCheckBox("Notes");
    private final JCheckBox _includeInfo = new JCheckBox("Display info");
    private final JCheckBox _includeFields = new JCheckBox("Properties");
    private final JCheckBox _bookmark = new JCheckBox("Bookmark results");
    private final JCheckBox _zoomToResult = new JCheckBox("Zoom");
    private final JComboBox<Object> _types;
    private final JComboBox<String> _parts;
    private final Action _closeAction;
    private final Action _findAction;

    public FindBar(Action findAction, Action closeAction) {
        this._closeAction = closeAction;
        this._findAction = findAction;
        this.setLayout(new BorderLayout());
        this.setAutoscrolls(true);
        this.setRollover(true);
        JButton closeButton = new JButton((Icon)new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/ui/graph/find/Close2.png"))){

            @Override
            public void updateUI() {
                this.setUI(new BasicButtonUI());
            }
        };
        closeButton.setRolloverIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/ui/graph/find/Close_rollover.png")));
        closeButton.setPressedIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/ui/graph/find/Close_pressed.png")));
        closeButton.addActionListener(this);
        closeButton.setActionCommand("close");
        int iconSize = IconSize.TINY.getSize();
        Dimension closeButtonDimension = new Dimension(4 + iconSize, 8 + iconSize);
        closeButton.setMaximumSize(closeButtonDimension);
        closeButton.setPreferredSize(closeButtonDimension);
        closeButton.setOpaque(false);
        closeButton.setFocusPainted(false);
        closeButton.setBorderPainted(false);
        closeButton.setContentAreaFilled(false);
        closeButton.setAlignmentX(0.5f);
        closeButton.setAlignmentY(0.5f);
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 1, 0));
        JButton findButton = new JButton("Find");
        findButton.addActionListener(this);
        findButton.setActionCommand("find");
        this._types = new JComboBox();
        this._parts = new JComboBox<String>(new String[]{ENTITIES, LINKS});
        this._parts.setEditable(false);
        this._parts.addActionListener(evt -> this._types.setEnabled(this.isFindEntities()));
        this._field.addActionListener(this);
        this._field.addKeyListener(this);
        this._includeFields.setToolTipText("Search all properties");
        this._includeNotes.setToolTipText("Search notes");
        this._includeInfo.setToolTipText("Search display information");
        this._zoomToResult.setToolTipText("Zoom to results");
        GridBagLayout layout = new GridBagLayout();
        JPanel panelCentre = new JPanel(layout);
        LabelWithBackground label = new LabelWithBackground("Find:");
        label.setHorizontalAlignment(2);
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(1, 6, 1, 0), 0, 0);
        panelCentre.add((Component)label, gbc);
        gbc = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(1, 0, 1, 5), 0, 0);
        panelCentre.add((Component)this._field, gbc);
        gbc = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(1, 0, 1, 5), 5, 0);
        panelCentre.add(this._parts, gbc);
        gbc = new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(1, 0, 1, 5), 5, 0);
        panelCentre.add(this._types, gbc);
        gbc = new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(1, 0, 1, 5), 0, 0);
        panelCentre.add((Component)findButton, gbc);
        gbc = new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(1, 6, 1, 5), 0, 0);
        panelCentre.add((Component)this._includeFields, gbc);
        gbc = new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(1, 6, 1, 5), 0, 0);
        panelCentre.add((Component)this._includeNotes, gbc);
        gbc = new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(1, 6, 1, 5), 0, 0);
        panelCentre.add((Component)this._includeInfo, gbc);
        gbc = new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(1, 6, 1, 5), 0, 0);
        panelCentre.add((Component)this._zoomToResult, gbc);
        BorderLayout closeLayout = new BorderLayout(0, 0);
        JPanel closePanel = new JPanel(closeLayout);
        closePanel.add(closeButton);
        this.add((Component)panelCentre, "Center");
        this.add((Component)closePanel, "East");
        this.addAncestorListener(this);
    }

    public void setText(String text) {
        this._field.setText(text);
    }

    public boolean isIncludeNotes() {
        return this._includeNotes.isSelected();
    }

    public void setIncludeNotes(boolean selected) {
        this._includeNotes.setSelected(selected);
    }

    public boolean isBookmarkResults() {
        return this._bookmark.isSelected();
    }

    public void setBookmarkResults(boolean selected) {
        this._bookmark.setSelected(selected);
    }

    public boolean isIncludeFields() {
        return this._includeFields.isSelected();
    }

    public void setIncludeFields(boolean selected) {
        this._includeFields.setSelected(selected);
    }

    public boolean isIncludeDisplayInfo() {
        return this._includeInfo.isSelected();
    }

    public void setIncludeDisplayInfo(boolean selected) {
        this._includeInfo.setSelected(selected);
    }

    public boolean isZoomToResult() {
        return this._zoomToResult.isSelected();
    }

    public void setZoomToResult(boolean selected) {
        this._zoomToResult.setSelected(selected);
    }

    public Object[] getOptions() {
        Object[] items = new Object[this._types.getItemCount()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = this._types.getItemAt(i);
        }
        return items;
    }

    public void setOptions(Object[] options) {
        this._types.removeAllItems();
        for (Object o : options) {
            this._types.addItem(o);
        }
        if (options.length > 0) {
            this._types.setSelectedIndex(0);
        }
    }

    public void setSearchText(String text) {
        this._field.setText(text);
    }

    public String getSearchText() {
        return this._field.getText();
    }

    public Object getSelectedOption() {
        return this._types.getSelectedItem();
    }

    public void setSelectedOption(Object obj) {
        this._types.setSelectedItem(obj);
    }

    public boolean isFindEntities() {
        return ENTITIES.equals(this._parts.getSelectedItem());
    }

    public void setFindEntities(boolean findEntities) {
        this._parts.setSelectedItem(findEntities ? ENTITIES : LINKS);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getActionCommand().equals("close")) {
            this._closeAction.actionPerformed(e2);
        } else {
            this._findAction.actionPerformed(e2);
        }
    }

    private void close() {
        this._closeAction.actionPerformed(new ActionEvent(this, 0, "close"));
    }

    @Override
    public void keyTyped(KeyEvent e2) {
        if (e2.getKeyCode() == 27) {
            this.close();
        }
    }

    @Override
    public void keyPressed(KeyEvent e2) {
        if (e2.getKeyCode() == 27) {
            this.close();
        }
    }

    @Override
    public void keyReleased(KeyEvent e2) {
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FindBar.this._field.requestFocusInWindow();
            }
        });
    }

    public void flash() {
        this._field.selectAll();
        ComponentFlasher.flash((Component)this._field, (Color)UIManager.getLookAndFeelDefaults().getColor("component-flasher-background-color"), (int)250, (int)4);
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }
}

