/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp.bosh;

import com.kenai.jbosh.BOSHClient;
import com.kenai.jbosh.BOSHClientConfig;
import com.kenai.jbosh.BOSHClientConnEvent;
import com.kenai.jbosh.BOSHClientConnListener;
import com.kenai.jbosh.BOSHClientRequestListener;
import com.kenai.jbosh.BOSHClientResponseListener;
import com.kenai.jbosh.BOSHMessageEvent;
import com.paterva.maltego.collab.session.xmpp.DummyTrustManager;
import com.paterva.maltego.collab.session.xmpp.bosh.BoshDebug;
import com.paterva.maltego.collab.session.xmpp.bosh.BoshState;
import com.paterva.maltego.collab.session.xmpp.bosh.XmppEndpoint;
import com.paterva.maltego.collab.session.xmpp.bosh.XmppEndpointEvent;
import com.paterva.maltego.collab.session.xmpp.bosh.XmppEndpointListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.openide.util.Exceptions;

class BoshProxy {
    static BoshState Idle = new BoshState.Idle();
    static BoshState Connecting = new BoshState.Connecting();
    static BoshState Closed = new BoshState.Closed();
    static BoshState Connected = new BoshState.Connected();
    static BoshState Authenticated = new BoshState.Authenticated();
    static BoshState Faulted = new BoshState.Faulted();
    private boolean _started = false;
    private BOSHClient _client;
    private XmppEndpoint _server;
    private URI _serverUri;
    private String _serverDomain;
    private BoshState _currentState;
    private ServerConnectionListener _connectionListener;
    private ServerResponseListener _responseListener;
    private ProxyInfo _proxyInfo;
    private boolean _isHttps;

    public BoshProxy(URI boshServer, String boshDomain, InputStream is, OutputStream os, ProxyInfo proxyInfo, boolean isHttps) {
        this._serverDomain = boshDomain;
        this._serverUri = boshServer;
        this._proxyInfo = proxyInfo;
        this._isHttps = isHttps;
        this._client = this.createClient();
        this._server = this.createServer(is, os);
    }

    protected synchronized BoshState getCurrentState() {
        return this._currentState;
    }

    synchronized void setCurrentState(BoshState state, Object ... params) {
        if (this._started) {
            if (this._currentState == state) {
                throw new IllegalStateException("State machine is already in state " + state);
            }
            this._currentState.destroy();
            this._currentState = state;
            this._currentState.start(params);
        }
    }

    public synchronized void start() throws IOException {
        if (!this._started) {
            this._server.start();
            this._started = true;
            this._currentState = new BoshState.Idle(this);
            this.getCurrentState().start(new Object[0]);
        }
    }

    public synchronized void stop() throws IOException {
        if (this._started) {
            this._started = false;
            this._client.removeBOSHClientConnListener((BOSHClientConnListener)this._connectionListener);
            this._client.removeBOSHClientResponseListener((BOSHClientResponseListener)this._responseListener);
            this.getCurrentState().destroy();
            try {
                this._client.disconnect();
                this._client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._server.close();
        }
    }

    private BOSHClient createClient() {
        BOSHClientConfig.Builder builder = BOSHClientConfig.Builder.create((URI)this._serverUri, (String)this._serverDomain);
        if (this._proxyInfo != null && this._proxyInfo.getProxyAddress() != null && !this._proxyInfo.getProxyAddress().isEmpty()) {
            builder = builder.setProxy(this._proxyInfo.getProxyAddress(), this._proxyInfo.getProxyPort());
        }
        if (this._isHttps) {
            try {
                SSLContext sslcontent = SSLContext.getInstance("TLS");
                sslcontent.init(null, new TrustManager[]{new DummyTrustManager()}, new SecureRandom());
                builder = builder.setSSLContext(sslcontent);
            }
            catch (NoSuchAlgorithmException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (KeyManagementException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        BOSHClientConfig cfg = builder.build();
        BOSHClient client = BOSHClient.create((BOSHClientConfig)cfg);
        this._connectionListener = new ServerConnectionListener();
        this._responseListener = new ServerResponseListener();
        client.addBOSHClientConnListener((BOSHClientConnListener)this._connectionListener);
        client.addBOSHClientResponseListener((BOSHClientResponseListener)this._responseListener);
        client.addBOSHClientRequestListener(new BOSHClientRequestListener(){

            public void requestSent(BOSHMessageEvent event) {
                if (BoshDebug.DEBUG) {
                    System.out.println(BoshDebug.format("Sent: " + event.getBody().toXML()));
                }
            }
        });
        client.addBOSHClientResponseListener(new BOSHClientResponseListener(){

            public void responseReceived(BOSHMessageEvent event) {
                if (BoshDebug.DEBUG) {
                    System.out.println(BoshDebug.format("Recv: " + event.getBody().toXML()));
                }
            }
        });
        return client;
    }

    BOSHClient getBoshClient() {
        return this._client;
    }

    private XmppEndpoint createServer(InputStream is, OutputStream os) {
        XmppEndpoint server = new XmppEndpoint(is, os);
        server.addEndpointListener(new ClientPacketListener());
        return server;
    }

    void sendToClient(String block) {
        this._server.sendPacket(block);
    }

    private class ServerConnectionListener
    implements BOSHClientConnListener {
        private ServerConnectionListener() {
        }

        public void connectionEvent(BOSHClientConnEvent event) {
            if (event.isError()) {
                BoshProxy.this.getCurrentState().connectionErrorOccurred(event.getCause());
            } else if (event.isConnected()) {
                System.out.println("Connection established!");
            } else {
                System.out.println("Unknown connection event");
            }
        }
    }

    private class ServerResponseListener
    implements BOSHClientResponseListener {
        private ServerResponseListener() {
        }

        public void responseReceived(BOSHMessageEvent event) {
            BoshState currentState = BoshProxy.this.getCurrentState();
            if (BoshDebug.DEBUG) {
                System.out.println(BoshDebug.format("BOSHClient Recv: " + event.getBody().toXML()));
                System.out.println("currentState = " + currentState);
            }
            currentState.serverMessageReceived(event.getBody());
        }
    }

    private class ClientPacketListener
    implements XmppEndpointListener {
        private ClientPacketListener() {
        }

        @Override
        public void packetReceived(XmppEndpointEvent event) {
            BoshProxy.this.getCurrentState().clientMessageReceived(event.getPacket());
        }
    }
}

