/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.unary.IsConstructorNodeGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSFunction;

@ImportStatic(value={JSConfig.class})
@GenerateUncached
public abstract class IsConstructorNode
extends JavaScriptBaseNode {
    protected IsConstructorNode() {
    }

    public abstract boolean executeBoolean(Object var1);

    @Specialization(guards={"isJSFunction(function)"})
    protected static boolean doJSFunction(DynamicObject function) {
        return JSFunction.isConstructor(function);
    }

    @Specialization(guards={"isJSProxy(proxy)"})
    protected static boolean doJSProxy(DynamicObject proxy) {
        return JSRuntime.isConstructorProxy(proxy);
    }

    @Specialization(guards={"isJSDynamicObject(other)", "!isJSFunction(other)", "!isJSProxy(other)"})
    protected static boolean doOther(Object other) {
        return false;
    }

    @Specialization
    protected static boolean doCharSequence(CharSequence charSequence) {
        return false;
    }

    @Specialization
    protected static boolean doBoolean(boolean value) {
        return false;
    }

    @Specialization
    protected static boolean doNumber(Number number) {
        return false;
    }

    @Specialization
    protected static boolean doSymbol(Symbol symbol) {
        return false;
    }

    @Specialization
    protected static boolean doBigInt(BigInt bigInt) {
        return false;
    }

    @Specialization(guards={"isForeignObject(obj)"}, limit="InteropLibraryLimit")
    protected static boolean doTruffleObject(Object obj, @CachedLibrary(value="obj") InteropLibrary interop) {
        return interop.isInstantiable(obj);
    }

    public static IsConstructorNode create() {
        return IsConstructorNodeGen.create();
    }
}

