/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb.client;

import java.io.Closeable;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyDataSink;
import org.xlightweb.FutureResponseHandler;
import org.xlightweb.HttpResponse;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IFutureResponse;
import org.xlightweb.IHttpConnection;
import org.xlightweb.IHttpConnectionHandler;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpMessage;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHandler;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.IHttpSession;
import org.xlightweb.IHttpSocketTimeoutHandler;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.ResponseHandlerInfo;
import org.xlightweb.client.HttpClient;
import org.xlightweb.client.IHttpClientEndpoint;
import org.xsocket.DataConverter;
import org.xsocket.Execution;
import org.xsocket.IDestroyable;
import org.xsocket.SerializedTaskQueue;
import org.xsocket.connection.IConnection;
import org.xsocket.connection.INonBlockingConnection;
import org.xsocket.connection.NonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpClientConnection
extends AbstractHttpConnection
implements IHttpClientEndpoint {
    private static final Logger LOG = Logger.getLogger(HttpClientConnection.class.getName());
    private static String implementationVersion;
    private boolean isAutocloseAfterResponse = false;
    private final AtomicBoolean isDisconnected = new AtomicBoolean(false);
    private static final Long DEFAULT_RESPONSE_TIMEOUT_SEC;
    private static final long MIN_WATCHDOG_PERIOD_MILLIS = 30000L;
    private long responseTimeoutMillis = DEFAULT_RESPONSE_TIMEOUT_SEC;
    private WatchDogTask watchDogTask;
    private final List<MessageHandler> bodyReceivingResponseHandlers = Collections.synchronizedList(new ArrayList());
    private final ArrayList<MessageHandler> handlersWaitingForResponseHeader = new ArrayList();
    private HttpClient.TransactionMonitor transactionMonitor;

    public HttpClientConnection(String host, int port) throws IOException, ConnectException {
        this(HttpClientConnection.newNonBlockingConnection(new InetSocketAddress(host, port)), null);
    }

    public HttpClientConnection(InetSocketAddress address) throws IOException, ConnectException {
        this(HttpClientConnection.newNonBlockingConnection(address), null);
    }

    private static INonBlockingConnection newNonBlockingConnection(InetSocketAddress address) throws ConnectException {
        try {
            return new NonBlockingConnection(address);
        }
        catch (IOException ioe) {
            throw new ConnectException(ioe.toString());
        }
    }

    public HttpClientConnection(INonBlockingConnection connection) throws IOException {
        this(connection, null);
        this.init();
    }

    public HttpClientConnection(String host, int port, IHttpConnectionHandler connectionHandler) throws IOException, ConnectException {
        this(HttpClientConnection.newNonBlockingConnection(new InetSocketAddress(host, port)), connectionHandler);
    }

    private HttpClientConnection(INonBlockingConnection connection, IHttpConnectionHandler connectionHandler) throws IOException {
        super(connection, true);
        if (connectionHandler != null) {
            this.addConnectionHandler(connectionHandler);
        }
        this.init();
    }

    void setTransactionMonitor(HttpClient.TransactionMonitor transactionMonitor) {
        this.transactionMonitor = transactionMonitor;
    }

    @Override
    protected void onIdleTimeout() throws IOException {
        for (MessageHandler messageHandler : this.getHandlersWaitingForResponseCopy()) {
            messageHandler.onException(new SocketTimeoutException("idle timeout " + DataConverter.toFormatedDuration((long)this.getIdleTimeoutMillis()) + " reached"));
        }
        this.handlersWaitingForResponseHeader.clear();
        super.onIdleTimeout();
    }

    @Override
    protected void onConnectionTimeout() throws IOException {
        for (MessageHandler messageHandler : this.getHandlersWaitingForResponseCopy()) {
            messageHandler.onException(new SocketTimeoutException("connection timeout " + DataConverter.toFormatedDuration((long)this.getConnectionTimeoutMillis()) + " reached"));
        }
        this.handlersWaitingForResponseHeader.clear();
        super.onConnectionTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MessageHandler> getHandlersWaitingForResponseCopy() {
        ArrayList<MessageHandler> arrayList = this.handlersWaitingForResponseHeader;
        synchronized (arrayList) {
            return (List)this.handlersWaitingForResponseHeader.clone();
        }
    }

    @Override
    protected void onDisconnect() {
        if (!this.isDisconnected.getAndSet(true)) {
            while (!this.bodyReceivingResponseHandlers.isEmpty()) {
                this.bodyReceivingResponseHandlers.remove(0).onException(new ClosedChannelException());
            }
            for (MessageHandler messageHandler : this.getHandlersWaitingForResponseCopy()) {
                ExtendedClosedChannelException cce = new ExtendedClosedChannelException("channel " + this.getId() + " is closed (by peer?) while receiving response data " + "(countMessagesSent=" + this.getCountMessagesSent() + ", countMessagesReceived=" + this.getCountMessagesReceived() + ", countSendBytes=" + this.getCountSendBytes() + ", countReceivedBytes=" + this.getCountReceivedBytes() + ")");
                System.out.println(this.getUnderlyingTcpConnection());
                messageHandler.onException(cce);
            }
            this.handlersWaitingForResponseHeader.clear();
            this.transactionMonitor = null;
            if (this.watchDogTask != null) {
                this.watchDogTask.close();
            }
            this.watchDogTask = null;
            super.onDisconnect();
        }
    }

    protected static String generateErrorMessageHtml(int errorCode, String msg, String id) {
        return AbstractHttpConnection.generateErrorMessageHtml(errorCode, msg, id);
    }

    static String getBodytype(NonBlockingBodyDataSource body) {
        return AbstractHttpConnection.getBodyType(body);
    }

    protected static void schedule(TimerTask task, long delay, long period) {
        AbstractHttpConnection.schedule(task, delay, period);
    }

    @Override
    public IHttpResponse call(IHttpRequest request) throws IOException, ConnectException, SocketTimeoutException {
        FutureResponseHandler responseHandler = new FutureResponseHandler();
        this.send(request, this.wrapResponsehandler(responseHandler));
        try {
            return responseHandler.getResponse();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie.toString());
        }
    }

    void setAutocloseAfterResponse(boolean isAutocloseAfterResponse) {
        this.isAutocloseAfterResponse = isAutocloseAfterResponse;
    }

    public boolean isServerSide() {
        return false;
    }

    @Override
    public void setResponseTimeoutMillis(long responseTimeoutMillis) {
        if (this.responseTimeoutMillis != responseTimeoutMillis) {
            this.responseTimeoutMillis = responseTimeoutMillis;
            if (responseTimeoutMillis == Long.MAX_VALUE) {
                this.terminateWatchDogTask();
            } else {
                long watchdogPeriod = 100L;
                if (responseTimeoutMillis > 1000L) {
                    watchdogPeriod = responseTimeoutMillis / 10L;
                }
                if (watchdogPeriod > 30000L) {
                    watchdogPeriod = 30000L;
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + this.getId() + "] response timeout to " + DataConverter.toFormatedDuration((long)responseTimeoutMillis) + ". Updating wachdog tas to check period " + watchdogPeriod + " millis");
                }
                this.updateWatchDog(watchdogPeriod);
            }
        }
    }

    private synchronized void updateWatchDog(long watchDogPeriod) {
        this.terminateWatchDogTask();
        this.watchDogTask = new WatchDogTask(this);
        HttpClientConnection.schedule(this.watchDogTask, watchDogPeriod, watchDogPeriod);
    }

    private synchronized void terminateWatchDogTask() {
        if (this.watchDogTask != null) {
            this.watchDogTask.close();
        }
    }

    @Override
    public long getResponseTimeoutMillis() {
        return this.responseTimeoutMillis;
    }

    private void checkTimeouts() {
        try {
            long currentMillis = System.currentTimeMillis();
            for (Object hdl : this.handlersWaitingForResponseHeader.toArray()) {
                boolean isTimeoutReached = ((MessageHandler)hdl).isResponseTimeoutReached(currentMillis);
                if (!isTimeoutReached) continue;
                if (this.handlersWaitingForResponseHeader.remove(hdl)) {
                    this.onResponseTimeout((MessageHandler)hdl);
                }
                this.destroy();
            }
        }
        catch (Exception e) {
            LOG.warning("exception occured by checking timouts. Reason: " + e.toString());
        }
    }

    private void onResponseTimeout(MessageHandler internalResponseHandler) {
        SocketTimeoutException ste = new SocketTimeoutException("response timeout " + DataConverter.toFormatedDuration((long)internalResponseHandler.getTimeout()) + " reached");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(ste.getMessage());
        }
        this.performResponseTimeoutHandler(internalResponseHandler.getAppHandler(), ste);
    }

    private void performResponseTimeoutHandler(final IHttpResponseHandler handler, final SocketTimeoutException ste) {
        final ResponseHandlerInfo responseHandlerInfo = AbstractHttpConnection.getResponseHandlerInfo(handler);
        Runnable responseTimeoutHandlerCaller = new Runnable(){

            public void run() {
                try {
                    if (responseHandlerInfo.isSocketTimeoutHandler()) {
                        IHttpSocketTimeoutHandler hdl = (IHttpSocketTimeoutHandler)((Object)handler);
                        hdl.onException(ste);
                    } else {
                        handler.onException(ste);
                    }
                }
                catch (Exception e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("[" + HttpClientConnection.this.getId() + "] error occured by calling on request " + handler + " " + e.toString());
                    }
                    throw new RuntimeException(e);
                }
                finally {
                    HttpClientConnection.this.destroy();
                }
            }
        };
        if (responseHandlerInfo.isSocketTimeoutHandlerMultithreaded()) {
            this.getExecutor().processMultithreaded(responseTimeoutHandlerCaller);
        } else {
            this.getExecutor().processNonthreaded(responseTimeoutHandlerCaller);
        }
    }

    @Override
    public BodyDataSink send(IHttpRequestHeader requestHeader, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        if (this.isOpen()) {
            if (responseHandler == null) {
                responseHandler = new DoNothingResponseHandler();
            }
            if (requestHeader.getContentLength() != -1) {
                requestHeader.removeHeader("Content-Length");
            }
            if (requestHeader.getTransferEncoding() == null) {
                requestHeader.setHeader("Transfer-Encoding", "chunked");
            }
            this.enhanceHeader(requestHeader);
            try {
                return this.sendInternal(requestHeader, responseHandler);
            }
            catch (IOException ioe) {
                String msg = "can not send request \r\n " + requestHeader.toString() + "\r\n\r\nhttpConnection:\r\n" + this.toString() + "\r\n\r\nreason:\r\n" + ioe.toString();
                this.destroy();
                throw new IOException(msg);
            }
        }
        throw new ClosedChannelException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BodyDataSink sendInternal(IHttpRequestHeader requestHeader, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        HttpClientConnection.prepareResponseHandler(responseHandler, this);
        ArrayList<MessageHandler> arrayList = this.handlersWaitingForResponseHeader;
        synchronized (arrayList) {
            this.handlersWaitingForResponseHeader.add(new MessageHandler(responseHandler, requestHeader, this.responseTimeoutMillis));
        }
        BodyDataSink bodyDataSink = this.writeMessage(requestHeader, false);
        return bodyDataSink;
    }

    @Override
    public BodyDataSink send(IHttpRequestHeader requestHeader, int contentLength, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        if (this.isOpen()) {
            if (responseHandler == null) {
                responseHandler = new DoNothingResponseHandler();
            }
            if (requestHeader.getContentLength() != -1) {
                requestHeader.removeHeader("Content-Length");
            }
            if (requestHeader.getTransferEncoding() == null) {
                requestHeader.setHeader("Transfer-Encoding", "chunked");
            }
            this.enhanceHeader(requestHeader);
            try {
                if (requestHeader.getTransferEncoding() != null && requestHeader.getTransferEncoding().equalsIgnoreCase("chunked")) {
                    requestHeader.removeHeader("Transfer-Encoding");
                }
                if (requestHeader.getContentLength() == -1) {
                    requestHeader.setContentLength(contentLength);
                }
                return this.sendInternal(requestHeader, contentLength, responseHandler);
            }
            catch (IOException ioe) {
                String msg = "can not send request \r\n " + requestHeader.toString() + "\r\n\r\nhttpConnection:\r\n" + this.toString() + "\r\n\r\nreason:\r\n" + ioe.toString();
                this.destroy();
                throw new IOException(msg);
            }
        }
        throw new ClosedChannelException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BodyDataSink sendInternal(IHttpRequestHeader requestHeader, int contentLength, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        HttpClientConnection.prepareResponseHandler(responseHandler, this);
        ArrayList<MessageHandler> arrayList = this.handlersWaitingForResponseHeader;
        synchronized (arrayList) {
            this.handlersWaitingForResponseHeader.add(new MessageHandler(responseHandler, requestHeader, this.responseTimeoutMillis));
        }
        BodyDataSink bodyDataSink = this.writeMessage(requestHeader, false, contentLength);
        return bodyDataSink;
    }

    @Override
    public void send(IHttpRequest request, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        if (this.isOpen()) {
            if (responseHandler == null) {
                responseHandler = new DoNothingResponseHandler();
            }
            IHttpRequestHeader requestHeader = request.getRequestHeader();
            this.enhanceHeader(requestHeader);
            try {
                this.sendInternal(request, responseHandler);
            }
            catch (IOException ioe) {
                String msg = "can not send request \r\n " + request.toString() + "\r\n\r\nhttpConnection:\r\n" + this.toString() + "\r\n\r\nreason:\r\n" + ioe.toString();
                this.destroy();
                throw new IOException(msg);
            }
        } else {
            throw new ClosedChannelException();
        }
    }

    @Override
    public IFutureResponse send(IHttpRequest request) throws IOException, ConnectException {
        FutureResponseHandler responseHandler = new FutureResponseHandler();
        this.send(request, (IHttpResponseHandler)responseHandler);
        return responseHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendInternal(IHttpRequest request, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
        HttpClientConnection.prepareResponseHandler(responseHandler, this);
        ArrayList<MessageHandler> arrayList = this.handlersWaitingForResponseHeader;
        synchronized (arrayList) {
            this.handlersWaitingForResponseHeader.add(new MessageHandler(responseHandler, request.getRequestHeader(), this.responseTimeoutMillis));
        }
        if (request.getNonBlockingBody() == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + this.getId() + "] sending (bodyless): " + request.getRequestHeader());
            }
            BodyDataSink bodyDataSink = this.writeMessage(request.getRequestHeader(), false, 0);
            bodyDataSink.setFlushmode(IConnection.FlushMode.ASYNC);
            bodyDataSink.close();
        } else {
            if (request.getNonBlockingBody().getDataHandler() != null) {
                throw new IOException("a body handler is already assigned to the message body. sending such messages is not supported (remove data handler)");
            }
            this.writeMessage(request, false);
        }
    }

    private static void prepareResponseHandler(IHttpResponseHandler responseHandler, IDestroyable destroyable) {
        if (responseHandler instanceof FutureResponseHandler) {
            HttpClientConnection.setUnderlyingResource((FutureResponseHandler)responseHandler, destroyable);
        }
    }

    private IHttpResponseHandler wrapResponsehandler(IHttpResponseHandler responseHandler) {
        if (AbstractHttpConnection.getResponseHandlerInfo(responseHandler).isResponseHandlerInvokeOnMessageReceived()) {
            return new InvokeOnMessageWrapper(responseHandler, this);
        }
        return responseHandler;
    }

    private void enhanceHeader(IHttpRequestHeader header) throws IOException {
        String userAgent;
        String host = header.getHost();
        if (host == null) {
            header.setHost(this.getRemoteHostInfo());
        }
        if ((userAgent = header.getUserAgent()) == null) {
            header.setUserAgent(HttpClientConnection.getImplementationVersion());
        }
    }

    private static String getImplementationVersion() {
        if (implementationVersion == null) {
            implementationVersion = "xLightweb/" + HttpUtils.getImplementationVersion();
        }
        return implementationVersion;
    }

    private String getRemoteHostInfo() throws IOException {
        InetAddress remoteAddress = this.getRemoteAddress();
        if (remoteAddress == null) {
            return "";
        }
        int remotePort = this.getRemotePort();
        return remoteAddress.getHostName() + ":" + remotePort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractHttpConnection.IMessageHandler getMessageHandler() {
        ArrayList<MessageHandler> arrayList = this.handlersWaitingForResponseHeader;
        synchronized (arrayList) {
            if (this.handlersWaitingForResponseHeader.isEmpty()) {
                return null;
            }
            return this.handlersWaitingForResponseHeader.remove(0);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getId() + " " + this.getUnderlyingTcpConnection().getLocalAddress() + ":" + this.getUnderlyingTcpConnection().getLocalPort() + " -> " + this.getUnderlyingTcpConnection().getRemoteAddress() + ":" + this.getUnderlyingTcpConnection().getRemotePort());
        if (!this.getUnderlyingTcpConnection().isOpen()) {
            sb.append("  (closed)");
        }
        return sb.toString();
    }

    static IBodySinkPair newBodySinkPair(AbstractHttpConnection connection, AbstractHttpConnection.IMultimodeExecutor executor, String encoding) throws IOException {
        final AbstractHttpConnection.DataSourceSinkPair pair = AbstractHttpConnection.newBodyDataSourceSinkPair(null, executor, encoding);
        return new IBodySinkPair(){

            public BodyDataSink getBodyDataSink() {
                return pair.getBodyDataSink();
            }

            public NonBlockingBodyDataSource getBodyDataSource() {
                return pair.getBodyDataSource();
            }
        };
    }

    static {
        DEFAULT_RESPONSE_TIMEOUT_SEC = Long.MAX_VALUE;
    }

    @Execution(value=0)
    static final class DoNothingResponseHandler
    implements IHttpResponseHandler {
        DoNothingResponseHandler() {
        }

        public void onResponse(IHttpResponse response) throws IOException {
        }

        public void onException(IOException ioe) throws IOException {
        }
    }

    @Execution(value=0)
    private static final class ForwardingResponseHandler
    implements IHttpResponseHandler {
        private IHttpExchange exchange = null;

        public ForwardingResponseHandler(IHttpExchange exchange) {
            this.exchange = exchange;
        }

        public void onResponse(IHttpResponse response) throws IOException {
            this.exchange.send(response);
        }

        public void onException(IOException ioe) throws IOException {
            this.exchange.sendError(ioe);
        }
    }

    private static final class MultimodeExecutor
    implements AbstractHttpConnection.IMultimodeExecutor {
        private final SerializedTaskQueue taskQueue = new SerializedTaskQueue();
        private Executor workerpool = null;

        public MultimodeExecutor(Executor workerpool) {
            this.workerpool = workerpool;
        }

        public void processMultithreaded(Runnable task) {
            this.taskQueue.performMultiThreaded(task, this.workerpool);
        }

        public void processNonthreaded(Runnable task) {
            this.taskQueue.performNonThreaded(task, this.workerpool);
        }
    }

    static final class ClientExchange
    implements IHttpExchange {
        private boolean isResponseCommitted = false;
        private HttpClientConnection con = null;
        private IHttpRequest request = null;
        private String targetURL = null;
        private IHttpResponseHandler responseHandler = null;
        private ResponseHandlerInfo responseHandlerInfo = null;
        private HttpClient httpClient = null;
        private AbstractHttpConnection.IMultimodeExecutor executor = null;

        public ClientExchange(HttpClient httpClient, Executor workerpool) {
            this.httpClient = httpClient;
            this.executor = new MultimodeExecutor(workerpool);
        }

        void init(IHttpRequest request, IHttpResponseHandler responseHandler) {
            this.request = request;
            this.responseHandler = responseHandler;
            this.responseHandlerInfo = HttpClientConnection.getResponseHandlerInfo(responseHandler);
            HttpClientConnection.prepareResponseHandler(responseHandler, this);
            this.targetURL = request.getRequestUrl().toString();
            if (this.targetURL.indexOf("?") != -1) {
                this.targetURL = this.targetURL.substring(0, this.targetURL.indexOf("?"));
            }
        }

        AbstractHttpConnection.IMultimodeExecutor getExecutor() {
            return this.executor;
        }

        public IHttpRequest getRequest() {
            return this.request;
        }

        public IHttpSession getSession(boolean create) {
            return this.httpClient.getSessionManager().getSession(this.httpClient, this.request.getRemoteHost(), this.request.getRequestURI(), create);
        }

        public String encodeURL(String url) {
            return url;
        }

        public void forward(IHttpRequest request) throws IOException, ConnectException {
            this.forward(request, (IHttpResponseHandler)new ForwardingResponseHandler(this));
        }

        public void forward(IHttpRequest request, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
            if (responseHandler == null) {
                responseHandler = new DoNothingResponseHandler();
            }
            URL targetURL = request.getRequestUrl();
            this.con = this.httpClient.getConnection(request.isSecure(), targetURL.getHost(), targetURL.getPort(), targetURL.getProtocol(), null);
            this.con.send(request, responseHandler);
        }

        public BodyDataSink forward(IHttpRequestHeader requestHeader) throws IOException, ConnectException, IllegalStateException {
            return this.forward(requestHeader, (IHttpResponseHandler)new ForwardingResponseHandler(this));
        }

        public BodyDataSink forward(IHttpRequestHeader requestHeader, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
            if (responseHandler == null) {
                responseHandler = new DoNothingResponseHandler();
            }
            if (requestHeader.getContentLength() != -1) {
                requestHeader.removeHeader("Content-Length");
            }
            if (requestHeader.getMethod().equalsIgnoreCase("GET") || requestHeader.getMethod().equalsIgnoreCase("HEAD")) {
                throw new IOException(requestHeader.getMethod() + " is a bodyless request");
            }
            if (requestHeader.getTransferEncoding() == null) {
                requestHeader.setHeader("Transfer-Encoding", "chunked");
            }
            URL targetURL = requestHeader.getRequestUrl();
            this.con = this.httpClient.getConnection(requestHeader.isSecure(), targetURL.getHost(), targetURL.getPort(), targetURL.getProtocol(), null);
            return this.con.send(requestHeader, responseHandler);
        }

        public BodyDataSink forward(IHttpRequestHeader requestHeader, int contentLength) throws IOException, ConnectException, IllegalStateException {
            return this.forward(requestHeader, contentLength, new ForwardingResponseHandler(this));
        }

        public BodyDataSink forward(IHttpRequestHeader requestHeader, int contentLength, IHttpResponseHandler responseHandler) throws IOException, ConnectException {
            if (responseHandler == null) {
                responseHandler = new DoNothingResponseHandler();
            }
            if (requestHeader.getTransferEncoding() != null && requestHeader.getTransferEncoding().equalsIgnoreCase("chunked")) {
                requestHeader.removeHeader("Transfer-Encoding");
            }
            if (requestHeader.getMethod().equalsIgnoreCase("GET") || requestHeader.getMethod().equalsIgnoreCase("HEAD")) {
                throw new IOException(requestHeader.getMethod() + " is a bodyless request");
            }
            if (requestHeader.getContentLength() == -1) {
                requestHeader.setContentLength(contentLength);
            }
            URL targetURL = requestHeader.getRequestUrl();
            this.con = this.httpClient.getConnection(requestHeader.isSecure(), targetURL.getHost(), targetURL.getPort(), targetURL.getProtocol(), null);
            return this.con.send(requestHeader, contentLength, responseHandler);
        }

        public BodyDataSink send(IHttpResponseHeader header) throws IOException, IllegalStateException {
            if (header.getContentLength() != -1) {
                header.removeHeader("Content-Length");
            }
            if (header.getTransferEncoding() == null) {
                header.setHeader("Transfer-Encoding", "chunked");
            }
            AbstractHttpConnection.DataSourceSinkPair pair = HttpClientConnection.newBodyDataSourceSinkPair((AbstractHttpConnection)this.getConnection(), this.executor, header.getCharacterEncoding());
            this.send(new HttpResponse(header, pair.getBodyDataSource()));
            return pair.getBodyDataSink();
        }

        public BodyDataSink send(IHttpResponseHeader header, int contentLength) throws IOException, IllegalStateException {
            if (header.getTransferEncoding() != null && header.getTransferEncoding().equalsIgnoreCase("chunked")) {
                header.removeHeader("Transfer-Encoding");
            }
            if (header.getContentLength() == -1) {
                header.setContentLength(contentLength);
            }
            AbstractHttpConnection.DataSourceSinkPair pair = HttpClientConnection.newBodyDataSourceSinkPair((AbstractHttpConnection)this.getConnection(), this.executor, header.getCharacterEncoding());
            this.send(new HttpResponse(header, pair.getBodyDataSource()));
            return pair.getBodyDataSink();
        }

        public void send(final IHttpResponse response) throws IOException, IllegalStateException {
            if (this.isResponseCommitted) {
                throw new IllegalStateException("response is already committed");
            }
            this.isResponseCommitted = true;
            if (this.responseHandler == null) {
                LOG.warning("response will not been send, because no response handler is assigned");
                return;
            }
            if (this.responseHandlerInfo.isResponseHandlerInvokeOnMessageReceived()) {
                IBodyCompleteListener completeListener = new IBodyCompleteListener(){

                    @Execution(value=0)
                    public void onComplete() throws IOException {
                        ClientExchange.this.performOnResponse(response);
                    }
                };
                response.getNonBlockingBody().addCompleteListener(completeListener);
            } else {
                this.performOnResponse(response);
            }
        }

        private void performOnResponse(final IHttpResponse response) throws IOException {
            Runnable task = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            ClientExchange.this.responseHandler.onResponse(response);
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block2;
                            LOG.fine("error occured by performing on response on " + ClientExchange.this.responseHandler);
                        }
                    }
                }
            };
            if (this.responseHandlerInfo.isResponseHandlerMultithreaded()) {
                this.executor.processMultithreaded(task);
            } else {
                this.executor.processNonthreaded(task);
            }
        }

        public IHttpConnection getConnection() {
            return this.con;
        }

        public void destroy() {
            if (this.con != null) {
                this.con.destroy();
            }
        }

        public void sendError(int errorCode) throws IllegalStateException {
            this.sendError(errorCode, HttpUtils.getReason(errorCode));
        }

        public void sendError(int errorCode, String msg) throws IllegalStateException {
            try {
                String id = "";
                IHttpConnection connection = this.getConnection();
                if (connection != null) {
                    id = connection.getId();
                }
                this.send(new HttpResponse(errorCode, "text/html", HttpClientConnection.generateErrorMessageHtml(errorCode, msg, id)));
            }
            catch (IOException ioe) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("could not send error message " + errorCode + " reason " + ioe.toString());
                }
                this.destroy();
            }
        }

        public void sendError(final Exception e) throws IllegalStateException {
            if (this.isResponseCommitted) {
                throw new IllegalStateException("response is already committed");
            }
            this.isResponseCommitted = true;
            if (this.responseHandlerInfo.isSocketTimeoutHandler() && e instanceof SocketTimeoutException) {
                Runnable task = new Runnable(){

                    public void run() {
                        ((IHttpSocketTimeoutHandler)((Object)ClientExchange.this.responseHandler)).onException((SocketTimeoutException)e);
                    }
                };
                if (this.responseHandlerInfo.isSocketTimeoutHandlerMultithreaded()) {
                    this.executor.processMultithreaded(task);
                } else {
                    this.executor.processNonthreaded(task);
                }
            } else if (e instanceof IOException) {
                Runnable task = new Runnable(){

                    public void run() {
                        block2: {
                            try {
                                ClientExchange.this.responseHandler.onException((IOException)e);
                            }
                            catch (IOException ioe) {
                                if (!LOG.isLoggable(Level.FINE)) break block2;
                                LOG.fine("Error occured by performing onException " + ClientExchange.this.responseHandler + ". reason: " + ioe.toString());
                            }
                        }
                    }
                };
                if (this.responseHandlerInfo.isResponseExeptionHandlerMultithreaded()) {
                    this.executor.processMultithreaded(task);
                } else {
                    this.executor.processNonthreaded(task);
                }
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured. sendig 500. Error: " + DataConverter.toString((Throwable)e));
                }
                if (HttpUtils.isShowDetailedError()) {
                    this.sendError(500, DataConverter.toString((Throwable)e));
                } else {
                    this.sendError(500);
                }
            }
        }
    }

    static interface IBodySinkPair {
        public BodyDataSink getBodyDataSink();

        public NonBlockingBodyDataSource getBodyDataSource();
    }

    static final class InvokeOnMessageWrapper
    implements IHttpResponseHandler {
        private static final Logger LOG = Logger.getLogger(InvokeOnMessageWrapper.class.getName());
        private IHttpResponseHandler delegee = null;
        private ResponseHandlerInfo delegeeInfo = null;
        private HttpClientConnection connection = null;

        public InvokeOnMessageWrapper(IHttpResponseHandler delegee, HttpClientConnection connection) {
            this.delegee = delegee;
            this.delegeeInfo = HttpClientConnection.getResponseHandlerInfo(delegee);
            this.connection = connection;
        }

        @Execution(value=0)
        public void onResponse(final IHttpResponse response) throws IOException {
            final Runnable task = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            InvokeOnMessageWrapper.this.delegee.onResponse(response);
                        }
                        catch (IOException ioe) {
                            if (!LOG.isLoggable(Level.FINE)) break block2;
                            LOG.fine("Error occured by calling onResponse of " + InvokeOnMessageWrapper.this.delegee + " " + ioe.toString());
                        }
                    }
                }
            };
            if (response.hasBody()) {
                IBodyCompleteListener cl = new IBodyCompleteListener(){

                    public void onComplete() throws IOException {
                        if (InvokeOnMessageWrapper.this.delegeeInfo.isResponseHandlerMultithreaded()) {
                            InvokeOnMessageWrapper.this.connection.getExecutor().processMultithreaded(task);
                        } else {
                            InvokeOnMessageWrapper.this.connection.getExecutor().processNonthreaded(task);
                        }
                    }
                };
                response.getNonBlockingBody().addCompleteListener(cl);
            } else if (this.delegeeInfo.isResponseHandlerMultithreaded()) {
                this.connection.getExecutor().processMultithreaded(task);
            } else {
                this.connection.getExecutor().processNonthreaded(task);
            }
        }

        @Execution(value=0)
        public void onException(final IOException ioe) {
            Runnable task = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            InvokeOnMessageWrapper.this.delegee.onException(ioe);
                        }
                        catch (IOException ioe2) {
                            if (!LOG.isLoggable(Level.FINE)) break block2;
                            LOG.fine("Error occured by performing onException " + InvokeOnMessageWrapper.this.delegee + ". reason: " + ioe2.toString());
                        }
                    }
                }
            };
            if (this.delegeeInfo.isResponseExeptionHandlerMultithreaded()) {
                this.connection.getExecutor().processMultithreaded(task);
            } else {
                this.connection.getExecutor().processNonthreaded(task);
            }
        }
    }

    private static final class WatchDogTask
    extends TimerTask
    implements Closeable {
        private WeakReference<HttpClientConnection> httpClientConnectionRef;

        public WatchDogTask(HttpClientConnection httpClientConnection) {
            this.httpClientConnectionRef = new WeakReference<HttpClientConnection>(httpClientConnection);
        }

        public void run() {
            WeakReference<HttpClientConnection> ref = this.httpClientConnectionRef;
            if (ref != null) {
                HttpClientConnection httpClientConnection = (HttpClientConnection)ref.get();
                if (httpClientConnection == null) {
                    this.close();
                } else {
                    httpClientConnection.checkTimeouts();
                }
            }
        }

        public void close() {
            this.cancel();
            this.httpClientConnectionRef = null;
        }
    }

    private static final class OnIOExceptionCaller
    implements Runnable {
        private IOException ioe = null;
        private IHttpResponseHandler hdl = null;

        public OnIOExceptionCaller(IOException ioe, IHttpResponseHandler hdl) {
            this.ioe = ioe;
            this.hdl = hdl;
        }

        public void run() {
            block2: {
                try {
                    this.hdl.onException(this.ioe);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("Error occured by performing onException " + this.hdl + ". reason: " + ioe.toString());
                }
            }
        }
    }

    private static final class OnSocketTimeoutExceptionCaller
    implements Runnable {
        private SocketTimeoutException ste = null;
        private IHttpSocketTimeoutHandler hdl = null;

        public OnSocketTimeoutExceptionCaller(SocketTimeoutException ste, IHttpSocketTimeoutHandler hdl) {
            this.ste = ste;
            this.hdl = hdl;
        }

        public void run() {
            this.hdl.onException(this.ste);
        }
    }

    final class MessageHandler
    implements AbstractHttpConnection.IMessageHandler,
    Runnable {
        private final AtomicBoolean isCommitted = new AtomicBoolean(false);
        private IHttpResponseHandler delegee = null;
        private ResponseHandlerInfo delegeeInfo = null;
        private IHttpRequestHeader requestHeader = null;
        private IHttpResponse response = null;
        private long timeout = Long.MAX_VALUE;
        private long timeoutDate = Long.MAX_VALUE;

        public MessageHandler(IHttpResponseHandler delegee, IHttpRequestHeader requestHeader, long responseTimeout) {
            this.delegee = delegee;
            this.delegeeInfo = HttpClientConnection.getResponseHandlerInfo(delegee);
            this.requestHeader = requestHeader;
            this.timeout = responseTimeout;
            if (responseTimeout != Long.MAX_VALUE && (double)responseTimeout < 8.301034833169298E18) {
                this.timeoutDate = this.timeout + System.currentTimeMillis();
            }
        }

        IHttpResponseHandler getAppHandler() {
            return this.delegee;
        }

        boolean isResponseTimeoutReached(long currentMillis) {
            if (this.isCommitted.get()) {
                return false;
            }
            return currentMillis > this.timeoutDate;
        }

        long getTimeout() {
            return this.timeout;
        }

        public boolean isBodylessMessageExpected() {
            return this.requestHeader.getMethod().equals("HEAD") || this.requestHeader.getMethod().equals("OPTIONS") || this.requestHeader.getMethod().equals("CONNECT");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(IHttpMessage message) throws IOException {
            Object body;
            this.response = (IHttpResponse)message;
            HttpClientConnection.this.incCountMessageReceived();
            if (HttpClientConnection.this.transactionMonitor != null) {
                HttpClientConnection.this.transactionMonitor.register(HttpClientConnection.this, this.requestHeader, this.response);
            }
            if (LOG.isLoggable(Level.FINE)) {
                if (this.response.getNonBlockingBody() == null) {
                    LOG.fine("[" + HttpClientConnection.this.getId() + "] bodyless response received from " + HttpClientConnection.this.getRemoteAddress() + ":" + HttpClientConnection.this.getRemotePort() + " (" + HttpClientConnection.this.getCountMessagesReceived() + ". request) " + this.response.getMessageHeader().toString());
                } else {
                    body = "";
                    String contentType = this.response.getContentType();
                    if (contentType != null && contentType.startsWith("application/x-www-form-urlencode")) {
                        body = this.response.getNonBlockingBody().toString() + "\n";
                    }
                    LOG.fine("[" + HttpClientConnection.this.getId() + "]response received from " + HttpClientConnection.this.getRemoteAddress() + ":" + HttpClientConnection.this.getRemotePort() + " (" + HttpClientConnection.this.getCountMessagesReceived() + ". request) " + this.response.getMessageHeader().toString() + (String)body);
                }
            }
            this.handleLifeCycleHeaders(this.response);
            if (this.response.getStatus() == 100) {
                body = HttpClientConnection.this.handlersWaitingForResponseHeader;
                synchronized (body) {
                    ArrayList hdls = new ArrayList();
                    HttpClientConnection.this.handlersWaitingForResponseHeader.removeAll(hdls);
                    HttpClientConnection.this.handlersWaitingForResponseHeader.add(this);
                    HttpClientConnection.this.handlersWaitingForResponseHeader.addAll(hdls);
                }
                HttpClientConnection.this.setPersistent(true);
                return;
            }
            if (this.response.getStatus() >= 500 && this.response.getStatus() < 600) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("got return code 5xx. Set connection " + HttpClientConnection.this.getId() + " to non persistent");
                }
                HttpClientConnection.this.setPersistent(false);
            }
            if (!HttpClientConnection.this.isPersistent()) {
                if (this.response.hasBody()) {
                    HttpClientConnection.this.setDestroyConnectionAfterReceived(this.response.getNonBlockingBody(), true);
                } else {
                    HttpClientConnection.this.destroy();
                }
            } else if (HttpClientConnection.this.isAutocloseAfterResponse) {
                if (this.response.hasBody()) {
                    HttpClientConnection.this.setCloseConnectionAfterReceived(this.response.getNonBlockingBody(), true);
                } else {
                    HttpClientConnection.this.closeSilence();
                }
            }
            if (this.response.hasBody() && this.delegeeInfo.isResponseHandlerInvokeOnMessageReceived()) {
                HttpClientConnection.this.bodyReceivingResponseHandlers.add(this);
                IBodyCompleteListener cl = new IBodyCompleteListener(){

                    @Execution(value=0)
                    public void onComplete() throws IOException {
                        HttpClientConnection.this.bodyReceivingResponseHandlers.remove(this);
                        MessageHandler.this.isCommitted.set(true);
                        if (MessageHandler.this.delegeeInfo.isResponseHandlerMultithreaded()) {
                            HttpClientConnection.this.getExecutor().processMultithreaded(MessageHandler.this);
                        } else {
                            HttpClientConnection.this.getExecutor().processNonthreaded(MessageHandler.this);
                        }
                    }
                };
                this.response.getNonBlockingBody().addCompleteListener(cl);
            } else {
                this.isCommitted.set(true);
                if (this.delegeeInfo.isResponseHandlerMultithreaded()) {
                    HttpClientConnection.this.getExecutor().processMultithreaded(this);
                } else {
                    HttpClientConnection.this.getExecutor().processNonthreaded(this);
                }
            }
        }

        public void run() {
            block2: {
                try {
                    this.delegee.onResponse(this.response);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("Error occured by calling onResponse of " + this.delegee + " " + ioe.toString());
                }
            }
        }

        private void handleLifeCycleHeaders(IHttpResponse response) throws IOException {
            if (response.getProtocol() != null && response.getProtocol().equals("HTTP/1.1")) {
                HttpClientConnection.this.setPersistent(HttpClientConnection.this.getPersistent());
            } else if (this.requestHeader.getMethod().equals("CONNECT")) {
                HttpClientConnection.this.setPersistent(HttpClientConnection.this.getPersistent());
            }
            this.handleConnectionHeaders(response.getResponseHeader());
        }

        private void handleConnectionHeaders(IHttpResponseHeader responseHeader) throws IOException {
            String connectionHeader;
            String keepAliveHeader = responseHeader.getKeepAlive();
            if (keepAliveHeader != null) {
                String[] tokens;
                for (String token : tokens = keepAliveHeader.split(",")) {
                    this.handleKeepAlive(token);
                }
            }
            if ((connectionHeader = responseHeader.getConnection()) != null) {
                String[] values;
                for (String value : values = connectionHeader.split(",")) {
                    if (!(value = value.trim()).equalsIgnoreCase("close")) continue;
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("[" + HttpClientConnection.this.getId() + " http client connection received 'connection: close' header. set isPersistent=false");
                    }
                    HttpClientConnection.this.setPersistent(false);
                }
            }
        }

        private void handleKeepAlive(String option) {
            if (option.toUpperCase().startsWith("TIMEOUT=")) {
                int timeoutSec = Integer.parseInt(option.substring("TIMEOUT=".length(), option.length()));
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("response keep alive defines timout. set timeout " + timeoutSec + " sec");
                }
                HttpClientConnection.this.setResponseTimeoutMillis((long)timeoutSec * 1000L);
            } else if (option.toUpperCase().startsWith("MAX=")) {
                int maxTransactions = Integer.parseInt(option.substring("MAX=".length(), option.length()));
                if (maxTransactions == 0) {
                    HttpClientConnection.this.setPersistent(false);
                }
            } else {
                Integer timeoutSec = Integer.parseInt(option);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("response keep alive defines timout. set timeout " + timeoutSec + " sec");
                }
                HttpClientConnection.this.setResponseTimeoutMillis((long)timeoutSec.intValue() * 1000L);
            }
        }

        public void onException(IOException ioe) {
            if (this.isCommitted.get()) {
                return;
            }
            this.isCommitted.set(true);
            if (ioe instanceof SocketTimeoutException && this.delegeeInfo.isSocketTimeoutHandler()) {
                OnSocketTimeoutExceptionCaller task = new OnSocketTimeoutExceptionCaller((SocketTimeoutException)ioe, (IHttpSocketTimeoutHandler)((Object)this.delegee));
                if (this.delegeeInfo.isSocketTimeoutHandlerMultithreaded()) {
                    HttpClientConnection.this.getExecutor().processMultithreaded(task);
                } else {
                    HttpClientConnection.this.getExecutor().processNonthreaded(task);
                }
            } else {
                OnIOExceptionCaller task = new OnIOExceptionCaller(ioe, this.delegee);
                if (this.delegeeInfo.isResponseExeptionHandlerMultithreaded()) {
                    HttpClientConnection.this.getExecutor().processMultithreaded(task);
                } else {
                    HttpClientConnection.this.getExecutor().processNonthreaded(task);
                }
            }
        }
    }

    private static final class ExtendedClosedChannelException
    extends ClosedChannelException {
        private static final long serialVersionUID = 561074260045048337L;
        private final String msg;

        public ExtendedClosedChannelException(String msg) {
            this.msg = msg;
        }

        public String getMessage() {
            return this.msg;
        }
    }
}

