/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.xlightweb.AbstractHttpHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpResponseHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpResponseHeader
extends AbstractHttpHeader
implements IHttpResponseHeader {
    private int statusCode = -1;
    private String reason;
    private boolean isSimpleResponse = false;
    private String server;
    private String date;

    HttpResponseHeader() {
        this.setProtocolSchemeSilence("HTTP");
    }

    public HttpResponseHeader(int statusCode) {
        this(statusCode, null, HttpUtils.getReason(statusCode));
    }

    public HttpResponseHeader(String contentType) {
        this(200, contentType);
    }

    public HttpResponseHeader(int statusCode, String contentType) {
        this(statusCode, contentType, HttpUtils.getReason(statusCode));
    }

    public HttpResponseHeader(int statusCode, String contentType, String reason) {
        this("1.1", statusCode, contentType, reason);
    }

    private HttpResponseHeader(String protocolVersion, int statusCode, String contentType, String reason) {
        this.setProtocolSchemeSilence("HTTP");
        this.setProtocolVersionSilence(protocolVersion);
        this.statusCode = statusCode;
        this.reason = reason;
        if (contentType != null) {
            this.setContentType(contentType);
        }
    }

    void setSimpleResponse(boolean isSimpleResponse) {
        this.isSimpleResponse = isSimpleResponse;
        if (isSimpleResponse) {
            this.setProtocolVersionSilence("0.9");
        }
    }

    public void copyHeaderFrom(HttpResponseHeader otherHeader, String ... upperExcludenames) {
        super.copyHeaderFrom(otherHeader, upperExcludenames);
    }

    @Override
    public int getStatus() {
        return this.statusCode;
    }

    @Override
    public void setStatus(int status) {
        this.statusCode = status;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public void setProtocol(String protocol) {
        int idx = protocol.indexOf("/");
        this.setProtocolSchemeSilence(protocol.substring(0, idx));
        this.setProtocolVersionSilence(protocol.substring(idx + 1, protocol.length()));
    }

    @Override
    public String getDate() {
        return this.getHeader("Date");
    }

    @Override
    public void setDate(String date) {
        this.setHeader("Date", date);
    }

    @Override
    public void setServer(String server) {
        this.server = server;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    protected boolean onHeaderAdded(String headername, String headervalue) {
        if (headername.equalsIgnoreCase("Server")) {
            this.server = headervalue;
            return true;
        }
        if (headername.equalsIgnoreCase("Date")) {
            this.date = headervalue;
            return true;
        }
        return super.onHeaderAdded(headername, headervalue);
    }

    @Override
    protected boolean onHeaderRemoved(String headername) {
        if (headername.equalsIgnoreCase("Server")) {
            this.server = null;
            return true;
        }
        if (headername.equalsIgnoreCase("Date")) {
            this.date = null;
            return true;
        }
        return super.onHeaderRemoved(headername);
    }

    @Override
    public Set<String> getHeaderNameSet() {
        Set<String> headerNames = super.getHeaderNameSet();
        if (this.server != null) {
            headerNames.add("Server");
        }
        if (this.date != null) {
            headerNames.add("Date");
        }
        return headerNames;
    }

    @Override
    public List<String> getHeaderList(String headername) {
        if (headername.equalsIgnoreCase("Server")) {
            if (this.server == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.server);
            return Collections.unmodifiableList(result);
        }
        if (headername.equalsIgnoreCase("Date")) {
            if (this.date == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.date);
            return Collections.unmodifiableList(result);
        }
        return super.getHeaderList(headername);
    }

    @Override
    public String getHeader(String headername) {
        if (headername.equalsIgnoreCase("Server")) {
            if (this.server == null) {
                return null;
            }
            return this.server;
        }
        if (headername.equalsIgnoreCase("Date")) {
            if (this.date == null) {
                return null;
            }
            return this.date;
        }
        return super.getHeader(headername);
    }

    @Override
    public boolean containsHeader(String headername) {
        if (headername.equalsIgnoreCase("Server")) {
            return this.server != null;
        }
        if (headername.equalsIgnoreCase("Date")) {
            return this.date != null;
        }
        return super.containsHeader(headername);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        HttpResponseHeader copy = (HttpResponseHeader)super.clone();
        return copy;
    }

    @Override
    public IHttpResponseHeader copy() {
        try {
            return (IHttpResponseHeader)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse.toString());
        }
    }

    @Override
    public String toString() {
        if (this.isSimpleResponse) {
            return "";
        }
        StringBuilder sb = new StringBuilder(256);
        if (this.getProtocolScheme() != null) {
            sb.append(this.getProtocolScheme());
            sb.append("/");
            sb.append(this.getProtocolVersion());
            sb.append(" ");
        }
        sb.append(this.statusCode);
        if (this.reason != null) {
            sb.append(" ");
            sb.append(this.reason);
        }
        sb.append("\r\n");
        if (this.server != null) {
            sb.append("Server: ");
            sb.append(this.server);
            sb.append("\r\n");
        }
        if (this.date != null) {
            sb.append("Date: ");
            sb.append(this.date);
            sb.append("\r\n");
        }
        this.writeHeadersTo(sb);
        return sb.toString();
    }
}

