/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui;

import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.components.LeftAlignedToggleButton;
import com.paterva.maltego.view.customization.api.CustomizableView;
import com.paterva.maltego.view.customization.api.Viewlet;
import com.paterva.maltego.view.customization.ui.ViewletIconProvider;
import com.paterva.maltego.view.customization.ui.ViewletRegistry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.WeakListeners;

public class ViewletToolbar
extends JToolBar {
    private final CustomizableView _view;
    private final ViewListener _viewListener;
    private final ViewletListener _viewletListener;
    private List<JToggleButton> _toggleButtons;

    public ViewletToolbar(CustomizableView view) {
        this._view = view;
        this.setFloatable(false);
        this.setOpaque(false);
        this.populateToolbar(false);
        this._viewletListener = new ViewletListener();
        ViewletRegistry viewletRegistry = ViewletRegistry.getDefault();
        viewletRegistry.addListener(WeakListeners.propertyChange((PropertyChangeListener)this._viewletListener, (Object)viewletRegistry));
        this._viewListener = new ViewListener();
        this._view.addViewletListener(WeakListeners.change((ChangeListener)this._viewListener, (Object)this._view));
    }

    private void populateToolbar(boolean populateWithDropDownButton) {
        this.removeAll();
        if (populateWithDropDownButton) {
            // empty if block
        }
        this.addViewletToolbarActions();
    }

    private void addViewletToolbarActions() {
        ArrayList<Viewlet> viewlets = new ArrayList<Viewlet>(ViewletRegistry.getDefault().getAll(this._view.getCustomizableViewID()));
        ToggleListener listener = new ToggleListener();
        this._toggleButtons = new ArrayList<JToggleButton>();
        Collections.sort(viewlets);
        for (Viewlet viewlet : viewlets) {
            if (!viewlet.isInToolbar()) continue;
            boolean isActive = viewlet.getName().equals(this._view.getActiveViewlet());
            this.addToggleButton(viewlet.getName(), ViewletIconProvider.getIcon(viewlet), viewlet.getName(), isActive, listener);
        }
    }

    private void addToggleButton(String actionCommand, Icon icon, String tooltip, boolean toggled, ToggleListener listener) {
        LeftAlignedToggleButton toggleButton = new LeftAlignedToggleButton();
        toggleButton.setIcon(icon);
        toggleButton.setToolTipText(tooltip);
        toggleButton.setFocusPainted(false);
        toggleButton.setActionCommand(actionCommand);
        toggleButton.addActionListener(listener);
        toggleButton.setSelected(toggled);
        toggleButton.setOpaque(false);
        this.add((Component)toggleButton);
        this._toggleButtons.add((JToggleButton)toggleButton);
    }

    private void updateToggleButtons() {
        for (JToggleButton button : this._toggleButtons) {
            button.setSelected(button.getActionCommand().equals(this._view.getActiveViewlet()));
        }
    }

    private class ViewListener
    implements ChangeListener {
        private ViewListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ViewletToolbar.this.updateToggleButtons();
        }
    }

    private class ToggleListener
    implements ActionListener {
        private ToggleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                WindowUtil.showWaitCursor();
                String actionCommand = e.getActionCommand();
                for (JToggleButton button : ViewletToolbar.this._toggleButtons) {
                    if (!actionCommand.equals(button.getActionCommand())) continue;
                    boolean select = button.isSelected();
                    if (!select) break;
                    ViewletToolbar.this._view.setActiveViewlet(actionCommand);
                    break;
                }
                ViewletToolbar.this.updateToggleButtons();
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
        }
    }

    private class ViewletListener
    implements PropertyChangeListener {
        private ViewletListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (ViewletToolbar.this._view.getCustomizableViewID().equals(evt.getPropertyName())) {
                ViewletToolbar.this.populateToolbar(false);
            }
        }
    }
}

