/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.management;

import java.lang.reflect.Method;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.management.ExecutionEvent;

final class Management {
    static final AbstractPolyglotImpl.AbstractManagementDispatch IMPL = Management.initImpl();

    private Management() {
    }

    private static AbstractPolyglotImpl.AbstractManagementDispatch initImpl() {
        try {
            Method method = Engine.class.getDeclaredMethod("getImpl", new Class[0]);
            method.setAccessible(true);
            AbstractPolyglotImpl impl = (AbstractPolyglotImpl)method.invoke(null, new Object[0]);
            impl.setMonitoring(new ManagementAccessImpl());
            return impl.getManagementDispatch();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize execution listener class.", e);
        }
    }

    private static final class ManagementAccessImpl
    extends AbstractPolyglotImpl.ManagementAccess {
        private ManagementAccessImpl() {
        }

        @Override
        public ExecutionEvent newExecutionEvent(Object event) {
            return new ExecutionEvent(event);
        }
    }
}

