/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.collect;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.GraphDataUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;

public class CollectionSettings {
    public static final String PROP_SETTINGS_CHANGED = "collectionSettingsChanged";
    private static final String PREF_COLLECTION_ENABLED = "maltego.collections.enabled";
    private static final String PREF_COLLECTION_MIN_ENTITIES = "maltego.collections.min-entities";
    private static final String PREF_COLLECTION_SHOW_TUTORIAL = "maltego.collections.show.tutorial";
    private static final String PREF_COLLECTION_RULE_RATIO = "maltego.collections.rule.ratio";
    static final int DEFAULT_MIN_REQUIRED_ENTITIES = 25;
    private static final int LOWER_LIMIT = 3;
    private static final CollectionSettings _instance = new CollectionSettings();
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);
    private boolean _limitChanged = false;
    private boolean _layoutNew = true;

    public static CollectionSettings getDefault() {
        return _instance;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(CollectionSettings.class);
    }

    public void setNextMode(GraphID graphID) {
        boolean enabled = this.isEnabled(graphID);
        enabled = !enabled;
        this.setEnabled(graphID, enabled);
    }

    public void setEnabled(GraphID graphID, boolean enabled) {
        boolean oldEnabled = this.isEnabled(graphID);
        if (enabled != oldEnabled) {
            GraphUserData.forGraph((GraphID)graphID).put((Object)PREF_COLLECTION_ENABLED, (Object)enabled);
            this.limitChangeHandled();
            this.fire(graphID);
        }
    }

    public boolean isEnabled(GraphID graphID) {
        Boolean enabled = (Boolean)GraphUserData.forGraph((GraphID)graphID).get((Object)PREF_COLLECTION_ENABLED);
        return enabled != null ? enabled : true;
    }

    private GraphID getPreviousViewGraphID() {
        GraphCookie cookie;
        TopComponent tc = GraphEditorRegistry.getDefault().getPreviousTopmost();
        if (tc != null && (cookie = (GraphCookie)tc.getLookup().lookup(GraphCookie.class)) != null) {
            return cookie.getGraphID();
        }
        return null;
    }

    public int getMinRequiredEntitiesPerNode(GraphID graphID) {
        Integer min = (Integer)GraphUserData.forGraph((GraphID)graphID).get((Object)PREF_COLLECTION_MIN_ENTITIES);
        if (min == null) {
            GraphID previousGraphID = this.getPreviousViewGraphID();
            if (previousGraphID == null) {
                min = 25;
            } else {
                CollectionSettings settings = CollectionSettings.getDefault();
                boolean enabled = settings.isEnabled(previousGraphID);
                if (!enabled) {
                    settings.setEnabled(graphID, false);
                }
                min = (min = (Integer)GraphUserData.forGraph((GraphID)previousGraphID).get((Object)PREF_COLLECTION_MIN_ENTITIES)) != null ? min : 25;
            }
            this._limitChanged = true;
            GraphUserData.forGraph((GraphID)graphID).put((Object)PREF_COLLECTION_MIN_ENTITIES, (Object)min);
        }
        return min;
    }

    public int getLowerLimitMinRequiredEntitiesPerNode() {
        return 3;
    }

    public void setMinRequiredEntitiesPerNode(GraphID graphID, int amount) {
        this.setMinRequiredEntitiesPerNode(graphID, amount, false);
    }

    private void setMinRequiredEntitiesPerNode(GraphID graphID, int amount, boolean forceSet) {
        int oldAmount;
        if (amount < 3) {
            throw new IllegalArgumentException("Cannot set the min required collection size to less than 3");
        }
        if (!forceSet && amount != (oldAmount = this.getMinRequiredEntitiesPerNode(graphID))) {
            forceSet = true;
        }
        if (forceSet) {
            this._limitChanged = true;
            GraphUserData.forGraph((GraphID)graphID).put((Object)PREF_COLLECTION_MIN_ENTITIES, (Object)amount);
            this.fire(graphID);
        }
    }

    public boolean isShowTutorial() {
        return CollectionSettings.getPreferences().getBoolean(PREF_COLLECTION_SHOW_TUTORIAL, true);
    }

    public void setShowTutorial(boolean showTutorial) {
        CollectionSettings.getPreferences().putBoolean(PREF_COLLECTION_SHOW_TUTORIAL, showTutorial);
    }

    public double getRuleRatio() {
        return CollectionSettings.getPreferences().getDouble(PREF_COLLECTION_RULE_RATIO, 1.5);
    }

    public void setRuleRatio(double ratio) {
        double oldRatio = this.getRuleRatio();
        if (ratio != oldRatio) {
            CollectionSettings.getPreferences().putDouble(PREF_COLLECTION_RULE_RATIO, ratio);
            this.fire(null);
        }
    }

    private void fire(GraphID graphID) {
        GraphDataObject gdo;
        if (graphID != null && (gdo = GraphDataUtils.getGraphDataObject((GraphID)graphID)) != null) {
            gdo.setModified(true);
        }
        this._changeSupport.firePropertyChange(PROP_SETTINGS_CHANGED, null, graphID);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    public boolean didLimitChange() {
        return this._limitChanged;
    }

    public void limitChangeHandled() {
        this._limitChanged = false;
    }

    public boolean isLayoutNew() {
        return this._layoutNew;
    }

    public void setLayoutNew(boolean layoutNew) {
        this._layoutNew = layoutNew;
    }
}

