/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.util;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollPaneUI;

public class SmoothScrollPaneUI
extends MetalScrollPaneUI {
    private static final double EPSILON = 1.0E-5;

    private SmoothScrollPaneUI() {
    }

    public static ComponentUI createUI(JComponent x) {
        return new SmoothScrollPaneUI();
    }

    @Override
    protected void installDefaults(JScrollPane scrollpane) {
        super.installDefaults(scrollpane);
        scrollpane.setBorder(null);
    }

    @Override
    protected MouseWheelListener createMouseWheelListener() {
        final MouseWheelListener delegate = super.createMouseWheelListener();
        return new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                SmoothScrollPaneUI.this.handleMouseWheelEvent(evt, delegate);
            }
        };
    }

    private void handleMouseWheelEvent(MouseWheelEvent evt, MouseWheelListener delegate) {
        if (this.scrollpane.isWheelScrollingEnabled() && evt.getScrollType() == 0) {
            this.mouseWheelMoved(evt);
            evt.consume();
        } else {
            delegate.mouseWheelMoved(evt);
        }
    }

    private void mouseWheelMoved(MouseWheelEvent e) {
        JScrollBar scrollbar = e.isShiftDown() ? this.scrollpane.getHorizontalScrollBar() : this.scrollpane.getVerticalScrollBar();
        int orientation = scrollbar.getOrientation();
        JViewport viewport = this.scrollpane.getViewport();
        if (viewport == null || !(viewport.getView() instanceof Scrollable)) {
            return;
        }
        Scrollable view = (Scrollable)((Object)viewport.getView());
        double rotation = e.getPreciseWheelRotation();
        Rectangle r = new Rectangle(new Point(0, 0), viewport.getViewSize());
        int unitIncrement = view.getScrollableUnitIncrement(r, orientation, 1);
        double delta = rotation * (double)e.getScrollAmount() * (double)unitIncrement;
        boolean limitDelta = Math.abs(rotation) < 1.00001;
        int blockIncrement = view.getScrollableBlockIncrement(r, orientation, 1);
        double adjustedDelta = limitDelta ? Math.max(-((double)blockIncrement), Math.min(delta, (double)blockIncrement)) : delta;
        int value = scrollbar.getValue();
        int newValue = Math.max(scrollbar.getMinimum(), Math.min((int)Math.round((double)value + adjustedDelta), scrollbar.getMaximum()));
        if (newValue != value) {
            scrollbar.setValue(newValue);
        }
    }
}

