/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.keycloak.models.KeycloakContext;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.policy.PasswordPolicyConfigException;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PolicyError;

public class RegexPatternsPasswordPolicyProvider
implements PasswordPolicyProvider {
    private static final String ERROR_MESSAGE = "invalidPasswordRegexPatternMessage";
    private KeycloakContext context;

    public RegexPatternsPasswordPolicyProvider(KeycloakContext context) {
        this.context = context;
    }

    public PolicyError validate(String username, String password) {
        Pattern pattern = (Pattern)this.context.getRealm().getPasswordPolicy().getPolicyConfig("regexPattern");
        Matcher matcher = pattern.matcher(password);
        if (!matcher.matches()) {
            return new PolicyError(ERROR_MESSAGE, new Object[]{pattern.pattern()});
        }
        return null;
    }

    public PolicyError validate(RealmModel realm, UserModel user, String password) {
        return this.validate(user.getUsername(), password);
    }

    public Object parseConfig(String value) {
        if (value == null) {
            throw new PasswordPolicyConfigException("Config required");
        }
        try {
            return Pattern.compile(value);
        }
        catch (PatternSyntaxException e) {
            throw new PasswordPolicyConfigException("Not a valid regular expression");
        }
    }

    public void close() {
    }
}

