/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.forms;

import com.paterva.maltego.entity.api.EntityConverter;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.entity.manager.forms.AdvancedSettingsControl;
import com.paterva.maltego.entity.registry.converter.AllEntityConverter;
import com.paterva.maltego.entity.registry.converter.RegexEntityConverter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.util.ui.dialog.DataEditController;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdvancedSettingsController
extends DataEditController<AdvancedSettingsControl, MaltegoEntitySpec> {
    private static final Logger LOG = Logger.getLogger(AdvancedSettingsController.class.getName());

    public AdvancedSettingsController() {
        super("entitySpec");
        this.setName("Advanced Settings");
        this.setDescription("Enter advanced settings for the entity. \"Text Conversion\" relates to how plaintext pasted onto a Maltego graph is mapped to an enity by the \"Regular expression\". The regular expression of entities are tested in order of ascending \"Conversion order\".");
    }

    protected AdvancedSettingsControl createComponent() {
        AdvancedSettingsControl f = new AdvancedSettingsControl();
        f.addChangeListener(this.changeListener());
        return f;
    }

    protected void setData(AdvancedSettingsControl component, MaltegoEntitySpec data) {
        EntityConverter converter = data.getConverter();
        boolean hasRegexConverter = converter instanceof RegexEntityConverter;
        int order = data.getConversionOrder();
        component.setProperties(data.getProperties());
        component.setRegex(hasRegexConverter ? converter.toString() : "");
        component.setConversionOrder(order != Integer.MAX_VALUE ? order : 1000);
        List groupProperties = null;
        if (hasRegexConverter) {
            RegexEntityConverter regexConverter = (RegexEntityConverter)converter;
            groupProperties = regexConverter.getProperties();
        }
        component.setRegexGroups(groupProperties != null ? groupProperties : new ArrayList());
        component.setIsRoot(data.isToolboxItem());
        component.setPluralName(data.getDisplayNamePlural());
    }

    protected void updateData(AdvancedSettingsControl component, MaltegoEntitySpec data) {
        boolean hasRegex = component.hasRegex();
        if (hasRegex) {
            String regex = component.getRegex();
            RegexEntityConverter converter = new RegexEntityConverter();
            String typeName = data.getTypeName();
            PropertyDescriptor valueProperty = InheritanceHelper.getValueProperty((SpecRegistry)EntityRegistry.getDefault(), (String)typeName);
            if (valueProperty != null) {
                converter.setMainProperty(valueProperty.getName());
            } else {
                LOG.log(Level.WARNING, "The value property for entity of type {0} is null", typeName);
            }
            converter.setValue(regex);
            converter.setProperties(component.getRegexGroups());
            data.setConverter((EntityConverter)converter);
            data.setConversionOrder(component.getConversionOrder());
            data.getConverter().init(regex);
        } else {
            data.setConverter((EntityConverter)AllEntityConverter.instance());
        }
        data.setToolboxItem(component.getIsRoot());
        data.setDisplayNamePlural(component.getPluralName());
    }

    protected String getFirstError(AdvancedSettingsControl component) {
        try {
            boolean hasRegex = component.hasRegex();
            if (hasRegex) {
                String regex = component.getRegex();
                RegexEntityConverter converter = new RegexEntityConverter();
                converter.init(regex);
            }
        }
        catch (Exception ex) {
            return "Invalid regex: " + ex.getMessage();
        }
        return null;
    }
}

