/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.chat;

import com.paterva.maltego.chat.ChatRoomTopComponentRegistry;
import com.paterva.maltego.chat.FilteredTopComponentRegistry;
import com.paterva.maltego.chatapi.ChatRoom;
import com.paterva.maltego.chatapi.ChatRoomCookie;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Set;
import org.openide.windows.TopComponent;

public class DefaultChatRoomRegistry
extends ChatRoomTopComponentRegistry {
    private ChatRoomFilteredRegistry _registry;
    private PropertyChangeSupport _support = new PropertyChangeSupport(this);

    public DefaultChatRoomRegistry() {
        this._registry = new ChatRoomFilteredRegistry();
        this._registry.addPropertyChangeListener(new FilteredRegistryListener());
    }

    @Override
    public ChatRoom getActiveChatRoom() {
        ChatRoomCookie cookie = this._registry.getTopmostCookie();
        return cookie != null ? cookie.getChatRoom() : null;
    }

    @Override
    public Set<ChatRoom> getChatRooms() {
        HashSet<ChatRoom> chatRooms = new HashSet<ChatRoom>();
        Set<TopComponent> open = this._registry.getOpen();
        for (TopComponent topComponent : open) {
            ChatRoom chatRoom = this.getChatRoom(topComponent);
            if (chatRoom == null) continue;
            chatRooms.add(chatRoom);
        }
        return chatRooms;
    }

    @Override
    public TopComponent getActiveChatRoomTopComponent() {
        return this._registry.getTopmost();
    }

    @Override
    public Set<TopComponent> getChatRoomTopComponents() {
        HashSet<TopComponent> topComponents = new HashSet<TopComponent>();
        Set<TopComponent> open = this._registry.getOpen();
        for (TopComponent topComponent : open) {
            ChatRoom chatRoom = this.getChatRoom(topComponent);
            if (chatRoom == null) continue;
            topComponents.add(topComponent);
        }
        return topComponents;
    }

    @Override
    public ChatRoom getChatRoom(TopComponent topComponent) {
        ChatRoomCookie cookie = (ChatRoomCookie)topComponent.getLookup().lookup(ChatRoomCookie.class);
        if (cookie != null) {
            return cookie.getChatRoom();
        }
        return null;
    }

    @Override
    public void forceUpdate() {
        this._registry.forceUpdate();
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener pcl) {
        this._support.addPropertyChangeListener(pcl);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener pcl) {
        this._support.removePropertyChangeListener(pcl);
    }

    protected synchronized void firePropertyChanged(String property, Object oldValue, Object newValue) {
        this._support.firePropertyChange(property, oldValue, newValue);
    }

    private class FilteredRegistryListener
    implements PropertyChangeListener {
        private FilteredRegistryListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TopComponent oldTC = (TopComponent)evt.getOldValue();
            TopComponent newTC = (TopComponent)evt.getNewValue();
            if ("opened".equals(evt.getPropertyName())) {
                DefaultChatRoomRegistry.this.firePropertyChanged("chatRoomAdded", oldTC, newTC);
            } else if ("closed".equals(evt.getPropertyName())) {
                DefaultChatRoomRegistry.this.firePropertyChanged("chatRoomRemoved", oldTC, newTC);
            } else if ("topmost".equals(evt.getPropertyName())) {
                DefaultChatRoomRegistry.this.firePropertyChanged("chatRoomActiveChanged", oldTC, newTC);
            }
        }
    }

    private class ChatRoomFilteredRegistry
    extends FilteredTopComponentRegistry {
        private ChatRoomFilteredRegistry() {
        }

        @Override
        public boolean isTracked(TopComponent topComponent) {
            ChatRoomCookie cookie;
            return topComponent != null && (cookie = (ChatRoomCookie)topComponent.getLookup().lookup(ChatRoomCookie.class)) != null;
        }

        public ChatRoomCookie getTopmostCookie() {
            TopComponent topmost = this.getTopmost();
            return topmost != null ? (ChatRoomCookie)topmost.getLookup().lookup(ChatRoomCookie.class) : null;
        }
    }
}

