/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.impl;

import com.paterva.maltego.graph.table.PropertyToColumnMap;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.ArrayUtilities;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class PropertyToColumnMapImpl
implements PropertyToColumnMap {
    private final Map<Integer, Object> _columnPropertyMap = new LinkedHashMap<Integer, Object>();
    private final PropertyChangeSupport _support = new PropertyChangeSupport(this);

    public void put(int column, PropertyDescriptor pd) {
        if (this.contains(column)) {
            this.setProperty(column, pd);
        } else {
            this._columnPropertyMap.put(column, pd);
        }
        this.firePropertyChanged("mappingChanged", null, null);
    }

    public void remove(int ... columns) {
        boolean changed = false;
        for (int column : columns) {
            Object pdName = this._columnPropertyMap.remove(column);
            changed = changed || pdName != null;
        }
        if (changed) {
            this.firePropertyChanged("mappingChanged", null, null);
        }
    }

    public boolean contains(int column) {
        return this._columnPropertyMap.containsKey(column);
    }

    public int[] getColumns() {
        Integer[] integerArray = this._columnPropertyMap.keySet().toArray(new Integer[this._columnPropertyMap.size()]);
        return ArrayUtilities.toPrimitiveArray((Integer[])integerArray);
    }

    public int getColumnCount() {
        return this._columnPropertyMap.size();
    }

    private void setProperty(int column, Object pd) {
        Integer updatingColumn = column;
        Object oldPd = this._columnPropertyMap.get(updatingColumn);
        if (!(oldPd == pd || oldPd != null && oldPd.equals(pd))) {
            Integer currentColumn = this.getColumn(pd);
            if (currentColumn != null) {
                this._columnPropertyMap.put(currentColumn, oldPd);
            }
            this._columnPropertyMap.put(updatingColumn, pd);
        }
    }

    private Integer getColumn(Object pd) {
        if (pd == null) {
            return null;
        }
        Set<Map.Entry<Integer, Object>> entrySet = this._columnPropertyMap.entrySet();
        for (Map.Entry<Integer, Object> entry : entrySet) {
            if (!pd.equals(entry.getValue())) continue;
            Integer column = entry.getKey();
            return column;
        }
        return null;
    }

    public PropertyDescriptor getProperty(int column) {
        if (!this.contains(column)) {
            throw new IllegalArgumentException("Column not mapped.");
        }
        return (PropertyDescriptor)this._columnPropertyMap.get(column);
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this._support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this._support.removePropertyChangeListener(pcl);
    }

    protected void firePropertyChanged(String property, Object oldValue, Object newValue) {
        this._support.firePropertyChange(property, oldValue, newValue);
    }

    public String toString() {
        return this._columnPropertyMap.toString();
    }
}

