/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.treelist;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.runregistry.item.AbstractRunCategoryItem;
import com.paterva.maltego.runregistry.item.RunProviderItem;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.runner.TransformRequestProcessor;
import com.paterva.maltego.transform.runner.analytics.RunTransformEvent;
import com.paterva.maltego.transform.runner.api.TransformRunOrigin;
import com.paterva.maltego.transform.runner.treelist.RunWithAllFilter;
import com.paterva.maltego.transform.runner.treelist.TransformRunItem;
import com.paterva.maltego.transform.runner.treelist.TransformSetItem;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.openide.util.ImageUtilities;

public class TransformsItem
extends AbstractRunCategoryItem {
    private final List<? extends RunProviderItem> _children;
    private static final String ICON_PATH = "com/paterva/maltego/transform/manager/resources/";
    private static final Icon TRANSFORM_ICON = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/transform/manager/resources/Transform.png", (boolean)true);
    private final String rootComponent;

    public TransformsItem(List<? extends RunProviderItem> children, String rootComponent) {
        this._children = children;
        this.rootComponent = rootComponent;
    }

    public List<? extends RunProviderItem> getChildren() {
        return Collections.unmodifiableList(this._children);
    }

    public String getName() {
        return "maltego.builtin." + this.getDisplayName();
    }

    public String getDisplayName() {
        return "Transforms";
    }

    public Icon getIcon() {
        return TRANSFORM_ICON;
    }

    public String getLafPrefix() {
        return "transforms-item-transforms";
    }

    public boolean canRun() {
        return false;
    }

    public void run(GraphID graphID, Set<EntityID> entities) {
        if (!entities.isEmpty()) {
            Set<TransformDefinition> transforms = this.getTransforms();
            if (!(transforms = RunWithAllFilter.filter(transforms)).isEmpty()) {
                RunTransformEvent.send(transforms, this.rootComponent);
                TransformRequestProcessor.getDefault().runTransforms(transforms, null, graphID, entities, true, TransformRunOrigin.fromDirectRun());
            }
        }
    }

    Set<TransformDefinition> getTransforms() {
        HashSet<TransformDefinition> transforms = new HashSet<TransformDefinition>();
        for (RunProviderItem runProviderItem : this._children) {
            if (runProviderItem instanceof TransformSetItem) {
                TransformSetItem setItem = (TransformSetItem)runProviderItem;
                for (RunProviderItem runProviderItem2 : setItem.getChildren()) {
                    TransformRunItem runItem = (TransformRunItem)runProviderItem2;
                    TransformDefinition transform = runItem.getTransform();
                    if (transform == null) continue;
                    transforms.add(transform);
                }
                continue;
            }
            if (!(runProviderItem instanceof TransformRunItem)) continue;
            transforms.add(((TransformRunItem)runProviderItem).getTransform());
        }
        return transforms;
    }
}

