/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.open;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.maltego.cloud.CloudGraph;
import com.maltego.cloud.crypto.GraphEncryptor;
import com.maltego.cloud.data.Case;
import com.maltego.cloud.data.CaseKey;
import com.maltego.cloud.data.CloudAttachment;
import com.maltego.cloud.data.CloudAttachments;
import com.maltego.cloud.data.CloudGraphContent;
import com.maltego.cloud.data.CloudGraphSchemaVersion;
import com.maltego.cloud.data.GraphEncryptionConfig;
import com.maltego.cloud.data.GraphHistory;
import com.maltego.cloud.data.GraphKey;
import com.maltego.cloud.data.GraphMetadata;
import com.maltego.cloud.rest.GraphStoreRestClient;
import com.maltego.cloud.serializer.NeoJsonReader;
import com.maltego.cloud.serializer.NeoSpecialProperty;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.data.GraphDataStoreWriter;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.FileStore;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.UserCancelException;

public abstract class CloudGraphOpenOperation {
    protected GraphMetadata graphMetadata;
    protected CloudGraph cloudGraph;

    private CloudGraphOpenOperation(GraphMetadata graphMetadata, CloudGraph cloudGraph) {
        this.graphMetadata = graphMetadata;
        this.cloudGraph = cloudGraph;
    }

    public static CloudGraphOpenOperation createFromMetadata(GraphMetadata graphMetadata, CloudGraph cloudGraph) {
        if (graphMetadata.isEncrypted()) {
            return new Encrypted(graphMetadata, cloudGraph);
        }
        return new Plain(graphMetadata, cloudGraph);
    }

    public void perform() throws Exception {
        Case cloudCase = GraphStoreRestClient.fetchCase((String)this.graphMetadata.getCaseId().toString());
        this.cloudGraph.setCase(cloudCase);
        String graph = this.processGraph(this.cloudGraph);
        NeoJsonReader reader = new NeoJsonReader(this.cloudGraph.getMaltegoGraphID(), this.cloudGraph.getCloudGraphId(), this.cloudGraph.isEditable().booleanValue(), this.cloudGraph.getVersion());
        boolean blockSaveToCloud = reader.readFromString(graph);
        if (blockSaveToCloud) {
            this.cloudGraph.setBlockSaveToCloud(blockSaveToCloud);
            this.cloudGraph.setMaltegoGraphID(reader.getMaltegoGraphID());
            if (!reader.isEditable()) {
                this.cloudGraph.setEditable(Boolean.FALSE);
            }
        }
        if (!this.cloudGraph.isEditable().booleanValue() && this.cloudGraph.getVersion() != null) {
            reader.setGraphName(reader.getGraphName() + " " + this.cloudGraph.getVersion().substring(this.cloudGraph.getVersion().length() - 12));
        }
        this.cloudGraph.setName(reader.getGraphName());
        this.cloudGraph.setContentMetadata(reader.getContentMetadata());
        this.downloadAttachments(this.cloudGraph, reader.getAttachmentProperties());
    }

    protected abstract String processGraph(CloudGraph var1) throws Exception;

    protected void downloadAttachments(CloudGraph cloudGraph, Map<MaltegoEntity, CloudAttachments> attachmentProps) throws Exception {
        int attCount = attachmentProps.values().stream().mapToInt(atts -> atts.getAttachments().size()).sum();
        GraphDataStoreWriter dataStoreWriter = GraphStoreHelper.getGraphStore((GraphID)cloudGraph.getMaltegoGraphID()).getGraphDataStore().getDataStoreWriter();
        for (Map.Entry<MaltegoEntity, CloudAttachments> entry : attachmentProps.entrySet()) {
            MaltegoEntity entity = entry.getKey();
            CloudAttachments cloudAttachments = entry.getValue();
            int primary = cloudAttachments.getPrimary();
            Attachments attachments = new Attachments();
            for (CloudAttachment cloudAttachment : cloudAttachments.getAttachments()) {
                Attachment attachment = this.downloadAttachment(cloudGraph, cloudAttachment, attCount);
                attachments.add((Object)attachment);
                if (primary != cloudAttachment.getIndex()) continue;
                attachments.setPrimaryImage(attachment);
            }
            DisplayDescriptor attProp = NeoSpecialProperty.ATTACHMENTS.toDisplayDescriptor();
            entity.setValue((PropertyDescriptor)attProp, (Object)attachments);
            dataStoreWriter.updateEntity(entity);
            StatusDisplayer.getDefault().setStatusText("Downloaded graph");
        }
    }

    protected Attachment downloadAttachment(CloudGraph cloudGraph, CloudAttachment attachment, int attachmentCount) throws Exception {
        int attachmentNum = attachment.getIndex();
        StatusDisplayer.getDefault().setStatusText("Syncing attachment " + (attachmentNum + 1) + "/" + attachmentCount);
        String filename = attachment.getFilename();
        String source = attachment.getSource();
        byte[] fileContent = this.processAttachment(cloudGraph, attachmentNum);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileContent);){
            int id = FileStore.getDefault().add((InputStream)inputStream, filename);
            Attachment attachment2 = new Attachment(id, new FastURL(source));
            return attachment2;
        }
    }

    protected abstract byte[] processAttachment(CloudGraph var1, int var2) throws Exception;

    private static class Encrypted
    extends CloudGraphOpenOperation {
        private Encrypted(GraphMetadata graphMetadata, CloudGraph cloudGraph) {
            super(graphMetadata, cloudGraph);
        }

        @Override
        public String processGraph(CloudGraph cloudGraph) throws Exception {
            GraphEncryptionConfig encryptionConfig;
            String graphJson;
            GraphEncryptor encryptor;
            block2: {
                CaseKey caseKey = GraphStoreRestClient.fetchCaseKey((String)this.graphMetadata.getCaseId().toString());
                GraphKey graphKey = GraphStoreRestClient.fetchGraphKey((String)this.graphMetadata.getCaseId().toString(), (String)this.graphMetadata.getId());
                encryptor = GraphEncryptor.forExistingGraph((CaseKey)caseKey, (GraphKey)graphKey);
                cloudGraph.addToLookup((Object)encryptor);
                graphJson = GraphStoreRestClient.fetchCloudGraphJson((String)cloudGraph.getCloudGraphId().toString(), (String)cloudGraph.getVersion(), (CloudGraphSchemaVersion)cloudGraph.getRequestedSchemaVersion());
                ObjectMapper mapper = new ObjectMapper();
                CloudGraphContent cloudGraphContent = (CloudGraphContent)mapper.readValue(graphJson, CloudGraphContent.class);
                encryptionConfig = cloudGraphContent.getEncryption();
                cloudGraph.addToLookup((Object)encryptionConfig);
                GraphHistory graphHistory = GraphStoreRestClient.fetchGraphHistory((String)this.graphMetadata.getId());
                try {
                    encryptor.verifyEncryptedGraphJson(graphHistory.getMac(), graphJson);
                }
                catch (Exception e) {
                    boolean doNotOpen;
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)"<html>Encrypted graph data could not be verified.<br><br>Do you still want to open the graph?", "Open From Cloud", 2);
                    Object notify = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    boolean bl = doNotOpen = !NotifyDescriptor.OK_OPTION.equals(notify);
                    if (!doNotOpen) break block2;
                    throw new UserCancelException("User cancelled Open From Cloud operation");
                }
            }
            return encryptor.decryptGraphJson(encryptionConfig, graphJson);
        }

        @Override
        protected byte[] processAttachment(CloudGraph cloudGraph, int attachmentNum) throws Exception {
            byte[] encryptedFileContent = GraphStoreRestClient.fetchCloudGraphAttachments((String)cloudGraph.getCloudGraphId().toString(), (int)attachmentNum, (String)cloudGraph.getVersion());
            GraphEncryptor encryptor = (GraphEncryptor)cloudGraph.getContentFromLookup(GraphEncryptor.class);
            GraphEncryptionConfig graphEncryptionConfig = (GraphEncryptionConfig)cloudGraph.getContentFromLookup(GraphEncryptionConfig.class);
            return encryptor.decryptFileContent(graphEncryptionConfig, encryptedFileContent);
        }
    }

    private static class Plain
    extends CloudGraphOpenOperation {
        private Plain(GraphMetadata graphMetadata, CloudGraph cloudGraph) {
            super(graphMetadata, cloudGraph);
        }

        @Override
        public String processGraph(CloudGraph cloudGraph) throws Exception {
            return GraphStoreRestClient.fetchCloudGraphJson((String)cloudGraph.getCloudGraphId().toString(), (String)cloudGraph.getVersion(), (CloudGraphSchemaVersion)cloudGraph.getRequestedSchemaVersion());
        }

        @Override
        protected byte[] processAttachment(CloudGraph cloudGraph, int attachmentNum) throws Exception {
            return GraphStoreRestClient.fetchCloudGraphAttachments((String)cloudGraph.getCloudGraphId().toString(), (int)attachmentNum, (String)cloudGraph.getVersion());
        }
    }
}

