/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates;

import com.paterva.maltego.certificates.impl.CertificateDefinitionKeyUsage;
import com.paterva.maltego.certificates.impl.ExtensionStringUtil;
import com.paterva.maltego.util.NormalException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.openide.filesystems.FileObject;

public class CertificateDefinition {
    private final X509Certificate _cert;
    private final List<String> _keyUsage = new ArrayList<String>();
    private CertPublicKey _publicKey;
    private final String _signature;
    private final String _serialNumber;
    private final Map<String, String> _critExtenstions = new HashMap<String, String>();
    private final Map<String, String> _nonCritExtenstions = new HashMap<String, String>();
    private String _extensionsString;
    private boolean _trusted;
    private boolean _caCertificate;
    private List<String> _subjectAlternativeNames;
    private FileObject _fileObject;
    private List<String> _hostnames;
    private static final Logger LOG = Logger.getLogger(CertificateDefinition.class.getName());

    public CertificateDefinition(X509Certificate cert) {
        this(cert, false);
    }

    public CertificateDefinition(X509Certificate cert, boolean trusted) {
        this(cert, trusted, null, null);
    }

    public CertificateDefinition(X509Certificate cert, boolean trusted, String hostname) {
        this(cert, trusted, null, (List<String>)(hostname == null ? null : new ArrayList<String>(Arrays.asList(hostname))));
    }

    public CertificateDefinition(X509Certificate cert, boolean trusted, FileObject file, List<String> hostnames) {
        this._cert = cert;
        this._trusted = trusted;
        this._fileObject = file;
        hostnames = hostnames == null ? new ArrayList<String>() : hostnames;
        hostnames.replaceAll(String::toLowerCase);
        this._hostnames = hostnames;
        this.createKeyUsage();
        this.createPublicKey();
        this._signature = Hex.toHexString((byte[])this._cert.getSignature());
        this._serialNumber = Hex.toHexString((byte[])this._cert.getSerialNumber().toByteArray()).toUpperCase();
        this.createCritExtensions();
        this.createNonCritExtensions();
        this.createExtensionsString();
        this.checkIfCa();
        this.createSubjectAlternativeNames();
    }

    public X509Certificate getCertificate() {
        return this._cert;
    }

    public CertDistinguishedName getIssuer() throws GeneralSecurityException {
        return new CertDistinguishedName(this.getBCHolder().getIssuer());
    }

    public CertDistinguishedName getSubject() throws GeneralSecurityException {
        return new CertDistinguishedName(this.getBCHolder().getSubject());
    }

    public String getIssuerName() {
        String name;
        try {
            name = this.getIssuer().getName();
        }
        catch (GeneralSecurityException ex) {
            NormalException.logStackTrace((Throwable)ex);
            name = "Invalid Issuer: " + ex.getMessage();
        }
        return name;
    }

    public String getSubjectName() {
        String name;
        try {
            name = this.getSubject().getName();
        }
        catch (GeneralSecurityException ex) {
            NormalException.logStackTrace((Throwable)ex);
            name = "Invalid Subject: " + ex.getMessage();
        }
        return name;
    }

    public List<String> getKeyUsage() {
        return this._keyUsage;
    }

    public CertPublicKey getPublicKey() {
        return this._publicKey;
    }

    public String getSignature() {
        return this._signature;
    }

    public String getSerialNumber() {
        return this._serialNumber;
    }

    public Map<String, String> getCritExtenstions() {
        return this._critExtenstions;
    }

    public Map<String, String> getNonCritExtenstions() {
        return this._nonCritExtenstions;
    }

    public String getExtensionsString() {
        return this._extensionsString;
    }

    public String getDisplayName() {
        return this.getSubjectName();
    }

    public String getDescription() {
        return this.getDisplayName();
    }

    public boolean isTrusted() {
        return this._trusted;
    }

    public void setTrusted(boolean trusted) {
        this._trusted = trusted;
    }

    public boolean isCaCertificate() {
        return this._caCertificate;
    }

    public FileObject getFileObject() {
        return this._fileObject;
    }

    public void setFileObject(FileObject fileObject) {
        this._fileObject = fileObject;
    }

    public List<String> getHostnames() {
        return this._hostnames;
    }

    public void addHostname(String hostname) {
        String string = hostname = hostname == null ? null : hostname.toLowerCase();
        if (hostname != null && !this._hostnames.contains(hostname)) {
            this._hostnames.add(hostname);
        }
    }

    public List<String> getSubjectAlternativeNames() {
        return this._subjectAlternativeNames;
    }

    private X509CertificateHolder getBCHolder() throws CertificateEncodingException {
        return new JcaX509CertificateHolder(this._cert);
    }

    private void createKeyUsage() {
        boolean[] keyUsage = this._cert.getKeyUsage();
        if (keyUsage != null) {
            for (int i = 0; i < keyUsage.length; ++i) {
                if (!keyUsage[i]) continue;
                this._keyUsage.add(CertificateDefinitionKeyUsage.getEnum(i).getName());
            }
        }
    }

    private void createPublicKey() {
        PublicKey publicKey = this._cert.getPublicKey();
        if (publicKey != null) {
            if (publicKey instanceof RSAPublicKey) {
                RSAPublicKey rsa = (RSAPublicKey)publicKey;
                int keySizeBits = rsa.getModulus().bitLength();
                int keySizeBytes = (keySizeBits + 8 - 1) / 8;
                this._publicKey = new CertPublicKey(rsa.getAlgorithm(), rsa.getEncoded(), rsa.getFormat(), null, rsa.getModulus(), rsa.getPublicExponent(), keySizeBytes);
            } else if (publicKey instanceof ECPublicKey) {
                ECPublicKey ec = (ECPublicKey)publicKey;
                ECParameterSpec params = ec.getParams();
                int keySizeBits = params == null ? -1 : params.getCurve().getField().getFieldSize();
                int keySizeBytes = keySizeBits == -1 ? -1 : keySizeBits + 7 >>> 3;
                this._publicKey = new CertPublicKey(ec.getAlgorithm(), ec.getEncoded(), ec.getFormat(), params == null ? null : params.toString(), null, null, keySizeBytes);
            } else if (publicKey instanceof DSAPublicKey) {
                DSAPublicKey dsa = (DSAPublicKey)publicKey;
                int keySizeBits = dsa.getY().bitLength();
                int keySizeBytes = (keySizeBits + 8 - 1) / 8;
                DSAParams params = dsa.getParams();
                this._publicKey = new CertPublicKey(dsa.getAlgorithm(), dsa.getEncoded(), dsa.getFormat(), params == null ? null : params.toString(), null, null, keySizeBytes);
            }
        }
    }

    private void createCritExtensions() {
        Set<String> critSet = this._cert.getCriticalExtensionOIDs();
        this.createExtensions(critSet, this._critExtenstions);
    }

    private void createNonCritExtensions() {
        Set<String> nonCritSet = this._cert.getNonCriticalExtensionOIDs();
        this.createExtensions(nonCritSet, this._nonCritExtenstions);
    }

    private void createExtensions(Set<String> extSet, Map<String, String> exts) {
        if (extSet != null && !extSet.isEmpty()) {
            for (String oid : extSet) {
                byte[] extensionValue = this._cert.getExtensionValue(oid);
                if (extensionValue == null) continue;
                try {
                    exts.put(oid, this.getExtensionValue(extensionValue));
                }
                catch (IOException ex) {
                    LOG.log(Level.FINEST, ex.toString());
                }
            }
        }
    }

    private String getExtensionValue(byte[] extensionValue) throws IOException {
        ASN1Primitive derObject;
        String decoded = "";
        if (extensionValue != null && (derObject = X509ExtensionUtil.fromExtensionValue((byte[])extensionValue)) != null) {
            decoded = derObject.toString();
        }
        return decoded;
    }

    private void createExtensionsString() {
        try {
            Extensions extensions = this.getBCHolder().getExtensions();
            this._extensionsString = ExtensionStringUtil.toString(extensions);
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Certificate extension String creation failed: {0}", ex.toString());
        }
    }

    private void checkIfCa() {
        try {
            byte[] asn1EncodedBytes = this._cert.getExtensionValue("2.5.29.19");
            if (asn1EncodedBytes == null) {
                this._caCertificate = false;
            }
            DEROctetString derOctetString = (DEROctetString)new ASN1InputStream(asn1EncodedBytes).readObject();
            byte[] octets = derOctetString.getOctets();
            ASN1Sequence sequence = (ASN1Sequence)new ASN1InputStream(octets).readObject();
            this._caCertificate = BasicConstraints.getInstance((Object)sequence).isCA();
        }
        catch (Exception ex) {
            this._caCertificate = false;
        }
    }

    private void createSubjectAlternativeNames() {
        ArrayList<String> identities = new ArrayList<String>();
        try {
            Collection<List<?>> altNames = this._cert.getSubjectAlternativeNames();
            if (altNames != null) {
                for (List<?> item : altNames) {
                    Integer type = (Integer)item.get(0);
                    if (type == 0 || type == 2 || type == 7) {
                        try {
                            ASN1InputStream decoder = null;
                            if (item.toArray()[1] instanceof byte[]) {
                                decoder = new ASN1InputStream((byte[])item.toArray()[1]);
                            } else {
                                String name = item.toArray()[1] instanceof String ? (String)item.toArray()[1] : item.toArray()[1].toString();
                                String string = name = name == null ? null : name.toLowerCase();
                                if (!identities.contains(name)) {
                                    identities.add(name);
                                }
                            }
                            if (decoder == null) continue;
                            ASN1Primitive encoded = decoder.readObject();
                            encoded = ((DERSequence)encoded).getObjectAt(1);
                            encoded = ((DERTaggedObject)encoded).getObject();
                            String identity = ((DERUTF8String)(encoded = ((DERTaggedObject)encoded).getObject())).getString();
                            identity = identity == null ? null : identity.toLowerCase();
                            if (identities.contains(identity)) continue;
                            identities.add(identity);
                        }
                        catch (UnsupportedEncodingException e) {
                            LOG.log(Level.WARNING, "Error decoding subjectAltName: {0}", e.toString());
                        }
                        catch (Exception e) {
                            LOG.log(Level.WARNING, "Error decoding subjectAltName: {0}", e.toString());
                        }
                        continue;
                    }
                    LOG.log(Level.WARNING, "SubjectAltName of invalid type found: {0}", this._cert);
                }
            }
        }
        catch (CertificateParsingException e) {
            LOG.log(Level.WARNING, "Error parsing SubjectAltName in certificate {0}: {1}", new Object[]{this._cert, e.toString()});
        }
        this._subjectAlternativeNames = identities;
    }

    public class CertPublicKey {
        private final String _alg;
        private final String _encoded;
        private final String _format;
        private final String _params;
        private final String _modulus;
        private final BigInteger _exponent;
        private final int _keySizeBytes;

        public CertPublicKey(String alg, byte[] encoded, String format, String params, BigInteger modulus, BigInteger exponent, int keySize) {
            this._alg = alg;
            this._encoded = Hex.toHexString((byte[])encoded);
            this._format = format;
            this._params = params;
            this._modulus = modulus == null ? null : Hex.toHexString((byte[])modulus.toByteArray());
            this._exponent = exponent;
            this._keySizeBytes = keySize;
        }

        public String getAlg() {
            return this._alg;
        }

        public String getEncoded() {
            return this._encoded;
        }

        public String getFormat() {
            return this._format;
        }

        public String getParams() {
            return this._params;
        }

        public String getModulus() {
            return this._modulus;
        }

        public BigInteger getExponent() {
            return this._exponent;
        }

        public int getKeySizeBytes() {
            return this._keySizeBytes;
        }
    }

    public class CertDistinguishedName {
        private final X500Name _name;

        public CertDistinguishedName(X500Name name) {
            this._name = name;
        }

        public String getCountry() {
            return this.getRdnString(BCStyle.C);
        }

        public String getOrg() {
            return this.getRdnString(BCStyle.O);
        }

        public String getName() {
            String cn = this.getRdnString(BCStyle.CN);
            cn = cn == null ? null : cn.toLowerCase();
            return cn;
        }

        public String getRdnString(ASN1ObjectIdentifier identifier) {
            ArrayList<String> values = new ArrayList<String>();
            for (RDN rdn : this._name.getRDNs(identifier)) {
                for (AttributeTypeAndValue typesAndValue : rdn.getTypesAndValues()) {
                    values.add(IETFUtils.valueToString((ASN1Encodable)typesAndValue.getValue()));
                }
            }
            return values.stream().collect(Collectors.joining(" "));
        }
    }
}

