/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.crypto;

import com.paterva.maltego.crypto.MaltegoClientCryptographer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;

public class SignedData {
    private final byte[] blob;
    private final byte[] signature;

    public SignedData(byte[] blob, byte[] signature) {
        this.blob = blob;
        this.signature = signature;
    }

    public byte[] getBlob() {
        return this.blob;
    }

    public String getBlobString() {
        return new String(this.blob, StandardCharsets.UTF_8);
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public boolean isValidSignature() throws GeneralSecurityException {
        MaltegoClientCryptographer verifier = MaltegoClientCryptographer.getInstance();
        byte[] blobBase64 = Base64.getEncoder().encode(this.blob);
        return verifier.verify(blobBase64, this.signature);
    }
}

