<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template name="burp-finding">
    <xsl:param name="issue"/>
        <url><xsl:value-of select="concat($issue/host, $issue/path)"/>
        <finding class="MtTextObject" status="new">
            <xsl:attribute name="title">
                <xsl:value-of select="$issue/name" />
            </xsl:attribute>
            <xsl:attribute name="mergeID" >
                <xsl:value-of select="$issue/serialNumber" />
            </xsl:attribute>
            <source>burp</source>
            <id><xsl:value-of select="$issue/type" /></id>
            <xsl:call-template name="burp-severity">
                 <xsl:with-param name="severity" select="$issue/severity"/>
            </xsl:call-template>
            <xsl:value-of select="$issue/issueBackground" />
            <solution title="Solution" class="MtTextObject">
                <xsl:value-of select="$issue/remediationBackground" />
            </solution>
            <output title="Details" class="MtTextObject">
                <xsl:value-of select="$issue/issueDetail" />
            </output>
            <affects><xsl:value-of select="concat($issue/host, $issue/location)"/></affects>
            <xsl:for-each select="requestresponse">
            <requestresponse><xsl:number value="position()" format="1"/>
            <request class="MtTextObject" title="Request">
            <xsl:value-of select="request" />
            </request>
            <response class="MtTextObject" title="Response">
            <xsl:value-of select="response" />
            </response>
            </requestresponse>
            </xsl:for-each>
        </finding>
        </url>
  </xsl:template>


<xsl:template name="burp-severity">
<xsl:param name="severity" />
<source-severity>
<xsl:choose>
 <xsl:when test="$severity='High'">
high<numeric>3</numeric>
 </xsl:when>
 <xsl:when test="$severity='Medium'">
medium<numeric>3</numeric>
 </xsl:when>
 <xsl:when test="$severity='Low'">
low<numeric>1</numeric>
 </xsl:when>
 <xsl:when test="$severity='Information'">
info<numeric>0</numeric>
 </xsl:when>
 <xsl:otherwise>
unknown<numeric>-1</numeric>
 </xsl:otherwise>
</xsl:choose>
</source-severity>
</xsl:template>

<xsl:template name="get-port">
<xsl:param name="host" />
    <xsl:variable name="proto" select="substring-before($host, ':')"/>
    <xsl:variable name="host-port" select="substring-after($host, '://')"/>
    <xsl:choose>
        <xsl:when test="string-length(substring-after($host-port,':'))>0">
        <!-- The port is explicitly specified-->
            <xsl:value-of select="substring-after($host-port,':')" />
        </xsl:when>
        <xsl:otherwise>
            <xsl:choose>
                <xsl:when test="$proto='https'">
                443
                </xsl:when>
                <xsl:otherwise>
                80
                </xsl:otherwise>
            </xsl:choose>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

  <xsl:template match="/">
    <magictree class="MtBranchObject" xmlns:mt="http://www.gremwell.com/magictree">
      <testdata class="MtBranchObject">
        <xsl:for-each select="issues/issue">
          <host><xsl:value-of select="host/@ip" />
                <ipproto>tcp
                    <port>
                    <xsl:call-template name="get-port">
                        <xsl:with-param name="host" select="host"/>
                    </xsl:call-template>
                    <xsl:choose>
                        <xsl:when test="starts-with(host,'https')">
                        <tunnel>ssl
                            <service>http
                                <xsl:call-template name="burp-finding">
                                    <xsl:with-param name="issue" select="."/>
                                </xsl:call-template>
                            </service>
                        </tunnel>
                        </xsl:when>
                        <xsl:otherwise>
                        <service>http
                                <xsl:call-template name="burp-finding">
                                    <xsl:with-param name="issue" select="."/>
                                </xsl:call-template>
                        </service>
                        </xsl:otherwise>
                    </xsl:choose>
                 </port>
                </ipproto>
          </host>
        </xsl:for-each>
      </testdata>
    </magictree>
  </xsl:template>
</xsl:stylesheet>
