#?description=Reload previously saved breakpoints onto the current debugging session. (The session must be started first.)
#?shortcut=
import json
import os
import time
from com.pnfsoftware.jeb.client.api import IScript
from com.pnfsoftware.jeb.core import RuntimeProjectUtil
from com.pnfsoftware.jeb.core.units.code.debug import IDebuggerUnit
"""
Sample script for JEB Decompiler.

Reload previously saved breakpoints onto the current debugging session. The session must be started first.
- Breakpoints file: [JEB]/bin/breakpoints.txt
- See converse script to save breakpoints ot a file: BreakpointsSave.py
"""
class BreakpointsLoad(IScript):

  def run(self, ctx):
    prj = ctx.getMainProject()
    assert prj, 'Need a project'

    prjname = prj.getName()

    prgdir = ctx.getProgramDirectory()
    bpfile = os.path.join(prgdir, 'breakpoints.txt')
    with open(bpfile, 'r+') as f:
      try:
        bpdict = json.load(f)
      except:
        bpdict = {}
    #print('Current breakpoints file:', bpdict)

    d = bpdict.get(prjname, None)
    if not d:
      print('Nothing to reload')
      return

    # get the first code unit available (code units re interactive units)
    units = RuntimeProjectUtil.findUnitsByType(prj, IDebuggerUnit, False)
    if not units:
      print('No unit available')
      return

    cnt = 0
    for dbg in units:
      a = d.get(dbg.getName(), None)
      if a:
        print(a)
        for entry in a:
          address = entry['address']
          enabled = entry['enabled']
          #print('- Debugger: %s (for %s): %s (%s)' % (dbg.getName(), dbg.getPotentialDebuggees(), address, 'enabled' if enabled else 'disabled'))
          bp = dbg.getBreakpoint(address, None)
          if not bp:  # do not overwrite an already-set breakpoint
            bp = dbg.setBreakpoint(address, None)
            if bp:
              if not enabled:
                bp.setEnabled(False)
              cnt += 1
            else:
              print('Cannot restore breakpoint at address: %s' % address)

    print('Breakpoints reloaded: %d.' % cnt)
