#!/bin/bash

# Start-up script for JEB (macOS)

# Prefer local JRE
JAVA=bin/runtime/bin/java
if [ ! -f "$JAVA" ]; then

  # Prefer a JDK over a JRE
  if [ -z "$JAVA_HOME" ]; then
    JAVA=`which java`
  else
    JAVA="$JAVA_HOME/bin/java"
  fi

  # Note: If the Java path generation does not yield a correct result, manually set
  # the JAVA variable (defined above) to a correct value
  if [ ! -f "$JAVA" ]; then
    echo "JEB requires a Java JDK 17"
    echo "It is also recommended to set the JAVA_HOME environment variable to point to your JDK"
    exit -1
  fi
fi

cd "`dirname "$0"`"
BASEDIR=`pwd -P`
cd - >/dev/null

JVMOPT=
if [ -f "$BASEDIR/jvmopt.txt" ]; then
  JVMOPT=$(<"$BASEDIR/jvmopt.txt")
fi
# Manual override for JVM options: run the script with -j, uncomment the following line and adjust if necessary
# JVMOPT="-Xss4M -Xmx8G"

INSTALLER="$BASEDIR/bin/app/jebi.jar"
if !([ -f "$INSTALLER" ]); then
  INSTALLER_NEW="$BASEDIR/bin/app/jebi.jar.new"
  if [ -f "$INSTALLER_NEW" ]; then
    mv "$INSTALLER_NEW" "$INSTALLER"
  else
    echo "The JEB Installer (jebi.jar) was not found!"
    exit -1  
  fi
fi
"$JAVA" -jar "$INSTALLER" --di --up --timeout=0 -- "$@"
RETCODE=$?
if [ $RETCODE -lt 0 ]; then
  exit $RETCODE
fi

if [ "$1" == "-c" ]; then
  shift
  "$JAVA" $JVMOPT -jar "$BASEDIR/bin/app/jeb.jar" "$@"
  exit 0
fi

if [ "$1" == "-j" ]; then
  shift
else
  JEB="$BASEDIR/bin/jeb"
  if [ -f "$JEB" ]; then
    chmod +x "$JEB"
    # DISABLING NATIVE LAUNCHER ON MACOS (April 2, 2019)
    # the native launcher creates problems when spawning processes and attempting to read their output
    # this can lead to difficulties in using Debugger modules, for instance
    # (if things work fine on your system, you may choose to uncomment the lines below)
    #echo "Starting JEB Desktop Client... (logging to bin/jeb.log)"
    #echo "(If it does not start on your system, use the '-j' flag: ./jeb_macos.sh -j)"
    #nohup "$JEB" --cd="$PWD" "$@" </dev/null &>$BASEDIR/bin/jeb.log &
    #exit 0
  fi
fi
"$JAVA" $JVMOPT -XstartOnFirstThread -Dorg.eclipse.swt.internal.carbon.smallFonts -jar "$BASEDIR/bin/app/jebc.jar" "$@"
exit 0
