/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt.metrics;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class OptionalMethod {
    private final Method cachedMethod;

    public OptionalMethod(Class<?> clazz, String methodName, Class<?> ... methodParams) {
        this.cachedMethod = OptionalMethod.initializeMethod(clazz, methodName, methodParams);
    }

    private static Method initializeMethod(Class<?> clazz, String methodName, Class<?> ... methodParams) {
        try {
            for (Class<?> paramClass : methodParams) {
                if (paramClass != null) continue;
                return null;
            }
            if (clazz != null) {
                return clazz.getMethod(OptionalMethod.checkNotNull(methodName), methodParams);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public Object invokeStatic(Object ... args) {
        if (this.cachedMethod == null) {
            return null;
        }
        try {
            return this.cachedMethod.invoke(null, args);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public Object invoke(Object target, Object ... args) {
        if (this.cachedMethod == null || target == null) {
            return null;
        }
        try {
            return this.cachedMethod.invoke(target, args);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    private static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new NullPointerException();
        }
        return reference;
    }
}

