/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.pqc.crypto.cmce;

import java.security.SecureRandom;
import org.python.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.python.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.python.bouncycastle.crypto.KeyGenerationParameters;
import org.python.bouncycastle.pqc.crypto.cmce.CMCEEngine;
import org.python.bouncycastle.pqc.crypto.cmce.CMCEKeyGenerationParameters;
import org.python.bouncycastle.pqc.crypto.cmce.CMCEPrivateKeyParameters;
import org.python.bouncycastle.pqc.crypto.cmce.CMCEPublicKeyParameters;

public class CMCEKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private CMCEKeyGenerationParameters cmceParams;
    private int m;
    private int n;
    private int t;
    private SecureRandom random;

    private void initialize(KeyGenerationParameters keyGenerationParameters) {
        this.cmceParams = (CMCEKeyGenerationParameters)keyGenerationParameters;
        this.random = keyGenerationParameters.getRandom();
        this.m = this.cmceParams.getParameters().getM();
        this.n = this.cmceParams.getParameters().getN();
        this.t = this.cmceParams.getParameters().getT();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        CMCEEngine cMCEEngine = this.cmceParams.getParameters().getEngine();
        byte[] byArray = new byte[cMCEEngine.getPrivateKeySize()];
        byte[] byArray2 = new byte[cMCEEngine.getPublicKeySize()];
        cMCEEngine.kem_keypair(byArray2, byArray, this.random);
        CMCEPublicKeyParameters cMCEPublicKeyParameters = new CMCEPublicKeyParameters(this.cmceParams.getParameters(), byArray2);
        CMCEPrivateKeyParameters cMCEPrivateKeyParameters = new CMCEPrivateKeyParameters(this.cmceParams.getParameters(), byArray);
        return new AsymmetricCipherKeyPair(cMCEPublicKeyParameters, cMCEPrivateKeyParameters);
    }

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.initialize(keyGenerationParameters);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

