/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jebglobal;

import com.pnfsoftware.jeb.core.AbstractEnginesPlugin;
import com.pnfsoftware.jeb.core.IEnginesContext;
import com.pnfsoftware.jeb.core.ILiveArtifact;
import com.pnfsoftware.jeb.core.IOptionDefinition;
import com.pnfsoftware.jeb.core.IPluginInformation;
import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.OptionDefinition;
import com.pnfsoftware.jeb.core.PluginInformation;
import com.pnfsoftware.jeb.core.Version;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.util.encoding.Hash;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jebglobal.csq;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class csp
extends AbstractEnginesPlugin {
    private static final ILogger ce = GlobalLog.getLogger(csp.class);
    private IEnginesContext mm;
    private IEventListener fz;
    private String Rs;
    private static final String ok = ".VirusTotalApiKey";

    @Override
    public IPluginInformation getPluginInformation() {
        return new PluginInformation("VT Report Plugin", "Display and record VirusTotal reports for top-level binary units processed in JEB", "PNF Software", Version.create(1, 0, 0));
    }

    @Override
    public void load(IEnginesContext iEnginesContext) {
        this.mm = iEnginesContext;
        this.Rs = this.ce(iEnginesContext);
        this.fz = new csq(this);
        iEnginesContext.addListener(this.fz);
    }

    @Override
    public void dispose() {
        if (this.fz != null) {
            this.mm.removeListener(this.fz);
            this.fz = null;
        }
    }

    @Override
    public List<? extends IOptionDefinition> getExecutionOptionDefinitions() {
        return Arrays.asList(new OptionDefinition(null, "Specify or update your VirusTotal API key:"), new OptionDefinition("apikey", this.Rs, "VirusTotal API Key"));
    }

    @Override
    public void execute(IEnginesContext iEnginesContext, Map<String, String> map) {
        if (map != null) {
            this.Rs = map.get("apikey");
            if (this.Rs != null) {
                this.ce(iEnginesContext, this.Rs);
            }
        }
        if (this.Rs == null) {
            ce.error("In order to use the VirusTotal Scan Report plugin, set up your VT API key first!", new Object[0]);
            return;
        }
        this.mm(iEnginesContext);
    }

    private String ce(IEnginesContext iEnginesContext) {
        try {
            return iEnginesContext.getPropertyManager().getString(ok);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean ce(IEnginesContext iEnginesContext, String string) {
        try {
            iEnginesContext.getPropertyManager().setString(ok, string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void mm(IEnginesContext iEnginesContext) {
        for (IRuntimeProject iRuntimeProject : iEnginesContext.getProjects()) {
            for (ILiveArtifact iLiveArtifact : iRuntimeProject.getLiveArtifacts()) {
                for (IUnit iUnit : iLiveArtifact.getUnits()) {
                    if (!(iUnit instanceof IBinaryUnit)) continue;
                    try {
                        this.ce((IBinaryUnit)iUnit);
                    }
                    catch (Exception exception) {
                        ce.catching(exception);
                    }
                }
            }
        }
    }

    private boolean ce(IBinaryUnit iBinaryUnit) throws IOException, ParseException {
        String string;
        Object object;
        if (Strings.isBlank(this.Rs)) {
            return false;
        }
        try (Object object2 = iBinaryUnit.getInput().getStream();){
            object = IO.readInputStream((InputStream)object2);
            string = Formatter.byteArrayToHexString(Hash.calculateSHA256((byte[])object)).toLowerCase();
        }
        ce.debug("Verifying SHA-256 hash on VirustTotal: %s", string);
        object2 = Strings.ff("https://www.virustotal.com/vtapi/v2/file/report?apikey=%s&resource=%s", this.Rs, string);
        object = this.mm.getNetworkUtility().query((String)object2);
        ce.debug((String)object, new Object[0]);
        if (object == null || ((String)object).isEmpty()) {
            return false;
        }
        Map map = (Map)new JSONParser().parse((String)object);
        Long l2 = (Long)map.get("response_code");
        if (l2 == null) {
            ce.debug("Invalid VT answer: %s", object2);
            return false;
        }
        if (l2 == 0L) {
            UnitUtil.logInfo(iBinaryUnit, null, true, ce, "VT: unknown file", new Object[0]);
        } else if (l2 == 1L) {
            long l3 = (Long)map.get("positives");
            long l4 = (Long)map.get("total");
            String string2 = (String)map.get("scan_date");
            UnitUtil.logInfo(iBinaryUnit, null, true, ce, "VT Report: %d/%d (%s)", l3, l4, string2);
        } else if (l2 == 2L) {
            UnitUtil.logInfo(iBinaryUnit, null, false, ce, "VT: analysis in progress", new Object[0]);
        } else {
            UnitUtil.logInfo(iBinaryUnit, null, false, ce, "VT: error - unknown response_code", new Object[0]);
        }
        return true;
    }
}

